/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.factory;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.matomo.factory.MatomoRequestDetailsEnricher;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.usage.UsageEvent;

public class MatomoRequestCountryEnricher
implements MatomoRequestDetailsEnricher {
    private static final Logger log = LogManager.getLogger(MatomoRequestCountryEnricher.class);

    @Override
    public MatomoRequestDetails enrich(UsageEvent usageEvent, MatomoRequestDetails matomoRequestDetails) {
        return matomoRequestDetails.addParameter("country", this.getCountry(usageEvent.getRequest()));
    }

    private String getCountry(HttpServletRequest request) {
        String country = "";
        if (request != null) {
            try {
                Locale locale = request.getLocale();
                if (locale != null) {
                    country = locale.getCountry().toLowerCase();
                }
            }
            catch (Exception e) {
                log.error("Cannot get locale of request!", (Throwable)e);
            }
        }
        return country;
    }
}

