/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;

public class EnhancedJsonPathAttributeConditionMetadataContributor
implements MetadataContributor<String> {
    private static final Logger log = LogManager.getLogger();
    private String query;
    private String conditionKey;
    private String conditionValue;
    private String elementAttribute;
    private MetadataFieldConfig field;
    protected JsonPathMetadataProcessor metadataProcessor;
    protected JsonPathMetadataProcessor metadataPostProcessor;

    public EnhancedJsonPathAttributeConditionMetadataContributor(String query, MetadataFieldConfig field) {
        this.query = query;
        this.field = field;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<String, MetadataContributor<String>> rt) {
    }

    public EnhancedJsonPathAttributeConditionMetadataContributor() {
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getConditionKey() {
        return this.conditionKey;
    }

    public void setConditionKey(String conditionKey) {
        this.conditionKey = conditionKey;
    }

    public String getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(String conditionValue) {
        this.conditionValue = conditionValue;
    }

    public String getElementAttribute() {
        return this.elementAttribute;
    }

    public void setElementAttribute(String elementAttribute) {
        this.elementAttribute = elementAttribute;
    }

    public void setMetadataProcessor(JsonPathMetadataProcessor metadataProcessor) {
        this.metadataProcessor = metadataProcessor;
    }

    public void setMetadataPostProcessor(JsonPathMetadataProcessor metadataPostProcessor) {
        this.metadataPostProcessor = metadataPostProcessor;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(String fullJson) {
        ArrayList<MetadatumDTO> metadata = new ArrayList<MetadatumDTO>();
        Collection<Object> metadataValue = new ArrayList();
        if (Objects.nonNull(this.metadataProcessor)) {
            metadataValue = this.metadataProcessor.processMetadata(fullJson);
        } else {
            JsonNode jsonNode = this.convertStringJsonToJsonNode(fullJson);
            JsonNode jsonNode2 = jsonNode.at(this.query);
            if (jsonNode2.isArray()) {
                for (JsonNode nodeV : jsonNode2) {
                    if (!this.checkCondition(nodeV)) continue;
                    if (this.getElementAttribute() != null) {
                        String nodeValue;
                        JsonNode element = nodeV.get(this.getElementAttribute());
                        if (element == null || element.isMissingNode() || !StringUtils.isNotBlank((CharSequence)(nodeValue = this.getStringValue(element)))) continue;
                        metadataValue.add(nodeValue);
                        continue;
                    }
                    String nodeValue = this.getStringValue(nodeV);
                    if (!StringUtils.isNotBlank((CharSequence)nodeValue)) continue;
                    metadataValue.add(nodeValue);
                }
            } else if (!jsonNode2.isNull() && StringUtils.isNotBlank((CharSequence)jsonNode2.toString())) {
                String string;
                if (this.getElementAttribute() != null && this.checkCondition(jsonNode2)) {
                    String nodeValue2;
                    JsonNode jsonNode3 = jsonNode2.get(this.getElementAttribute());
                    if (jsonNode3 != null && !jsonNode3.isMissingNode() && StringUtils.isNotBlank((CharSequence)(nodeValue2 = this.getStringValue(jsonNode3)))) {
                        metadataValue.add(nodeValue2);
                    }
                } else if (this.checkCondition(jsonNode2) && StringUtils.isNotBlank((CharSequence)(string = this.getStringValue(jsonNode2)))) {
                    metadataValue.add(string);
                }
            }
        }
        if (this.metadataPostProcessor != null) {
            ArrayList<String> postmetadataValues = new ArrayList<String>();
            for (String string : metadataValue) {
                Collection<String> postmetadataValue = this.metadataPostProcessor.processMetadata(string);
                if (postmetadataValue == null) continue;
                postmetadataValues.addAll(postmetadataValue);
            }
            metadataValue = postmetadataValues;
        }
        for (String string : metadataValue) {
            MetadatumDTO metadatumDTO = new MetadatumDTO();
            metadatumDTO.setValue(string);
            metadatumDTO.setElement(this.field.getElement());
            metadatumDTO.setQualifier(this.field.getQualifier());
            metadatumDTO.setSchema(this.field.getSchema());
            metadata.add(metadatumDTO);
        }
        return metadata;
    }

    private boolean checkCondition(JsonNode node) {
        if (this.getConditionKey() == null && this.getConditionValue() == null) {
            return true;
        }
        if (this.getConditionKey() != null) {
            JsonNode conditionnode = node.get(this.getConditionKey());
            if (this.getConditionValue() == null && conditionnode != null && !conditionnode.isMissingNode()) {
                return true;
            }
            if (conditionnode != null && !conditionnode.isMissingNode() && conditionnode.toString().matches(this.getConditionValue())) {
                return true;
            }
        } else if (this.getConditionKey() == null && node.toString().matches(this.getConditionValue())) {
            return true;
        }
        return false;
    }

    private String getStringValue(JsonNode node) {
        if (node.isTextual()) {
            return node.textValue();
        }
        if (node.isNumber()) {
            return node.numberValue().toString();
        }
        log.error("It wasn't possible to convert the value of the following JsonNode:" + node.asText());
        return "";
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }
}

