/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.dspace.discovery.indexobject.factory.IndexObjectFactoryFactory;

public enum IndexClientOptions {
    REMOVE,
    CLEAN,
    DELETE,
    BUILD,
    BUILDANDSPELLCHECK,
    OPTIMIZE,
    SPELLCHECK,
    INDEX,
    UPDATE,
    FORCEUPDATE,
    UPDATEANDSPELLCHECK,
    FORCEUPDATEANDSPELLCHECK,
    HELP;

    public static final String TYPE_OPTION = "t";

    protected static IndexClientOptions getIndexClientOption(CommandLine commandLine) {
        if (commandLine.hasOption("h")) {
            return HELP;
        }
        if (commandLine.hasOption("r")) {
            return REMOVE;
        }
        if (commandLine.hasOption("c")) {
            return CLEAN;
        }
        if (commandLine.hasOption("d")) {
            return DELETE;
        }
        if (commandLine.hasOption("b")) {
            if (commandLine.hasOption("s")) {
                return BUILDANDSPELLCHECK;
            }
            return BUILD;
        }
        if (commandLine.hasOption("o")) {
            return OPTIMIZE;
        }
        if (commandLine.hasOption("s")) {
            return SPELLCHECK;
        }
        if (commandLine.hasOption("i")) {
            return INDEX;
        }
        if (commandLine.hasOption("f") && commandLine.hasOption("s")) {
            return FORCEUPDATEANDSPELLCHECK;
        }
        if (commandLine.hasOption("f")) {
            return FORCEUPDATE;
        }
        if (commandLine.hasOption("s")) {
            return UPDATEANDSPELLCHECK;
        }
        return UPDATE;
    }

    protected static Options constructOptions() {
        Options options = new Options();
        List indexableObjectTypes = IndexObjectFactoryFactory.getInstance().getIndexFactories().stream().map(indexFactory -> indexFactory.getType()).collect(Collectors.toList());
        options.addOption("r", "remove", true, "remove an Item, Collection or Community from index based on its handle");
        options.addOption("i", "index", true, "add or update an Item, Collection or Community based on its handle or uuid");
        options.addOption(TYPE_OPTION, "type", true, "reindex only specific type of (re)indexable objects; options: " + Arrays.toString(indexableObjectTypes.toArray()));
        options.addOption("c", "clean", false, "clean existing index removing any documents that no longer exist in the db");
        options.addOption("d", "delete", false, "delete all records from existing index");
        options.addOption("b", "build", false, "(re)build index, wiping out current one if it exists");
        options.addOption("s", "spellchecker", false, "Rebuild the spellchecker, can be combined with -b and -f.");
        options.addOption("f", "force", false, "if updating existing index, force each handle to be reindexed even if up-to-date");
        options.addOption("h", "help", false, "print this help message");
        return options;
    }
}

