/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.openalex;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.suggestion.loader.PublicationLoader;
import org.dspace.content.Item;

public class OpenAlexPublicationLoader
extends PublicationLoader {
    @Override
    public List<String> searchMetadataValues(Item researcher) {
        List<String> names = this.getNames();
        List authorIds = names.stream().filter("dc.identifier.openalex"::equals).map(name -> this.itemService.getMetadata(researcher, (String)name)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!authorIds.isEmpty()) {
            return Collections.singletonList(StringUtils.join(authorIds, (String)"|"));
        }
        return names.stream().map(name -> this.itemService.getMetadata(researcher, (String)name)).filter(Objects::nonNull).map(i -> "search_by_author=" + i).collect(Collectors.toList());
    }
}

