/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.core.ReloadableEntity;

@Entity
@Table(name="requestitem")
public class RequestItem
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="requestitem_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="requestitem_seq")
    @SequenceGenerator(name="requestitem_seq", sequenceName="requestitem_seq", allocationSize=1)
    private int requestitem_id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="bitstream_id")
    private Bitstream bitstream;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="item_id")
    private Item item;
    @Column(name="request_email", length=64)
    private String reqEmail;
    @Column(name="request_name", length=64)
    private String reqName;
    @Column(name="request_message", columnDefinition="text")
    private String reqMessage;
    @Column(name="token", unique=true, length=48)
    private String token;
    @Column(name="allfiles")
    private boolean allfiles;
    @Column(name="decision_date")
    private Instant decision_date = null;
    @Column(name="expires")
    private Instant expires = null;
    @Column(name="request_date")
    private Instant request_date = null;
    @Column(name="accept_request")
    private boolean accept_request;
    @Column(name="access_token", unique=true, length=48)
    private String access_token = null;
    @Column(name="access_expiry")
    private Instant access_expiry = null;

    protected RequestItem() {
    }

    @Override
    public Integer getID() {
        return this.requestitem_id;
    }

    public void setAllfiles(boolean allfiles) {
        this.allfiles = allfiles;
    }

    public boolean isAllfiles() {
        return this.allfiles;
    }

    void setReqMessage(String reqMessage) {
        this.reqMessage = reqMessage;
    }

    public String getReqMessage() {
        return this.reqMessage;
    }

    void setReqName(String reqName) {
        this.reqName = reqName;
    }

    public String getReqName() {
        return this.reqName;
    }

    void setReqEmail(String reqEmail) {
        this.reqEmail = reqEmail;
    }

    public String getReqEmail() {
        return this.reqEmail;
    }

    void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    void setItem(Item item) {
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    void setBitstream(Bitstream bitstream) {
        this.bitstream = bitstream;
    }

    public Bitstream getBitstream() {
        return this.bitstream;
    }

    public Instant getDecision_date() {
        return this.decision_date;
    }

    public void setDecision_date(Instant decision_date) {
        this.decision_date = decision_date;
    }

    public boolean isAccept_request() {
        return this.accept_request;
    }

    public void setAccept_request(boolean accept_request) {
        this.accept_request = accept_request;
    }

    public Instant getExpires() {
        return this.expires;
    }

    void setExpires(Instant expires) {
        this.expires = expires;
    }

    public Instant getRequest_date() {
        return this.request_date;
    }

    void setRequest_date(Instant request_date) {
        this.request_date = request_date;
    }

    public String getAccess_token() {
        return this.access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public Instant getAccess_expiry() {
        return this.access_expiry;
    }

    public void setAccess_expiry(Instant access_expiry) {
        this.access_expiry = access_expiry;
    }

    public void sanitizePersonalData() {
        this.setReqEmail("sanitized");
        this.setReqName("sanitized");
        this.setReqMessage("sanitized");
        this.setToken("sanitized");
    }
}

