/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class SamlAuthentication
implements AuthenticationMethod {
    private static final Logger log = LogManager.getLogger(SamlAuthentication.class);
    protected Map<String, String> metadataHeaderMap = null;
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected final String FIELD_NAME_REGEX = "^[_A-Za-z0-9]+$";

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        if (request == null) {
            log.warn("Unable to authenticate using SAML because the request object is null.");
            return 5;
        }
        this.initialize(context);
        String nameId = this.findSingleAttribute(request, this.getNameIdAttributeName());
        if (log.isDebugEnabled()) {
            log.debug("Starting SAML Authentication");
            log.debug("Received name ID: " + nameId);
        }
        boolean autoRegister = this.configurationService.getBooleanProperty("authentication-saml.autoregister", true);
        try {
            EPerson eperson = this.findEPerson(context, request);
            if (eperson == null && autoRegister) {
                eperson = this.registerNewEPerson(context, request);
            }
            if (eperson == null) {
                return 4;
            }
            if (!eperson.canLogIn()) {
                return 5;
            }
            this.updateEPerson(context, request, eperson);
            context.setCurrentUser(eperson);
            request.setAttribute("saml.authenticated", (Object)true);
            AuthenticateServiceFactory.getInstance().getAuthenticationService().initEPerson(context, request, eperson);
            log.info(eperson.getEmail() + " has been authenticated via SAML.");
            return 1;
        }
        catch (Throwable t) {
            log.error("Unable to successfully authenticate using SAML for user because of an exception.", t);
            context.setCurrentUser(null);
            return 4;
        }
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        return List.of();
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String email) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        String samlLoginUrl = this.configurationService.getProperty("authentication-saml.authenticate-endpoint");
        return response.encodeRedirectURL(samlLoginUrl);
    }

    @Override
    public String getName() {
        return "saml";
    }

    public static boolean isEnabled() {
        String samlPluginName = new SamlAuthentication().getName();
        boolean samlEnabled = false;
        Iterator<AuthenticationMethod> authenticationMethodIterator = AuthenticateServiceFactory.getInstance().getAuthenticationService().authenticationMethodIterator();
        while (authenticationMethodIterator.hasNext()) {
            if (!samlPluginName.equals(authenticationMethodIterator.next().getName())) continue;
            samlEnabled = true;
            break;
        }
        return samlEnabled;
    }

    protected EPerson findEPerson(Context context, HttpServletRequest request) throws SQLException, AuthorizeException {
        String emailAttributeName;
        String email;
        String nameId = this.findSingleAttribute(request, this.getNameIdAttributeName());
        if (nameId != null) {
            EPerson ePerson = this.ePersonService.findByNetid(context, nameId);
            if (ePerson == null) {
                log.info("Unable to identify EPerson by netid (SAML name ID): " + nameId);
            } else {
                log.info("Identified EPerson by netid (SAML name ID): " + nameId);
                return ePerson;
            }
        }
        if ((email = this.findSingleAttribute(request, emailAttributeName = this.getEmailAttributeName())) != null) {
            EPerson ePerson = this.ePersonService.findByEmail(context, email = email.toLowerCase());
            if (ePerson == null) {
                log.info("Unable to identify EPerson by email: " + emailAttributeName + "=" + email);
            } else {
                log.info("Identified EPerson by email: " + emailAttributeName + "=" + email);
                if (ePerson.getNetid() == null) {
                    return ePerson;
                }
                log.error("SAML authentication identified EPerson by email: " + emailAttributeName + "=" + email);
                log.error("Received SAML name ID: " + nameId);
                log.error("EPerson has netid: " + ePerson.getNetid());
                log.error("The SAML name ID is expected to be the same as the EPerson netid. This might be a hacking attempt to steal another user's credentials. If the user's netid has changed you will need to manually change it to the correct value or unset it in the database.");
            }
        }
        if (nameId == null && email == null) {
            log.error("SAML authentication did not find a name ID or email in the request from which to indentify a user");
        }
        return null;
    }

    protected EPerson registerNewEPerson(Context context, HttpServletRequest request) throws SQLException, AuthorizeException {
        String nameId = this.findSingleAttribute(request, this.getNameIdAttributeName());
        String emailAttributeName = this.getEmailAttributeName();
        String firstNameAttributeName = this.getFirstNameAttributeName();
        String lastNameAttributeName = this.getLastNameAttributeName();
        String email = this.findSingleAttribute(request, emailAttributeName);
        String firstName = this.findSingleAttribute(request, firstNameAttributeName);
        String lastName = this.findSingleAttribute(request, lastNameAttributeName);
        if (email == null || firstName == null || lastName == null) {
            Object message = "Unable to register new eperson because we are unable to find an email address, first name, and last name for the user.\n";
            message = (String)message + "  name ID: " + nameId + "\n";
            message = (String)message + "  email: " + emailAttributeName + "=" + email + "\n";
            message = (String)message + "  first name: " + firstNameAttributeName + "=" + firstName + "\n";
            message = (String)message + "  last name: " + lastNameAttributeName + "=" + lastName;
            log.error((String)message);
            return null;
        }
        try {
            context.turnOffAuthorisationSystem();
            EPerson ePerson = this.ePersonService.create(context);
            if (nameId != null) {
                ePerson.setNetid(nameId);
            }
            ePerson.setEmail(email.toLowerCase());
            ePerson.setFirstName(context, firstName);
            ePerson.setLastName(context, lastName);
            ePerson.setCanLogIn(true);
            ePerson.setSelfRegistered(true);
            AuthenticateServiceFactory.getInstance().getAuthenticationService().initEPerson(context, request, ePerson);
            this.ePersonService.update(context, ePerson);
            context.dispatchEvents();
            if (log.isInfoEnabled()) {
                Object message = "Auto registered new eperson using SAML attributes:\n";
                message = (String)message + "  netid: " + ePerson.getNetid() + "\n";
                message = (String)message + "  email: " + ePerson.getEmail() + "\n";
                message = (String)message + "  firstName: " + ePerson.getFirstName() + "\n";
                message = (String)message + "  lastName: " + ePerson.getLastName();
                log.info((String)message);
            }
            EPerson ePerson2 = ePerson;
            return ePerson2;
        }
        catch (SQLException | AuthorizeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    protected void updateEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException, AuthorizeException {
        String nameId = this.findSingleAttribute(request, this.getNameIdAttributeName());
        String emailAttributeName = this.getEmailAttributeName();
        String firstNameAttributeName = this.getFirstNameAttributeName();
        String lastNameAttributeName = this.getLastNameAttributeName();
        String email = this.findSingleAttribute(request, emailAttributeName);
        String firstName = this.findSingleAttribute(request, firstNameAttributeName);
        String lastName = this.findSingleAttribute(request, lastNameAttributeName);
        try {
            context.turnOffAuthorisationSystem();
            if (nameId != null && eperson.getNetid() == null) {
                eperson.setNetid(nameId);
            }
            if (email != null) {
                eperson.setEmail(email.toLowerCase());
            }
            if (firstName != null) {
                eperson.setFirstName(context, firstName);
            }
            if (lastName != null) {
                eperson.setLastName(context, lastName);
            }
            if (log.isDebugEnabled()) {
                Object message = "Updated the eperson's minimal metadata: \n";
                message = (String)message + " Email: " + emailAttributeName + "=" + email + "' \n";
                message = (String)message + " First name: " + firstNameAttributeName + "=" + firstName + "\n";
                message = (String)message + " Last name: " + lastNameAttributeName + "=" + lastName;
                log.debug((String)message);
            }
            for (String attributeName : this.metadataHeaderMap.keySet()) {
                String metadataFieldName = this.metadataHeaderMap.get(attributeName);
                String value = this.findSingleAttribute(request, attributeName);
                if (value == null) {
                    log.warn("Unable to update the eperson's '{}' metadata because the attribute '{}' does not exist.", (Object)metadataFieldName, (Object)attributeName);
                    continue;
                }
                this.ePersonService.setMetadataSingleValue(context, eperson, MetadataSchemaEnum.EPERSON.getName(), metadataFieldName, null, null, value);
                log.debug("Updated the eperson's {} metadata using attribute: {}={}", (Object)metadataFieldName, (Object)attributeName, (Object)value);
            }
            this.ePersonService.update(context, eperson);
            context.dispatchEvents();
        }
        catch (SQLException | AuthorizeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    protected synchronized void initialize(Context context) throws SQLException {
        if (this.metadataHeaderMap != null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Object[] mappingString = this.configurationService.getArrayProperty("authentication-saml.eperson.metadata");
        boolean autoCreate = this.configurationService.getBooleanProperty("authentication-saml.eperson.metadata.autocreate", false);
        if (mappingString == null || mappingString.length == 0) {
            log.debug("No additional eperson metadata mapping found: authentication-saml.eperson.metadata");
            this.metadataHeaderMap = map;
            return;
        }
        log.debug("Loading additional eperson metadata from: authentication-saml.eperson.metadata=" + StringUtils.join((Object[])mappingString, (String)","));
        for (Object metadataString : mappingString) {
            String[] metadataParts = ((String)(metadataString = ((String)metadataString).trim())).split("=>");
            if (metadataParts.length != 2) {
                log.error("Unable to parse metadata mapping string: '" + (String)metadataString + "'");
                continue;
            }
            String attributeName = metadataParts[0].trim();
            String metadataFieldName = metadataParts[1].trim().toLowerCase();
            boolean valid = this.checkIfEPersonMetadataFieldExists(context, metadataFieldName);
            if (!valid && autoCreate) {
                valid = this.autoCreateEPersonMetadataField(context, metadataFieldName);
            }
            if (valid) {
                log.debug("Loading additional eperson metadata mapping for: {}={}", (Object)attributeName, (Object)metadataFieldName);
                map.put(attributeName, metadataFieldName);
                continue;
            }
            log.error("Skipping the additional eperson metadata mapping for: {}={} because the field is not supported by the current configuration.", (Object)attributeName, (Object)metadataFieldName);
        }
        this.metadataHeaderMap = map;
    }

    protected synchronized boolean checkIfEPersonMetadataFieldExists(Context context, String metadataName) throws SQLException {
        if (metadataName == null) {
            return false;
        }
        MetadataField metadataField = this.metadataFieldService.findByElement(context, MetadataSchemaEnum.EPERSON.getName(), metadataName, null);
        return metadataField != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean autoCreateEPersonMetadataField(Context context, String metadataName) throws SQLException {
        if (metadataName == null) {
            return false;
        }
        if (!metadataName.matches("^[_A-Za-z0-9]+$")) {
            return false;
        }
        MetadataSchema epersonSchema = this.metadataSchemaService.find(context, "eperson");
        MetadataField metadataField = null;
        try {
            context.turnOffAuthorisationSystem();
            metadataField = this.metadataFieldService.create(context, epersonSchema, metadataName, null, null);
        }
        catch (AuthorizeException | NonUniqueMetadataException e) {
            log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            context.restoreAuthSystemState();
        }
        return metadataField != null;
    }

    @Override
    public boolean isUsed(Context context, HttpServletRequest request) {
        return request != null && context.getCurrentUser() != null && request.getAttribute("saml.authenticated") != null;
    }

    @Override
    public boolean canChangePassword(Context context, EPerson ePerson, String currentPassword) {
        return false;
    }

    private String findSingleAttribute(HttpServletRequest request, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        Object value = request.getAttribute(name);
        if (value instanceof List) {
            List list = (List)value;
            value = list.size() == 0 ? null : list.get(0);
        }
        return value == null ? null : value.toString();
    }

    private String getNameIdAttributeName() {
        return this.configurationService.getProperty("authentication-saml.attribute.name-id", "org.dspace.saml.NAME_ID");
    }

    private String getEmailAttributeName() {
        return this.configurationService.getProperty("authentication-saml.attribute.email", "org.dspace.saml.EMAIL");
    }

    private String getFirstNameAttributeName() {
        return this.configurationService.getProperty("authentication-saml.attribute.first-name", "org.dspace.saml.GIVEN_NAME");
    }

    private String getLastNameAttributeName() {
        return this.configurationService.getProperty("authentication-saml.attribute.last-name", "org.dspace.saml.SURNAME");
    }
}

