/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.File;
import java.io.FileInputStream;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.dspace.app.statistics.LogAnalyser;
import org.dspace.app.statistics.ReportGenerator;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class CreateStatReport {
    private static LocalDate calendar = null;
    private static LocalDate reportStartDate = null;
    private static String outputLogDirectory = null;
    private static String outputReportDirectory = null;
    private static final String outputSuffix = ".dat";
    private static Context context;

    private CreateStatReport() {
    }

    public static void main(String[] argv) throws Exception {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String configFile = configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "dstat.cfg";
        FileInputStream fis = new FileInputStream(new File(configFile));
        Properties config = new Properties();
        config.load(fis);
        int startMonth = 1;
        int startYear = 2005;
        try {
            startYear = Integer.parseInt(config.getProperty("start.year", "2005").trim());
        }
        catch (NumberFormatException nfe) {
            System.err.println("start.year is incorrectly set in dstat.cfg. Must be a number (e.g. 2005).");
            System.exit(0);
        }
        try {
            startMonth = Integer.parseInt(config.getProperty("start.month", "1").trim());
        }
        catch (NumberFormatException nfe) {
            System.err.println("start.month is incorrectly set in dstat.cfg. Must be a number between 1 and 12.");
            System.exit(0);
        }
        reportStartDate = LocalDate.of(startYear, startMonth, 1);
        calendar = LocalDate.now();
        context = new Context();
        context.turnOffAuthorisationSystem();
        outputLogDirectory = configurationService.getProperty("log.report.dir") + File.separator;
        outputReportDirectory = configurationService.getProperty("report.dir") + File.separator;
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        options.addOption("r", "report", true, "report");
        CommandLine line = parser.parse(options, argv);
        String statAction = null;
        if (line.hasOption('r')) {
            statAction = line.getOptionValue('r');
        }
        if (statAction == null) {
            CreateStatReport.usage();
            System.exit(0);
        }
        if (statAction.equals("stat-monthly")) {
            CreateStatReport.statMonthly();
        }
        if (statAction.equals("stat-general")) {
            CreateStatReport.statGeneral();
        }
        if (statAction.equals("stat-initial")) {
            CreateStatReport.statInitial();
        }
        if (statAction.equals("stat-report-general")) {
            CreateStatReport.statReportGeneral();
        }
        if (statAction.equals("stat-report-initial")) {
            CreateStatReport.statReportInitial();
        }
        if (statAction.equals("stat-report-monthly")) {
            CreateStatReport.statReportMonthly();
        }
    }

    private static void statMonthly() throws Exception {
        String outputPrefix = "dspace-log-monthly-";
        String myLogDir = null;
        String myFileTemplate = null;
        String myConfigFile = null;
        boolean myLookUp = false;
        LocalDate start = calendar.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate end = calendar.with(TemporalAdjusters.lastDayOfMonth());
        StringBuilder myOutFile = new StringBuilder(outputLogDirectory);
        myOutFile.append(outputPrefix);
        myOutFile.append(calendar.getYear());
        myOutFile.append("-");
        myOutFile.append(calendar.getMonth());
        myOutFile.append(outputSuffix);
        LogAnalyser.processLogs(context, myLogDir, myFileTemplate, myConfigFile, myOutFile.toString(), start, end, myLookUp);
    }

    private static void statGeneral() throws Exception {
        String outputPrefix = "dspace-log-general-";
        String myLogDir = null;
        String myFileTemplate = null;
        String myConfigFile = null;
        boolean myLookUp = false;
        StringBuilder myOutFile = new StringBuilder(outputLogDirectory);
        myOutFile.append(outputPrefix);
        myOutFile.append(calendar.getYear());
        myOutFile.append("-");
        myOutFile.append(calendar.getMonth());
        myOutFile.append("-");
        myOutFile.append(calendar.getDayOfMonth());
        myOutFile.append(outputSuffix);
        LogAnalyser.processLogs(context, myLogDir, myFileTemplate, myConfigFile, myOutFile.toString(), null, null, myLookUp);
    }

    private static void statInitial() throws Exception {
        String outputPrefix = "dspace-log-monthly-";
        String myLogDir = null;
        String myFileTemplate = null;
        String myConfigFile = null;
        boolean myLookUp = false;
        LocalDate reportEndDate = calendar.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate currentMonth = reportStartDate;
        while (currentMonth.isBefore(reportEndDate)) {
            LocalDate start = currentMonth.with(TemporalAdjusters.firstDayOfMonth());
            LocalDate end = currentMonth.with(TemporalAdjusters.lastDayOfMonth());
            StringBuilder myOutFile = new StringBuilder(outputLogDirectory);
            myOutFile.append(outputPrefix);
            myOutFile.append(currentMonth.getYear());
            myOutFile.append("-");
            myOutFile.append(currentMonth.getMonth());
            myOutFile.append(outputSuffix);
            LogAnalyser.processLogs(context, myLogDir, myFileTemplate, myConfigFile, myOutFile.toString(), start, end, myLookUp);
            currentMonth = currentMonth.plus(1L, ChronoUnit.MONTHS);
        }
    }

    private static void statReportGeneral() throws Exception {
        String inputPrefix = "dspace-log-general-";
        String outputPrefix = "report-general-";
        String myFormat = "html";
        String myMap = null;
        StringBuilder myInput = new StringBuilder(outputLogDirectory);
        myInput.append(inputPrefix);
        myInput.append(calendar.getYear());
        myInput.append("-");
        myInput.append(calendar.getMonth());
        myInput.append("-");
        myInput.append(calendar.getDayOfMonth());
        myInput.append(outputSuffix);
        StringBuilder myOutput = new StringBuilder(outputReportDirectory);
        myOutput.append(outputPrefix);
        myOutput.append(calendar.getYear());
        myOutput.append("-");
        myOutput.append(calendar.getMonth());
        myOutput.append("-");
        myOutput.append(calendar.getDayOfMonth());
        myOutput.append(".");
        myOutput.append(myFormat);
        ReportGenerator.processReport(context, myFormat, myInput.toString(), myOutput.toString(), myMap);
    }

    private static void statReportInitial() throws Exception {
        String inputPrefix = "dspace-log-monthly-";
        String outputPrefix = "report-";
        String myFormat = "html";
        String myMap = null;
        LocalDate reportEndDate = calendar.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate currentMonth = reportStartDate;
        while (currentMonth.isBefore(reportEndDate)) {
            StringBuilder myInput = new StringBuilder(outputLogDirectory);
            myInput.append(inputPrefix);
            myInput.append(currentMonth.getYear());
            myInput.append("-");
            myInput.append(currentMonth.getMonth());
            myInput.append(outputSuffix);
            StringBuilder myOutput = new StringBuilder(outputReportDirectory);
            myOutput.append(outputPrefix);
            myOutput.append(currentMonth.getYear());
            myOutput.append("-");
            myOutput.append(currentMonth.getMonth());
            myOutput.append(".");
            myOutput.append(myFormat);
            ReportGenerator.processReport(context, myFormat, myInput.toString(), myOutput.toString(), myMap);
            currentMonth = currentMonth.plus(1L, ChronoUnit.MONTHS);
        }
    }

    private static void statReportMonthly() throws Exception {
        String inputPrefix = "dspace-log-monthly-";
        String outputPrefix = "report-";
        String myFormat = "html";
        String myMap = null;
        StringBuilder myInput = new StringBuilder(outputLogDirectory);
        myInput.append(inputPrefix);
        myInput.append(calendar.getYear());
        myInput.append("-");
        myInput.append(calendar.getMonth());
        myInput.append(outputSuffix);
        StringBuilder myOutput = new StringBuilder(outputReportDirectory);
        myOutput.append(outputPrefix);
        myOutput.append(calendar.getYear());
        myOutput.append("-");
        myOutput.append(calendar.getMonth());
        myOutput.append(".");
        myOutput.append(myFormat);
        ReportGenerator.processReport(context, myFormat, myInput.toString(), myOutput.toString(), myMap);
    }

    private static void usage() throws Exception {
        System.out.println("Usage: java CreateStatReport -r <statistic to run>");
        System.out.println("Available: <stat-initial> <stat-general> <stat-monthly> <stat-report-initial> <stat-report-general> <stat-report-monthly>");
    }
}

