/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.action.LDNAction;
import org.dspace.app.ldn.action.LDNActionStatus;
import org.dspace.app.ldn.action.LDNEmailAction;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.qaevent.service.dto.NotifyMessageDTO;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class LDNCorrectionAction
implements LDNAction {
    private static final Logger log = LogManager.getLogger(LDNEmailAction.class);
    private String qaEventTopic;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    protected ItemService itemService;
    @Autowired
    private QAEventService qaEventService;
    @Autowired
    private LDNMessageService ldnMessageService;
    @Autowired
    private HandleService handleService;

    @Override
    public LDNActionStatus execute(Context context, Notification notification, Item item) throws Exception {
        LDNActionStatus result = LDNActionStatus.ABORT;
        String itemName = this.itemService.getName(item);
        QAEvent qaEvent = null;
        if (notification.getObject() != null) {
            BigDecimal score;
            String citeAs = notification.getObject().getIetfCiteAs();
            if (citeAs == null || citeAs.isEmpty()) {
                citeAs = notification.getObject().getId();
            }
            NotifyMessageDTO message = new NotifyMessageDTO();
            message.setHref(citeAs);
            message.setRelationship(notification.getObject().getAsRelationship());
            if (notification.getOrigin() != null) {
                message.setServiceId(notification.getOrigin().getId());
                message.setServiceName(notification.getOrigin().getInbox());
            }
            double doubleScoreValue = (score = this.getScore(context, notification)) != null ? score.doubleValue() : 0.0;
            ObjectMapper mapper = new ObjectMapper();
            qaEvent = new QAEvent("coar-notify", this.handleService.findHandle(context, item), item.getID().toString(), itemName, this.getQaEventTopic(), doubleScoreValue, mapper.writeValueAsString((Object)message), Instant.now());
            this.qaEventService.store(context, qaEvent);
            result = LDNActionStatus.CONTINUE;
        }
        return result;
    }

    private BigDecimal getScore(Context context, Notification notification) throws SQLException {
        if (notification.getOrigin() == null) {
            return BigDecimal.ZERO;
        }
        NotifyServiceEntity service = this.ldnMessageService.findNotifyService(context, notification.getOrigin());
        if (service == null) {
            return BigDecimal.ZERO;
        }
        return service.getScore();
    }

    public String getQaEventTopic() {
        return this.qaEventTopic;
    }

    public void setQaEventTopic(String qaEventTopic) {
        this.qaEventTopic = qaEventTopic;
    }
}

