/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google;

import java.util.Objects;
import org.springframework.util.Assert;

public final class GoogleAnalyticsEvent {
    private final String clientId;
    private final String userIp;
    private final String userAgent;
    private final String documentReferrer;
    private final String documentPath;
    private final String documentTitle;
    private final long time;

    public GoogleAnalyticsEvent(String clientId, String userIp, String userAgent, String documentReferrer, String documentPath, String documentTitle) {
        Assert.notNull((Object)clientId, (String)"A client id is required to create a Google Analytics event");
        this.clientId = clientId;
        this.userIp = userIp;
        this.userAgent = userAgent;
        this.documentReferrer = documentReferrer;
        this.documentPath = documentPath;
        this.documentTitle = documentTitle;
        this.time = System.currentTimeMillis();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public String getUserAgent() {
        return this.userAgent != null ? this.userAgent : "";
    }

    public String getDocumentReferrer() {
        return this.documentReferrer != null ? this.documentReferrer : "";
    }

    public String getDocumentPath() {
        return this.documentPath;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public long getTime() {
        return this.time;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.documentPath, this.documentReferrer, this.documentTitle, this.time, this.userAgent, this.userIp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoogleAnalyticsEvent other = (GoogleAnalyticsEvent)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.documentPath, other.documentPath) && Objects.equals(this.documentReferrer, other.documentReferrer) && Objects.equals(this.documentTitle, other.documentTitle) && this.time == other.time && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.userIp, other.userIp);
    }

    public String toString() {
        return "GoogleAnalyticsEvent [clientId=" + this.clientId + ", userIp=" + this.userIp + ", userAgent=" + this.userAgent + ", documentReferrer=" + this.documentReferrer + ", documentPath=" + this.documentPath + ", documentTitle=" + this.documentTitle + ", time=" + this.time + "]";
    }
}

