/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.MetadataField;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPerson_;
import org.dspace.eperson.Group;
import org.dspace.eperson.dao.EPersonDAO;

public class EPersonDAOImpl
extends AbstractHibernateDSODAO<EPerson>
implements EPersonDAO {
    protected EPersonDAOImpl() {
    }

    @Override
    public EPerson findByEmail(Context context, String email) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<EPerson> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, EPerson.class);
        Root ePersonRoot = criteriaQuery.from(EPerson.class);
        criteriaQuery.select((Selection)ePersonRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)ePersonRoot.get(EPerson_.email), (Object)email.toLowerCase()));
        return this.uniqueResult(context, criteriaQuery, true, EPerson.class);
    }

    @Override
    public EPerson findByNetid(Context context, String netid) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<EPerson> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, EPerson.class);
        Root ePersonRoot = criteriaQuery.from(EPerson.class);
        criteriaQuery.select((Selection)ePersonRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)ePersonRoot.get(EPerson_.netid), (Object)netid));
        return this.uniqueResult(context, criteriaQuery, true, EPerson.class);
    }

    @Override
    public List<EPerson> search(Context context, String query, List<MetadataField> queryFields, List<MetadataField> sortFields, int offset, int limit) throws SQLException {
        String queryString = "SELECT " + EPerson.class.getSimpleName().toLowerCase() + " FROM EPerson as " + EPerson.class.getSimpleName().toLowerCase() + " ";
        Query hibernateQuery = this.getSearchQuery(context, queryString, query, queryFields, null, sortFields, null, limit, offset);
        return this.list(hibernateQuery);
    }

    @Override
    public int searchResultCount(Context context, String query, List<MetadataField> queryFields) throws SQLException {
        String queryString = "SELECT count(*) FROM EPerson as " + EPerson.class.getSimpleName().toLowerCase();
        Query hibernateQuery = this.getSearchQuery(context, queryString, query, queryFields, Collections.EMPTY_LIST, null);
        return this.count(hibernateQuery);
    }

    @Override
    public List<EPerson> searchNotMember(Context context, String query, List<MetadataField> queryFields, Group excludeGroup, List<MetadataField> sortFields, int offset, int limit) throws SQLException {
        String queryString = "SELECT " + EPerson.class.getSimpleName().toLowerCase() + " FROM EPerson as " + EPerson.class.getSimpleName().toLowerCase() + " ";
        Query hibernateQuery = this.getSearchQuery(context, queryString, query, queryFields, excludeGroup, sortFields, null, limit, offset);
        return this.list(hibernateQuery);
    }

    @Override
    public int searchNotMemberCount(Context context, String query, List<MetadataField> queryFields, Group excludeGroup) throws SQLException {
        String queryString = "SELECT count(*) FROM EPerson as " + EPerson.class.getSimpleName().toLowerCase();
        Query hibernateQuery = this.getSearchQuery(context, queryString, query, queryFields, excludeGroup, Collections.EMPTY_LIST, null, -1, -1);
        return this.count(hibernateQuery);
    }

    @Override
    public List<EPerson> findAll(Context context, MetadataField metadataSortField, String sortField, int pageSize, int offset) throws SQLException {
        String queryString = "SELECT " + EPerson.class.getSimpleName().toLowerCase() + " FROM EPerson as " + EPerson.class.getSimpleName().toLowerCase();
        List<MetadataField> sortFields = Collections.EMPTY_LIST;
        if (metadataSortField != null) {
            sortFields = Collections.singletonList(metadataSortField);
        }
        Query query = this.getSearchQuery(context, queryString, null, ListUtils.EMPTY_LIST, null, sortFields, sortField, pageSize, offset);
        return this.list(query);
    }

    @Override
    public List<EPerson> findByGroups(Context context, Set<Group> groups, int pageSize, int offset) throws SQLException {
        Query query = this.createQuery(context, "SELECT DISTINCT e FROM EPerson e JOIN e.groups g WHERE g.id IN (:idList) ");
        ArrayList<UUID> idList = new ArrayList<UUID>(groups.size());
        for (Group group : groups) {
            idList.add(group.getID());
        }
        query.setParameter("idList", idList);
        if (pageSize > 0) {
            query.setMaxResults(pageSize);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return this.list(query);
    }

    @Override
    public int countByGroups(Context context, Set<Group> groups) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(DISTINCT e) FROM EPerson e JOIN e.groups g WHERE g.id IN (:idList) ");
        ArrayList<UUID> idList = new ArrayList<UUID>(groups.size());
        for (Group group : groups) {
            idList.add(group.getID());
        }
        query.setParameter("idList", idList);
        return this.count(query);
    }

    @Override
    public List<EPerson> findWithPasswordWithoutDigestAlgorithm(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<EPerson> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, EPerson.class);
        Root ePersonRoot = criteriaQuery.from(EPerson.class);
        criteriaQuery.select((Selection)ePersonRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.isNotNull((Expression)ePersonRoot.get(EPerson_.password)), (Expression)criteriaBuilder.isNull((Expression)ePersonRoot.get(EPerson_.digestAlgorithm))));
        return this.list(context, criteriaQuery, false, EPerson.class, -1, -1);
    }

    @Override
    public List<EPerson> findNotActiveSince(Context context, Date date) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<EPerson> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, EPerson.class);
        Root ePersonRoot = criteriaQuery.from(EPerson.class);
        criteriaQuery.select((Selection)ePersonRoot);
        criteriaQuery.where((Expression)criteriaBuilder.lessThanOrEqualTo((Expression)ePersonRoot.get(EPerson_.lastActive), (Comparable)date));
        return this.list(context, criteriaQuery, false, EPerson.class, -1, -1);
    }

    protected Query getSearchQuery(Context context, String queryString, String queryParam, List<MetadataField> queryFields, List<MetadataField> sortFields, String sortField) throws SQLException {
        return this.getSearchQuery(context, queryString, queryParam, queryFields, null, sortFields, sortField, -1, -1);
    }

    protected Query getSearchQuery(Context context, String queryString, String queryParam, List<MetadataField> queryFields, Group excludeGroup, List<MetadataField> sortFields, String sortField, int pageSize, int offset) throws SQLException {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(queryString);
        LinkedHashSet<MetadataField> metadataFieldsToJoin = new LinkedHashSet<MetadataField>();
        metadataFieldsToJoin.addAll(queryFields);
        metadataFieldsToJoin.addAll(sortFields);
        if (!CollectionUtils.isEmpty(metadataFieldsToJoin)) {
            this.addMetadataLeftJoin(queryBuilder, EPerson.class.getSimpleName().toLowerCase(), metadataFieldsToJoin);
        }
        if (StringUtils.isNotBlank((CharSequence)queryParam)) {
            this.addMetadataValueWhereQuery(queryBuilder, queryFields, "like", EPerson.class.getSimpleName().toLowerCase() + ".email like :queryParam");
        }
        if (excludeGroup != null) {
            if (StringUtils.isNotBlank((CharSequence)queryParam)) {
                queryBuilder.append(" AND ");
            } else {
                queryBuilder.append(" WHERE ");
            }
            queryBuilder.append("(FROM Group g where g.id = :group_id) NOT IN elements (").append(EPerson.class.getSimpleName().toLowerCase()).append(".groups)");
        }
        if (!CollectionUtils.isEmpty(sortFields) || StringUtils.isNotBlank((CharSequence)sortField)) {
            this.addMetadataSortQuery(queryBuilder, sortFields, Collections.singletonList(sortField));
        }
        Query query = this.createQuery(context, queryBuilder.toString());
        if (pageSize > 0) {
            query.setMaxResults(pageSize);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (StringUtils.isNotBlank((CharSequence)queryParam)) {
            query.setParameter("queryParam", (Object)("%" + queryParam.toLowerCase() + "%"));
        }
        for (MetadataField metadataField : metadataFieldsToJoin) {
            query.setParameter(metadataField.toString(), (Object)metadataField.getID());
        }
        if (excludeGroup != null) {
            query.setParameter("group_id", (Object)excludeGroup.getID());
        }
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return query;
    }

    @Override
    public List<EPerson> findAllSubscribers(Context context) throws SQLException {
        return this.list(this.createQuery(context, "SELECT DISTINCT e from Subscription s join s.ePerson e"));
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM EPerson"));
    }
}

