/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.contentreport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.dspace.contentreport.FilteredCollection;

public class FilteredCollections
implements Serializable {
    private static final long serialVersionUID = 3622651208704009095L;
    private List<FilteredCollection> collections = new ArrayList<FilteredCollection>();
    private FilteredCollection summary;

    public static FilteredCollections of(Collection<FilteredCollection> collections) {
        FilteredCollections colls = new FilteredCollections();
        Optional.ofNullable(collections).ifPresent(cs -> cs.stream().forEach(colls::addCollection));
        return colls;
    }

    public List<FilteredCollection> getCollections() {
        return new ArrayList<FilteredCollection>(this.collections);
    }

    public void addCollection(FilteredCollection coll) {
        this.summary = null;
        this.collections.add(coll);
    }

    public void setCollections(List<FilteredCollection> collections) {
        this.summary = null;
        this.collections.clear();
        this.collections.addAll(collections);
    }

    public FilteredCollection getSummary() {
        boolean needsRefresh;
        boolean bl = needsRefresh = this.summary == null || this.collections.stream().anyMatch(c -> !c.getSealed());
        if (needsRefresh) {
            this.summary = new FilteredCollection();
            for (FilteredCollection coll : this.collections) {
                coll.getValues().forEach(this.summary::addValue);
            }
            int total = this.collections.stream().mapToInt(FilteredCollection::getTotalItems).sum();
            this.summary.setTotalItems(total);
            int allFilters = this.collections.stream().mapToInt(FilteredCollection::getAllFiltersValue).sum();
            this.summary.setAllFiltersValue(allFilters);
            this.summary.seal();
        }
        return this.summary;
    }
}

