/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.ResourcePolicy_;
import org.dspace.authorize.dao.ResourcePolicyDAO;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObject_;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class ResourcePolicyDAOImpl
extends AbstractHibernateDAO<ResourcePolicy>
implements ResourcePolicyDAO {
    protected ResourcePolicyDAOImpl() {
    }

    @Override
    public List<ResourcePolicy> findByDso(Context context, DSpaceObject dso) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.dSpaceObject), (Object)dso));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, -1, -1);
    }

    @Override
    public List<ResourcePolicy> findByDsoAndType(Context context, DSpaceObject dso, String type) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.dSpaceObject), (Object)dso), (Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.rptype), (Object)type)));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)resourcePolicyRoot.get(ResourcePolicy_.id)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, -1, -1);
    }

    @Override
    public List<ResourcePolicy> findByEPerson(Context context, EPerson ePerson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.eperson), (Object)ePerson));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, -1, -1);
    }

    @Override
    public List<ResourcePolicy> findByGroup(Context context, Group group) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.epersonGroup), (Object)group));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, -1, -1);
    }

    @Override
    public List<ResourcePolicy> findByDSoAndAction(Context context, DSpaceObject dso, int actionId) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.dSpaceObject), (Object)dso), (Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.actionId), (Object)actionId)));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, -1, -1);
    }

    @Override
    public void deleteByDsoAndTypeAndAction(Context context, DSpaceObject dso, String type, int actionId) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject.id = :dsoId AND rptype = :rptype AND actionId= :actionId";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dsoId", (Object)dso.getID());
        query.setParameter("rptype", (Object)type);
        query.setParameter("actionId", (Object)actionId);
        query.executeUpdate();
    }

    @Override
    public List<ResourcePolicy> findByTypeGroupAction(Context context, DSpaceObject dso, Group group, int action) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.dSpaceObject), (Object)dso), criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.epersonGroup), (Object)group), criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.actionId), (Object)action)}));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, 1, -1);
    }

    @Override
    public List<ResourcePolicy> findByTypeGroupActionExceptId(Context context, DSpaceObject dso, Group group, int action, int notPolicyID) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.dSpaceObject), (Object)dso), criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.epersonGroup), (Object)group), criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.actionId), (Object)action), criteriaBuilder.notEqual((Expression)resourcePolicyRoot.get(ResourcePolicy_.id), (Object)notPolicyID)}));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, 1, -1);
    }

    @Override
    public List<ResourcePolicy> findByEPersonGroupTypeIdAction(Context context, EPerson e, List<Group> groups, int action, int type_id) throws SQLException {
        if (CollectionUtils.isEmpty(groups) && e == null) {
            return Collections.emptyList();
        }
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        Predicate compareEpersonOrGroups = CollectionUtils.isNotEmpty(groups) && e != null ? criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.eperson), (Object)e), (Expression)resourcePolicyRoot.get(ResourcePolicy_.epersonGroup).in(groups)) : (e != null ? criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.eperson), (Object)e) : resourcePolicyRoot.get(ResourcePolicy_.epersonGroup).in(groups));
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.resourceTypeId), (Object)type_id), criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.actionId), (Object)action), compareEpersonOrGroups}));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, -1, -1);
    }

    @Override
    public void deleteByDso(Context context, DSpaceObject dso) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject= :dSpaceObject";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dSpaceObject", (Object)dso);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoAndAction(Context context, DSpaceObject dso, int actionId) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject= :dSpaceObject AND actionId= :actionId";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dSpaceObject", (Object)dso);
        query.setParameter("actionId", (Object)actionId);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoAndType(Context context, DSpaceObject dso, String type) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject.id = :dsoId AND rptype = :rptype";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dsoId", (Object)dso.getID());
        query.setParameter("rptype", (Object)type);
        query.executeUpdate();
    }

    @Override
    public void deleteByGroup(Context context, Group group) throws SQLException {
        String queryString = "delete from ResourcePolicy where epersonGroup= :epersonGroup";
        Query query = this.createQuery(context, queryString);
        query.setParameter("epersonGroup", (Object)group);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoGroupPolicies(Context context, DSpaceObject dso, Group group) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject = :dso AND epersonGroup= :epersonGroup";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dso", (Object)dso);
        query.setParameter("epersonGroup", (Object)group);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoEPersonPolicies(Context context, DSpaceObject dso, EPerson ePerson) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject= :dso AND eperson= :eperson";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dso", (Object)dso);
        query.setParameter("eperson", (Object)ePerson);
        query.executeUpdate();
    }

    @Override
    public void deleteByEPerson(Context context, EPerson ePerson) throws SQLException {
        String queryString = "delete from ResourcePolicy where eperson= :eperson";
        Query query = this.createQuery(context, queryString);
        query.setParameter("eperson", (Object)ePerson);
        query.executeUpdate();
    }

    @Override
    public void deleteByDsoAndTypeNotEqualsTo(Context context, DSpaceObject dso, String type) throws SQLException {
        String queryString = "delete from ResourcePolicy where dSpaceObject=:dso AND rptype <> :rptype";
        Query query = this.createQuery(context, queryString);
        query.setParameter("dso", (Object)dso);
        query.setParameter("rptype", (Object)type);
        query.executeUpdate();
    }

    @Override
    public List<ResourcePolicy> findByDSoAndActionExceptRpType(Context context, DSpaceObject dso, int action, String rpType) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        if (rpType != null) {
            criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.dSpaceObject), (Object)dso), criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.actionId), (Object)action), criteriaBuilder.or((Expression)criteriaBuilder.notEqual((Expression)resourcePolicyRoot.get(ResourcePolicy_.rptype), (Object)rpType), (Expression)criteriaBuilder.isNull((Expression)resourcePolicyRoot.get(ResourcePolicy_.rptype)))}));
        } else {
            criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.dSpaceObject), (Object)dso), criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.actionId), (Object)action), criteriaBuilder.isNotNull((Expression)resourcePolicyRoot.get(ResourcePolicy_.rptype))}));
        }
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, 1, 1);
    }

    @Override
    public List<ResourcePolicy> findByEPerson(Context context, EPerson ePerson, int offset, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.eperson), (Object)ePerson));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, limit, offset);
    }

    @Override
    public int countByEPerson(Context context, EPerson ePerson) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM " + ResourcePolicy.class.getSimpleName() + " WHERE eperson = :eperson ");
        query.setParameter("eperson", (Object)ePerson);
        return this.count(query);
    }

    @Override
    public List<ResourcePolicy> findByEPersonAndResourceUuid(Context context, EPerson ePerson, UUID resourceUuid, int offset, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        Join join = resourcePolicyRoot.join(ResourcePolicy_.dSpaceObject);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.eperson), (Object)ePerson), (Expression)criteriaBuilder.equal((Expression)join.get(DSpaceObject_.id), (Object)resourceUuid)));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, limit, offset);
    }

    @Override
    public int countByEPersonAndResourceUuid(Context context, EPerson eperson, UUID resourceUuid) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM " + ResourcePolicy.class.getSimpleName() + " WHERE eperson = :eperson AND dSpaceObject.id = :resourceUuid ");
        query.setParameter("resourceUuid", (Object)resourceUuid);
        query.setParameter("eperson", (Object)eperson);
        return this.count(query);
    }

    @Override
    public List<ResourcePolicy> findByResouceUuidAndActionId(Context context, UUID resourceUuid, int actionId, int offset, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        Join join = resourcePolicyRoot.join(ResourcePolicy_.dSpaceObject);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.actionId), (Object)actionId), (Expression)criteriaBuilder.equal((Expression)join.get(DSpaceObject_.id), (Object)resourceUuid)));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, limit, offset);
    }

    @Override
    public int countByResouceUuidAndActionId(Context context, UUID resourceUuid, int actionId) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM " + ResourcePolicy.class.getSimpleName() + " WHERE dSpaceObject.id = :resourceUuid AND actionId = :actionId ");
        query.setParameter("resourceUuid", (Object)resourceUuid);
        query.setParameter("actionId", (Object)actionId);
        return this.count(query);
    }

    @Override
    public List<ResourcePolicy> findByResouceUuid(Context context, UUID resourceUuid, int offset, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        Join join = resourcePolicyRoot.join(ResourcePolicy_.dSpaceObject);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)join.get(DSpaceObject_.id), (Object)resourceUuid));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, limit, offset);
    }

    @Override
    public int countByResourceUuid(Context context, UUID resourceUuid) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM " + ResourcePolicy.class.getSimpleName() + " WHERE dSpaceObject.id = :resourceUuid ");
        query.setParameter("resourceUuid", (Object)resourceUuid);
        return this.count(query);
    }

    @Override
    public List<ResourcePolicy> findByGroup(Context context, Group group, int offset, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.epersonGroup), (Object)group));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, limit, offset);
    }

    @Override
    public int countResourcePolicyByGroup(Context context, Group group) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM " + ResourcePolicy.class.getSimpleName() + " WHERE epersonGroup = :group ");
        query.setParameter("group", (Object)group);
        return this.count(query);
    }

    @Override
    public List<ResourcePolicy> findByGroupAndResourceUuid(Context context, Group group, UUID resourceUuid, int offset, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        Join join = resourcePolicyRoot.join(ResourcePolicy_.dSpaceObject);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.epersonGroup), (Object)group), (Expression)criteriaBuilder.equal((Expression)join.get(DSpaceObject_.id), (Object)resourceUuid)));
        return this.list(context, criteriaQuery, false, ResourcePolicy.class, limit, offset);
    }

    @Override
    public int countByGroupAndResourceUuid(Context context, Group group, UUID resourceUuid) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM " + ResourcePolicy.class.getSimpleName() + " WHERE dSpaceObject.id = :resourceUuid AND epersonGroup = :group ");
        query.setParameter("resourceUuid", (Object)resourceUuid);
        query.setParameter("group", (Object)group);
        return this.count(query);
    }

    @Override
    public ResourcePolicy findOneById(Context context, Integer id) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<ResourcePolicy> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, ResourcePolicy.class);
        Root resourcePolicyRoot = criteriaQuery.from(ResourcePolicy.class);
        criteriaQuery.select((Selection)resourcePolicyRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)resourcePolicyRoot.get(ResourcePolicy_.id), (Object)id));
        return (ResourcePolicy)this.singleResult(context, criteriaQuery);
    }
}

