/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent.script;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import eu.dnetlib.broker.BrokerClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.handle.HandleServiceImpl;
import org.dspace.handle.service.HandleService;
import org.dspace.qaevent.script.OpenaireEventsImportScriptConfiguration;
import org.dspace.qaevent.service.OpenaireClientFactory;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class OpenaireEventsImport
extends DSpaceRunnable<OpenaireEventsImportScriptConfiguration<OpenaireEventsImport>> {
    private HandleService handleService;
    private QAEventService qaEventService;
    private String[] topicsToImport;
    private ConfigurationService configurationService;
    private BrokerClient brokerClient;
    private ObjectMapper jsonMapper;
    private URL openaireBrokerURL;
    private String fileLocation;
    private String email;
    private Context context;

    @Override
    public OpenaireEventsImportScriptConfiguration getScriptConfiguration() {
        OpenaireEventsImportScriptConfiguration configuration = (OpenaireEventsImportScriptConfiguration)new DSpace().getServiceManager().getServiceByName("import-openaire-events", OpenaireEventsImportScriptConfiguration.class);
        return configuration;
    }

    @Override
    public void setup() throws ParseException {
        this.jsonMapper = new JsonMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DSpace dspace = new DSpace();
        this.handleService = (HandleService)dspace.getSingletonService(HandleServiceImpl.class);
        this.qaEventService = (QAEventService)dspace.getSingletonService(QAEventService.class);
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.brokerClient = OpenaireClientFactory.getInstance().getBrokerClient();
        this.topicsToImport = this.configurationService.getArrayProperty("qaevents.openaire.import.topic");
        this.openaireBrokerURL = this.getOpenaireBrokerUri();
        this.fileLocation = this.commandLine.getOptionValue("f");
        this.email = this.commandLine.getOptionValue("e");
    }

    @Override
    public void internalRun() throws Exception {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.fileLocation, this.email})) {
            throw new IllegalArgumentException("One parameter between the location of the file and the email must be entered to proceed with the import.");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.fileLocation, this.email})) {
            throw new IllegalArgumentException("Only one parameter between the location of the file and the email must be entered to proceed with the import.");
        }
        this.context = new Context();
        this.assignCurrentUserInContext();
        try {
            this.importOpenaireEvents();
        }
        catch (Exception ex) {
            this.handler.logError("A not recoverable error occurs during OPENAIRE events import: " + this.getMessage(ex), ex);
            throw ex;
        }
    }

    private void importOpenaireEvents() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.fileLocation)) {
            this.handler.logInfo("Trying to read the QA events from the provided file");
            this.importOpenaireEventsFromFile();
        } else {
            this.handler.logInfo("Trying to read the QA events from the OPENAIRE broker");
            this.importOpenaireEventsFromBroker();
        }
    }

    private void importOpenaireEventsFromFile() throws Exception {
        InputStream eventsFileInputStream = this.getQAEventsFileInputStream();
        List<QAEvent> qaEvents = this.readOpenaireQAEventsFromJson(eventsFileInputStream);
        this.handler.logInfo("Found " + qaEvents.size() + " events in the given file");
        this.storeOpenaireQAEvents(qaEvents);
    }

    private void importOpenaireEventsFromBroker() {
        List<String> subscriptionIds = this.listEmailSubscriptions();
        this.handler.logInfo("Found " + subscriptionIds.size() + " subscriptions related to the given email");
        for (String subscriptionId : subscriptionIds) {
            List<QAEvent> events = this.readOpenaireQAEventsFromBroker(subscriptionId);
            this.handler.logInfo("Found " + events.size() + " events from the subscription " + subscriptionId);
            this.storeOpenaireQAEvents(events);
        }
    }

    private InputStream getQAEventsFileInputStream() throws Exception {
        return this.handler.getFileStream(this.context, this.fileLocation).orElseThrow(() -> new IllegalArgumentException("Error reading file, the file couldn't be found for filename: " + this.fileLocation));
    }

    private List<QAEvent> readOpenaireQAEventsFromBroker(String subscriptionId) {
        try {
            InputStream eventsInputStream = this.getEventsBySubscriptions(subscriptionId);
            return this.readOpenaireQAEventsFromJson(eventsInputStream);
        }
        catch (Exception ex) {
            this.handler.logError("An error occurs downloading the events related to the subscription " + subscriptionId + ": " + this.getMessage(ex), ex);
            return List.of();
        }
    }

    private List<QAEvent> readOpenaireQAEventsFromJson(InputStream inputStream) throws Exception {
        return (List)this.jsonMapper.readValue(inputStream, (TypeReference)new TypeReference<List<QAEvent>>(){});
    }

    private void storeOpenaireQAEvents(List<QAEvent> events) {
        for (QAEvent event : events) {
            try {
                String resourceUUID = this.getResourceUUID(this.context, event.getOriginalId());
                if (resourceUUID == null) {
                    throw new IllegalArgumentException("Skipped event " + event.getEventId() + " related to the oai record " + event.getOriginalId() + " as the record was not found");
                }
                event.setTarget(resourceUUID);
                this.storeOpenaireQAEvent(event);
            }
            catch (RuntimeException | SQLException e) {
                this.handler.logWarning("An error occurs storing the event with id " + event.getEventId() + ": " + this.getMessage(e));
            }
        }
    }

    private String getResourceUUID(Context context, String originalId) throws IllegalStateException, SQLException {
        String id = this.getHandleFromOriginalId(originalId);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            DSpaceObject dso = this.handleService.resolveToObject(context, id);
            if (dso != null && dso.getType() == 2) {
                Item item = (Item)dso;
                String itemUuid = item.getID().toString();
                context.uncacheEntity(item);
                return itemUuid;
            }
            return null;
        }
        throw new IllegalArgumentException("Malformed originalId " + originalId);
    }

    private String getHandleFromOriginalId(String originalId) {
        int startPosition = originalId.lastIndexOf(58);
        if (startPosition != -1) {
            return originalId.substring(startPosition + 1, originalId.length());
        }
        return originalId;
    }

    private void storeOpenaireQAEvent(QAEvent event) {
        if (!StringUtils.equalsAny((CharSequence)event.getTopic(), (CharSequence[])this.topicsToImport)) {
            this.handler.logWarning("Event for topic " + event.getTopic() + " is not allowed in the qaevents.cfg");
            return;
        }
        event.setSource("openaire");
        this.qaEventService.store(this.context, event);
    }

    private InputStream getEventsBySubscriptions(String subscriptionId) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.brokerClient.downloadEvents(this.openaireBrokerURL, subscriptionId, (OutputStream)outputStream);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private List<String> listEmailSubscriptions() {
        try {
            return this.brokerClient.listSubscriptions(this.openaireBrokerURL, this.email);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("An error occurs retriving the subscriptions from the OPENAIRE broker: " + this.getMessage(ex), ex);
        }
    }

    private URL getOpenaireBrokerUri() {
        try {
            return new URL(this.configurationService.getProperty("qaevents.openaire.broker-url", "http://api.openaire.eu/broker"));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("The configured OPENAIRE broker URL is not valid.", e);
        }
    }

    private String getMessage(Exception ex) {
        String message = ExceptionUtils.getRootCauseMessage((Throwable)ex);
        return StringUtils.isNotBlank((CharSequence)message) ? StringUtils.substringAfter((String)message, (String)":").trim() : "";
    }

    private void assignCurrentUserInContext() throws SQLException {
        UUID uuid = this.getEpersonIdentifier();
        if (uuid != null) {
            EPerson ePerson = (EPerson)EPersonServiceFactory.getInstance().getEPersonService().find(this.context, uuid);
            this.context.setCurrentUser(ePerson);
        }
    }
}

