/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.dao.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.content.DSpaceObject;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOI_;
import org.dspace.identifier.dao.DOIDAO;

public class DOIDAOImpl
extends AbstractHibernateDAO<DOI>
implements DOIDAO {
    protected DOIDAOImpl() {
    }

    @Override
    public DOI findByDoi(Context context, String doi) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<DOI> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, DOI.class);
        Root doiRoot = criteriaQuery.from(DOI.class);
        criteriaQuery.select((Selection)doiRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)doiRoot.get(DOI_.doi), (Object)doi));
        return this.uniqueResult(context, criteriaQuery, false, DOI.class);
    }

    @Override
    public DOI findDOIByDSpaceObject(Context context, DSpaceObject dso, List<Integer> statusToExclude) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<DOI> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, DOI.class);
        Root doiRoot = criteriaQuery.from(DOI.class);
        criteriaQuery.select((Selection)doiRoot);
        ArrayList<Predicate> listToIncludeInOrPredicate = new ArrayList<Predicate>(statusToExclude.size() + 1);
        for (Integer status : statusToExclude) {
            listToIncludeInOrPredicate.add(criteriaBuilder.notEqual((Expression)doiRoot.get(DOI_.status), (Object)status));
        }
        listToIncludeInOrPredicate.add(criteriaBuilder.isNull((Expression)doiRoot.get(DOI_.status)));
        Predicate orPredicate = criteriaBuilder.or(listToIncludeInOrPredicate.toArray(new Predicate[0]));
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)orPredicate, (Expression)criteriaBuilder.equal((Expression)doiRoot.get(DOI_.dSpaceObject), (Object)dso)));
        return (DOI)this.singleResult(context, criteriaQuery);
    }

    @Override
    public List<DOI> findByStatus(Context context, List<Integer> statuses) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<DOI> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, DOI.class);
        Root doiRoot = criteriaQuery.from(DOI.class);
        criteriaQuery.select((Selection)doiRoot);
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>(statuses.size());
        for (Integer status : statuses) {
            orPredicates.add(criteriaBuilder.equal((Expression)doiRoot.get(DOI_.status), (Object)status));
        }
        criteriaQuery.where((Expression)criteriaBuilder.or(orPredicates.toArray(new Predicate[0])));
        return this.list(context, criteriaQuery, false, DOI.class, -1, -1);
    }

    @Override
    public List<DOI> findSimilarNotInState(Context context, String doi, List<Integer> excludedStatuses, boolean dsoNotNull) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<DOI> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, DOI.class);
        Root doiRoot = criteriaQuery.from(DOI.class);
        criteriaQuery.select((Selection)doiRoot);
        ArrayList<Predicate> listToIncludeInOrPredicate = new ArrayList<Predicate>(excludedStatuses.size());
        for (Integer status : excludedStatuses) {
            listToIncludeInOrPredicate.add(criteriaBuilder.notEqual((Expression)doiRoot.get(DOI_.status), (Object)status));
        }
        ArrayList<Predicate> listToIncludeInAndPredicate = new ArrayList<Predicate>();
        listToIncludeInAndPredicate.add(criteriaBuilder.like((Expression)doiRoot.get(DOI_.doi), doi));
        listToIncludeInAndPredicate.add(criteriaBuilder.or(listToIncludeInOrPredicate.toArray(new Predicate[0])));
        if (dsoNotNull) {
            listToIncludeInAndPredicate.add(criteriaBuilder.isNotNull((Expression)doiRoot.get(DOI_.dSpaceObject)));
        }
        criteriaQuery.where(listToIncludeInAndPredicate.toArray(new Predicate[0]));
        return this.list(context, criteriaQuery, false, DOI.class, -1, -1);
    }

    @Override
    public DOI findDOIByDSpaceObject(Context context, DSpaceObject dso) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<DOI> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, DOI.class);
        Root doiRoot = criteriaQuery.from(DOI.class);
        criteriaQuery.select((Selection)doiRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)doiRoot.get(DOI_.dSpaceObject), (Object)dso));
        return (DOI)this.singleResult(context, criteriaQuery);
    }
}

