/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class EPersonConsumer
implements Consumer {
    private static final Logger log = LogManager.getLogger(EPersonConsumer.class);
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context context, Event event) throws Exception {
        int st = event.getSubjectType();
        int et = event.getEventType();
        UUID id = event.getSubjectID();
        switch (st) {
            case 7: {
                if (et == 1) {
                    String notifyRecipient = this.configurationService.getProperty("registration.notify");
                    EPerson eperson = (EPerson)this.ePersonService.find(context, id);
                    if (notifyRecipient == null) {
                        notifyRecipient = "";
                    }
                    if (!(notifyRecipient = notifyRecipient.trim()).equals("")) {
                        try {
                            Email adminEmail = Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "registration_notify"));
                            adminEmail.addRecipient(notifyRecipient);
                            adminEmail.addArgument(this.configurationService.getProperty("dspace.name"));
                            adminEmail.addArgument(this.configurationService.getProperty("dspace.ui.url"));
                            adminEmail.addArgument(eperson.getFirstName() + " " + eperson.getLastName());
                            adminEmail.addArgument(eperson.getEmail());
                            adminEmail.addArgument(new Date());
                            adminEmail.setReplyTo(eperson.getEmail());
                            adminEmail.send();
                            log.info(LogHelper.getHeader(context, "registerion_alert", "user=" + eperson.getEmail()));
                        }
                        catch (MessagingException me) {
                            log.warn(LogHelper.getHeader(context, "error_emailing_administrator", ""), (Throwable)me);
                        }
                    }
                    if (!this.configurationService.getBooleanProperty("mail.welcome.enabled", false)) break;
                    String addressee = eperson.getEmail();
                    if (StringUtils.isNotBlank((CharSequence)addressee)) {
                        log.debug("Sending welcome email to {}", (Object)addressee);
                        try {
                            Email message = Email.getEmail(I18nUtil.getEmailFilename(context.getCurrentLocale(), "welcome"));
                            message.addRecipient(addressee);
                            message.send();
                        }
                        catch (MessagingException | IOException ex) {
                            log.warn("Welcome message not sent to {}:  {}", (Object)addressee, (Object)ex.getMessage());
                        }
                        break;
                    }
                    log.warn("Welcome message not sent to EPerson {} because it has no email address.", (Object)eperson.getID().toString());
                    break;
                }
                if (et != 32) break;
                break;
            }
            default: {
                log.warn("consume() got unrecognized event: " + event.toString());
            }
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
    }

    @Override
    public void finish(Context ctx) {
    }
}

