/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dspace.checker.ChecksumResult;
import org.dspace.content.Bitstream;

@Entity
@Table(name="most_recent_checksum")
public class MostRecentChecksum
implements Serializable {
    @Id
    @OneToOne
    @JoinColumn(name="bitstream_id", nullable=false)
    private Bitstream bitstream;
    @Column(name="to_be_processed", nullable=false)
    private boolean toBeProcessed;
    @Column(name="expected_checksum", nullable=false)
    private String expectedChecksum;
    @Column(name="current_checksum", nullable=false)
    private String currentChecksum;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_process_start_date", nullable=false)
    private Date processStartDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_process_end_date", nullable=false)
    private Date processEndDate;
    @Column(name="checksum_algorithm", nullable=false)
    private String checksumAlgorithm;
    @Column(name="matched_prev_checksum", nullable=false)
    private boolean matchedPrevChecksum;
    @Transient
    private boolean infoFound;
    @Transient
    private boolean bitstreamFound;
    @OneToOne
    @JoinColumn(name="result", referencedColumnName="result_code")
    private ChecksumResult checksumResult;

    protected MostRecentChecksum() {
    }

    public Bitstream getBitstream() {
        return this.bitstream;
    }

    void setBitstream(Bitstream bitstream) {
        this.bitstream = bitstream;
    }

    public boolean isToBeProcessed() {
        return this.toBeProcessed;
    }

    public void setToBeProcessed(boolean toBeProcessed) {
        this.toBeProcessed = toBeProcessed;
    }

    public String getExpectedChecksum() {
        return this.expectedChecksum;
    }

    public void setExpectedChecksum(String expectedChecksum) {
        this.expectedChecksum = expectedChecksum;
    }

    public String getCurrentChecksum() {
        return this.currentChecksum;
    }

    public void setCurrentChecksum(String currentChecksum) {
        this.currentChecksum = currentChecksum;
    }

    public Date getProcessStartDate() {
        return this.processStartDate;
    }

    public void setProcessStartDate(Date processStartDate) {
        this.processStartDate = processStartDate;
    }

    public Date getProcessEndDate() {
        return this.processEndDate;
    }

    public void setProcessEndDate(Date processEndDate) {
        this.processEndDate = processEndDate;
    }

    public String getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public void setChecksumAlgorithm(String checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }

    public boolean isMatchedPrevChecksum() {
        return this.matchedPrevChecksum;
    }

    public void setMatchedPrevChecksum(boolean matchedPrevChecksum) {
        this.matchedPrevChecksum = matchedPrevChecksum;
    }

    public ChecksumResult getChecksumResult() {
        return this.checksumResult;
    }

    public void setChecksumResult(ChecksumResult checksumResult) {
        this.checksumResult = checksumResult;
    }

    public boolean isInfoFound() {
        return this.infoFound;
    }

    public void setInfoFound(boolean infoFound) {
        this.infoFound = infoFound;
    }

    public boolean isBitstreamFound() {
        return this.bitstreamFound;
    }

    public void setBitstreamFound(boolean bitstreamFound) {
        this.bitstreamFound = bitstreamFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MostRecentChecksum)) {
            return false;
        }
        MostRecentChecksum that = (MostRecentChecksum)o;
        return new EqualsBuilder().append(this.toBeProcessed, that.toBeProcessed).append(this.matchedPrevChecksum, that.matchedPrevChecksum).append(this.infoFound, that.infoFound).append(this.bitstreamFound, that.bitstreamFound).append((Object)this.bitstream, (Object)that.bitstream).append((Object)this.expectedChecksum, (Object)that.expectedChecksum).append((Object)this.currentChecksum, (Object)that.currentChecksum).append((Object)this.processStartDate, (Object)that.processStartDate).append((Object)this.processEndDate, (Object)that.processEndDate).append((Object)this.checksumAlgorithm, (Object)that.checksumAlgorithm).append((Object)this.checksumResult, (Object)that.checksumResult).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.bitstream).append(this.toBeProcessed).append((Object)this.expectedChecksum).append((Object)this.currentChecksum).append((Object)this.processStartDate).append((Object)this.processEndDate).append((Object)this.checksumAlgorithm).append(this.matchedPrevChecksum).append(this.infoFound).append(this.bitstreamFound).append((Object)this.checksumResult).toHashCode();
    }
}

