/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DSpaceWebappMXBean;
import org.dspace.app.util.WebApp;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.WebAppService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public abstract class AbstractDSpaceWebapp
implements DSpaceWebappMXBean {
    private static final Logger log = LogManager.getLogger();
    protected final WebAppService webAppService = UtilServiceFactory.getInstance().getWebAppService();
    protected String kind;
    protected Date started;
    protected String url;
    protected WebApp webApp;

    protected AbstractDSpaceWebapp() {
    }

    public AbstractDSpaceWebapp(String kind) {
        this.kind = kind;
        this.started = new Date();
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.url = configurationService.getProperty("dspace.ui.url");
        if (null == this.url) {
            throw new IllegalStateException("dspace.ui.url is undefined");
        }
    }

    public void register() {
        Timestamp now = new Timestamp(this.started.getTime());
        try {
            Context context = new Context();
            this.webApp = this.webAppService.create(context, this.kind, this.url, now, this.isUI() ? 1 : 0);
            context.complete();
        }
        catch (SQLException e) {
            log.error("Failed to record startup in Webapp table.", (Throwable)e);
        }
    }

    public void deregister() {
        try {
            Context context = new Context();
            this.webAppService.delete(context, this.webApp);
            context.complete();
        }
        catch (SQLException e) {
            log.error("Failed to record shutdown in Webapp table.", (Throwable)e);
        }
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getStarted() {
        return this.started.toString();
    }
}

