/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion;

import java.util.LinkedList;
import java.util.List;
import org.dspace.app.suggestion.SuggestionEvidence;
import org.dspace.content.Item;
import org.dspace.content.dto.MetadataValueDTO;

public class Suggestion {
    private String id;
    private String display;
    private String source;
    private String externalSourceUri;
    private Item target;
    private List<SuggestionEvidence> evidences = new LinkedList<SuggestionEvidence>();
    private List<MetadataValueDTO> metadata = new LinkedList<MetadataValueDTO>();

    public Suggestion(String source, Item target, String idPart) {
        this.source = source;
        this.target = target;
        this.id = source + ":" + target.getID().toString() + ":" + idPart;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getSource() {
        return this.source;
    }

    public String getExternalSourceUri() {
        return this.externalSourceUri;
    }

    public void setExternalSourceUri(String externalSourceUri) {
        this.externalSourceUri = externalSourceUri;
    }

    public List<SuggestionEvidence> getEvidences() {
        return this.evidences;
    }

    public List<MetadataValueDTO> getMetadata() {
        return this.metadata;
    }

    public Item getTarget() {
        return this.target;
    }

    public String getID() {
        return this.id;
    }

    public Double getScore() {
        if (this.evidences != null && this.evidences.size() > 0) {
            double score = 0.0;
            for (SuggestionEvidence evidence : this.evidences) {
                score += evidence.getScore();
            }
            return score;
        }
        return null;
    }
}

