/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.NotifyPatternToTrigger;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.NotifyServiceInboundPattern;
import org.dspace.app.ldn.factory.NotifyServiceFactory;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.app.ldn.service.NotifyPatternToTriggerService;
import org.dspace.app.ldn.service.NotifyServiceInboundPatternService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.logic.LogicalStatement;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LDN;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.web.ContextUtil;

public class LDNMessageConsumer
implements Consumer {
    private NotifyPatternToTriggerService notifyPatternToTriggerService;
    private NotifyServiceInboundPatternService inboundPatternService;
    private LDNMessageService ldnMessageService;
    private ConfigurationService configurationService;
    private ItemService itemService;
    private BitstreamService bitstreamService;
    private final String RESUBMISSION_SUFFIX = "-resubmission";
    private final String ENDORSEMENT_PATTERN = "request-endorsement";
    private final String REVIEW_PATTERN = "request-review";

    @Override
    public void initialize() throws Exception {
        this.notifyPatternToTriggerService = NotifyServiceFactory.getInstance().getNotifyPatternToTriggerService();
        this.ldnMessageService = NotifyServiceFactory.getInstance().getLDNMessageService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        this.inboundPatternService = NotifyServiceFactory.getInstance().getNotifyServiceInboundPatternService();
    }

    @Override
    public void consume(Context context, Event event) throws Exception {
        if (event.getSubjectType() != 2 || event.getEventType() != 64) {
            return;
        }
        Item item = (Item)event.getSubject(context);
        if (item == null) {
            return;
        }
        this.createManualLDNMessages(context, item);
        this.createAutomaticLDNMessages(context, item);
    }

    private void createManualLDNMessages(Context context, Item item) throws SQLException, JsonProcessingException {
        List<NotifyPatternToTrigger> patternsToTrigger = this.notifyPatternToTriggerService.findByItem(context, item);
        List<Integer> patternsSupportingResubmission = patternsToTrigger.stream().filter(p -> p.getPattern().equals("request-review") || p.getPattern().equals("request-endorsement")).map(NotifyPatternToTrigger::getID).toList();
        String resubmissionReplyToID = null;
        for (NotifyPatternToTrigger patternToTrigger : patternsToTrigger) {
            if (patternsSupportingResubmission.contains(patternToTrigger.getID())) {
                resubmissionReplyToID = this.findResubmissionReplyToUUID(context, item, patternToTrigger.getNotifyService());
            }
            this.createLDNMessage(context, patternToTrigger.getItem(), patternToTrigger.getNotifyService(), patternToTrigger.getPattern(), resubmissionReplyToID);
        }
    }

    private void createAutomaticLDNMessages(Context context, Item item) throws SQLException, JsonProcessingException {
        List<NotifyServiceInboundPattern> inboundPatterns = this.inboundPatternService.findAutomaticPatterns(context);
        for (NotifyServiceInboundPattern inboundPattern : inboundPatterns) {
            if (!StringUtils.isEmpty((CharSequence)inboundPattern.getConstraint()) && !this.evaluateFilter(context, item, inboundPattern.getConstraint())) continue;
            this.createLDNMessage(context, item, inboundPattern.getNotifyService(), inboundPattern.getPattern(), null);
        }
    }

    private String findResubmissionReplyToUUID(Context context, Item item, NotifyServiceEntity service) throws SQLException {
        Version currentVersion;
        Version previousVersion;
        VersionHistoryService versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
        VersionHistory versionHistory = versionHistoryService.findByItem(context, item);
        if (versionHistory != null && (previousVersion = versionHistoryService.getPrevious(context, versionHistory, currentVersion = versionHistoryService.getVersion(context, versionHistory, item))) != null) {
            return this.ldnMessageService.findEndorsementOrReviewResubmissionIdByItem(context, previousVersion.getItem(), service);
        }
        return null;
    }

    private boolean evaluateFilter(Context context, Item item, String constraint) {
        LogicalStatement filter = (LogicalStatement)new DSpace().getServiceManager().getServiceByName(constraint, LogicalStatement.class);
        return filter != null && filter.getResult(context, item);
    }

    private void createLDNMessage(Context context, Item item, NotifyServiceEntity service, String pattern, String resubmissionID) throws SQLException, JsonProcessingException {
        LDN ldn = resubmissionID != null ? this.getLDNMessage(pattern + "-resubmission") : this.getLDNMessage(pattern);
        LDNMessageEntity ldnMessage = this.ldnMessageService.create(context, String.format("urn:uuid:%s", UUID.randomUUID()));
        ldnMessage.setObject(item);
        ldnMessage.setTarget(service);
        ldnMessage.setQueueStatus(LDNMessageEntity.QUEUE_STATUS_QUEUED);
        ldnMessage.setQueueTimeout(new Date());
        String actorID = null;
        boolean serviceUsesActorEmailId = this.configurationService.getBooleanProperty(String.format("ldn.notification.supportsActorEmailId.%d", service.getID()), false);
        if (serviceUsesActorEmailId) {
            actorID = item.getSubmitter() != null ? item.getSubmitter().getEmail() : this.configurationService.getProperty("ldn.notification.email.submitter.fallback");
        }
        this.appendGeneratedMessage(ldn, ldnMessage, actorID, actorID != null && item.getSubmitter() != null ? item.getSubmitter().getFullName() : null, resubmissionID);
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(ldnMessage.getMessage(), Notification.class);
        ldnMessage.setType(StringUtils.joinWith((String)",", (Object[])new Object[]{notification.getType()}));
        ArrayList<String> notificationTypeArrayList = new ArrayList<String>(notification.getType());
        Collections.sort(notificationTypeArrayList);
        ldnMessage.setActivityStreamType(notificationTypeArrayList.get(0));
        ldnMessage.setCoarNotifyType(notificationTypeArrayList.get(1));
        if (resubmissionID != null) {
            ldnMessage.setInReplyTo(this.ldnMessageService.find(context, resubmissionID));
        }
        this.ldnMessageService.update(context, ldnMessage);
    }

    private LDN getLDNMessage(String pattern) {
        try {
            return LDN.getLDNMessage(I18nUtil.getLDNFilename(Locale.getDefault(), pattern));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendGeneratedMessage(LDN ldn, LDNMessageEntity ldnMessage, String actorID, String actorName, String resubmissionId) {
        Item item = (Item)ldnMessage.getObject();
        if (actorID != null) {
            ldn.addArgument("mailto:" + actorID);
        } else {
            ldn.addArgument(this.getUiUrl());
        }
        ldn.addArgument(this.configurationService.getProperty("ldn.notify.inbox"));
        ldn.addArgument(actorName != null ? actorName : this.configurationService.getProperty("dspace.name"));
        ldn.addArgument(Objects.requireNonNullElse(ldnMessage.getTarget().getUrl(), ""));
        ldn.addArgument(Objects.requireNonNullElse(ldnMessage.getTarget().getLdnUrl(), ""));
        ldn.addArgument(this.getUiUrl() + "/handle/" + ldnMessage.getObject().getHandle());
        ldn.addArgument(this.getIdentifierUri(item));
        ldn.addArgument(this.generateBitstreamDownloadUrl(item));
        ldn.addArgument(this.getBitstreamMimeType(this.findPrimaryBitstream(item)));
        ldn.addArgument(ldnMessage.getID());
        ldn.addArgument(this.getRelationUri(item));
        ldn.addArgument("http://purl.org/vocab/frbr/core#supplement");
        ldn.addArgument(String.format("urn:uuid:%s", UUID.randomUUID()));
        if (actorID != null) {
            ldn.addArgument("Person");
        } else {
            ldn.addArgument("Service");
        }
        ldn.addArgument(this.getUiUrl());
        if (resubmissionId != null) {
            ldn.addArgument(String.format("\"inReplyTo\": \"%s\",", resubmissionId));
        }
        ldnMessage.setMessage(ldn.generateLDNMessage());
    }

    private String getUiUrl() {
        return this.configurationService.getProperty("dspace.ui.url");
    }

    private String getIdentifierUri(Item item) {
        return this.itemService.getMetadataByMetadataString(item, "dc.identifier.uri").stream().findFirst().map(MetadataValue::getValue).orElse("");
    }

    private String getRelationUri(Item item) {
        String relationMetadata = this.configurationService.getProperty("ldn.notify.relation.metadata", "dc.relation");
        return this.itemService.getMetadataByMetadataString(item, relationMetadata).stream().findFirst().map(MetadataValue::getValue).orElse("");
    }

    private String generateBitstreamDownloadUrl(Item item) {
        String uiUrl = this.getUiUrl();
        return this.findPrimaryBitstream(item).map(bs -> uiUrl + "/bitstreams/" + bs.getID() + "/download").orElse("");
    }

    private Optional<Bitstream> findPrimaryBitstream(Item item) {
        List<Bundle> bundles = item.getBundles("ORIGINAL");
        return bundles.stream().findFirst().map(Bundle::getPrimaryBitstream).or(() -> bundles.stream().findFirst().flatMap(bundle -> CollectionUtils.isNotEmpty(bundle.getBitstreams()) ? Optional.of(bundle.getBitstreams().get(0)) : Optional.empty()));
    }

    private String getBitstreamMimeType(Optional<Bitstream> bitstream) {
        return bitstream.map(bs -> {
            try {
                Context context = ContextUtil.obtainCurrentRequestContext();
                BitstreamFormat bitstreamFormat = bs.getFormat(context);
                if (bitstreamFormat.getShortDescription().equals("Unknown")) {
                    return this.getUserFormatMimeType((Bitstream)bs);
                }
                return bitstreamFormat.getMIMEType();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).orElse("");
    }

    private String getUserFormatMimeType(Bitstream bitstream) {
        return this.bitstreamService.getMetadataFirstValue(bitstream, "dc", "format", "mimetype", "*");
    }

    @Override
    public void end(Context ctx) throws Exception {
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

