/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.file.PathUtils;
import org.dspace.app.itemexport.ItemExportScriptConfiguration;
import org.dspace.app.itemexport.factory.ItemExportServiceFactory;
import org.dspace.app.itemexport.service.ItemExportService;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.utils.DSpace;

public class ItemExport
extends DSpaceRunnable<ItemExportScriptConfiguration> {
    public static final String TEMP_DIR = "exportSAF";
    public static final String ZIP_NAME = "exportSAFZip";
    public static final String ZIP_FILENAME = "saf-export";
    public static final String ZIP_EXT = "zip";
    protected String typeString = null;
    protected String destDirName = null;
    protected String idString = null;
    protected int seqStart = -1;
    protected int type = -1;
    protected Item item = null;
    protected Collection collection = null;
    protected boolean migrate = false;
    protected boolean zip = false;
    protected String zipFileName = "";
    protected boolean excludeBitstreams = false;
    protected boolean help = false;
    protected static HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected static ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected static CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final EPersonService epersonService = EPersonServiceFactory.getInstance().getEPersonService();

    @Override
    public ItemExportScriptConfiguration getScriptConfiguration() {
        return (ItemExportScriptConfiguration)new DSpace().getServiceManager().getServiceByName("export", ItemExportScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.help = this.commandLine.hasOption('h');
        if (this.commandLine.hasOption('t')) {
            this.typeString = this.commandLine.getOptionValue('t');
            if ("ITEM".equals(this.typeString)) {
                this.type = 2;
            } else if ("COLLECTION".equals(this.typeString)) {
                this.type = 3;
            }
        }
        if (this.commandLine.hasOption('i')) {
            this.idString = this.commandLine.getOptionValue('i');
        }
        this.setNumber();
        if (this.commandLine.hasOption('m')) {
            this.migrate = true;
        }
        if (this.commandLine.hasOption('x')) {
            this.excludeBitstreams = true;
        }
    }

    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.printHelp();
            return;
        }
        this.validate();
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        if (this.type == 2) {
            if (this.idString.indexOf(47) != -1) {
                this.item = (Item)handleService.resolveToObject(context, this.idString);
                if (this.item == null || this.item.getType() != 2) {
                    this.item = null;
                }
            } else {
                this.item = (Item)itemService.find(context, UUID.fromString(this.idString));
            }
            if (this.item == null) {
                this.handler.logError("The item cannot be found: " + this.idString + " (run with -h flag for details)");
                throw new UnsupportedOperationException("The item cannot be found: " + this.idString);
            }
        } else {
            if (this.idString.indexOf(47) != -1) {
                this.collection = (Collection)handleService.resolveToObject(context, this.idString);
                if (this.collection == null || this.collection.getType() != 3) {
                    this.collection = null;
                }
            } else {
                this.collection = (Collection)collectionService.find(context, UUID.fromString(this.idString));
            }
            if (this.collection == null) {
                this.handler.logError("The collection cannot be found: " + this.idString + " (run with -h flag for details)");
                throw new UnsupportedOperationException("The collection cannot be found: " + this.idString);
            }
        }
        ItemExportService itemExportService = ItemExportServiceFactory.getInstance().getItemExportService();
        try {
            itemExportService.setHandler(this.handler);
            this.process(context, itemExportService);
            context.complete();
        }
        catch (Exception e) {
            context.abort();
            throw new Exception(e);
        }
    }

    protected void validate() {
        if (this.type == -1) {
            this.handler.logError("The type must be either COLLECTION or ITEM (run with -h flag for details)");
            throw new UnsupportedOperationException("The type must be either COLLECTION or ITEM");
        }
        if (this.idString == null) {
            this.handler.logError("The ID must be set to either a database ID or a handle (run with -h flag for details)");
            throw new UnsupportedOperationException("The ID must be set to either a database ID or a handle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Context context, ItemExportService itemExportService) throws Exception {
        Iterator<Item> items;
        this.setEPerson(context);
        this.setDestDirName(context, itemExportService);
        this.setZip(context);
        if (this.item != null) {
            ArrayList<Item> myItems = new ArrayList<Item>();
            myItems.add(this.item);
            items = myItems.iterator();
        } else {
            this.handler.logInfo("Exporting from collection: " + this.idString);
            items = itemService.findByCollection(context, this.collection);
        }
        itemExportService.exportAsZip(context, items, this.destDirName, this.zipFileName, this.seqStart, this.migrate, this.excludeBitstreams);
        File zip = new File(this.destDirName + System.getProperty("file.separator") + this.zipFileName);
        try (FileInputStream is = new FileInputStream(zip);){
            this.handler.writeFilestream(context, "saf-export.zip", is, ZIP_NAME);
        }
        finally {
            PathUtils.deleteDirectory((Path)Path.of(this.destDirName, new String[0]));
        }
    }

    protected void setDestDirName(Context context, ItemExportService itemExportService) throws Exception {
        this.destDirName = itemExportService.getExportWorkDirectory() + File.separator + TEMP_DIR;
    }

    protected void setZip(Context context) {
        this.zip = true;
        this.zipFileName = "saf-export-" + context.getCurrentUser().getID() + ".zip";
    }

    protected void setNumber() {
        this.seqStart = 1;
        if (this.commandLine.hasOption('n')) {
            this.seqStart = Integer.parseInt(this.commandLine.getOptionValue('n'));
        }
    }

    private void setEPerson(Context context) throws SQLException {
        EPerson myEPerson = (EPerson)epersonService.find(context, this.getEpersonIdentifier());
        if (myEPerson == null) {
            this.handler.logError("EPerson cannot be found: " + this.getEpersonIdentifier());
            throw new UnsupportedOperationException("EPerson cannot be found: " + this.getEpersonIdentifier());
        }
        context.setCurrentUser(myEPerson);
    }
}

