/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class AcceptEditRejectAction
extends ProcessingAction {
    private static final String SUBMITTER_IS_DELETED_PAGE = "submitter_deleted";

    @Override
    public void activate(Context c, XmlWorkflowItem wf) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        if (super.isOptionInParam(request)) {
            switch (Util.getSubmitButton(request, "submit_cancel")) {
                case "submit_approve": {
                    return this.processAccept(c, wfi);
                }
                case "submit_reject": {
                    return super.processRejectPage(c, wfi, request);
                }
                case "submitter_deleted": {
                    return this.processSubmitterIsDeletedPage(c, wfi, request);
                }
            }
            return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
    }

    @Override
    public List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("submit_approve");
        options.add("submit_reject");
        options.add("submit_edit_metadata");
        options.add("return_to_pool");
        return options;
    }

    public ActionResult processAccept(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException {
        super.addApprovedProvenance(c, wfi);
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    public ActionResult processSubmitterIsDeletedPage(Context c, XmlWorkflowItem wfi, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        if (request.getParameter("submit_delete") != null) {
            XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().deleteWorkflowByWorkflowItem(c, wfi, c.getCurrentUser());
            return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
        }
        if (request.getParameter("submit_keep_it") != null) {
            return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_PAGE);
    }
}

