/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.subscriptions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.subscriptions.SubscriptionEmailNotificationService;
import org.dspace.subscriptions.service.DSpaceObjectUpdates;
import org.dspace.subscriptions.service.SubscriptionGenerator;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionEmailNotificationServiceImpl
implements SubscriptionEmailNotificationService {
    private static final Logger log = LogManager.getLogger(SubscriptionEmailNotificationServiceImpl.class);
    private Map<String, DSpaceObjectUpdates> contentUpdates = new HashMap<String, DSpaceObjectUpdates>();
    private Map<String, SubscriptionGenerator> subscriptionType2generators = new HashMap<String, SubscriptionGenerator>();
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SubscribeService subscribeService;

    public SubscriptionEmailNotificationServiceImpl(Map<String, DSpaceObjectUpdates> contentUpdates, Map<String, SubscriptionGenerator> subscriptionType2generators) {
        this.contentUpdates = contentUpdates;
        this.subscriptionType2generators = subscriptionType2generators;
    }

    @Override
    public void perform(Context context, DSpaceRunnableHandler handler, String subscriptionType, String frequency) {
        EPerson currentEperson;
        block12: {
            ArrayList<IndexableObject> communityItems = new ArrayList<IndexableObject>();
            ArrayList<IndexableObject> collectionsItems = new ArrayList<IndexableObject>();
            currentEperson = context.getCurrentUser();
            try {
                List<Subscription> subscriptions = this.findAllSubscriptionsBySubscriptionTypeAndFrequency(context, subscriptionType, frequency);
                if (this.subscriptionType2generators.keySet().contains(subscriptionType)) {
                    int iterator = 0;
                    for (Subscription subscription : subscriptions) {
                        DSpaceObject dSpaceObject = subscription.getDSpaceObject();
                        EPerson ePerson = subscription.getEPerson();
                        context.setCurrentUser(ePerson);
                        if (!this.authorizeService.authorizeActionBoolean(context, ePerson, dSpaceObject, 0, true)) {
                            ++iterator;
                            continue;
                        }
                        if (dSpaceObject.getType() == 4) {
                            List<IndexableObject> indexableCommunityItems = this.contentUpdates.get(Community.class.getSimpleName().toLowerCase()).findUpdates(context, dSpaceObject, frequency);
                            communityItems.addAll(this.getItems(context, ePerson, indexableCommunityItems));
                        } else if (dSpaceObject.getType() == 3) {
                            List<IndexableObject> indexableCollectionItems = this.contentUpdates.get(Collection.class.getSimpleName().toLowerCase()).findUpdates(context, dSpaceObject, frequency);
                            collectionsItems.addAll(this.getItems(context, ePerson, indexableCollectionItems));
                        } else {
                            log.warn("found an invalid DSpace Object type ({}) among subscriptions to send", (Object)dSpaceObject.getType());
                            continue;
                        }
                        if (iterator < subscriptions.size() - 1) {
                            if (ePerson.equals(subscriptions.get(iterator + 1).getEPerson())) {
                                ++iterator;
                                continue;
                            }
                            this.subscriptionType2generators.get(subscriptionType).notifyForSubscriptions(context, ePerson, communityItems, collectionsItems);
                            communityItems.clear();
                            collectionsItems.clear();
                        } else {
                            this.subscriptionType2generators.get(subscriptionType).notifyForSubscriptions(context, ePerson, communityItems, collectionsItems);
                        }
                        ++iterator;
                    }
                    break block12;
                }
                throw new IllegalArgumentException("Currently this SubscriptionType:" + subscriptionType + " is not supported!");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                handler.handleException(e);
                context.abort();
            }
        }
        context.setCurrentUser(currentEperson);
    }

    private List<IndexableObject> getItems(Context context, EPerson ePerson, List<IndexableObject> indexableItems) throws SQLException {
        ArrayList<IndexableObject> items = new ArrayList<IndexableObject>();
        for (IndexableObject indexableitem : indexableItems) {
            Item item = (Item)indexableitem.getIndexedObject();
            if (!this.authorizeService.authorizeActionBoolean(context, ePerson, item, 0, true)) continue;
            items.add(indexableitem);
        }
        return items;
    }

    private List<Subscription> findAllSubscriptionsBySubscriptionTypeAndFrequency(Context context, String subscriptionType, String frequency) {
        try {
            return this.subscribeService.findAllSubscriptionsBySubscriptionTypeAndFrequency(context, subscriptionType, frequency).stream().sorted(Comparator.comparing(s -> s.getEPerson().getID())).collect(Collectors.toList());
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ArrayList<Subscription>();
        }
    }

    @Override
    public Set<String> getSupportedSubscriptionTypes() {
        return this.subscriptionType2generators.keySet();
    }
}

