/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IM4JavaException;
import org.im4java.core.IMOperation;
import org.im4java.core.Info;
import org.im4java.core.Operation;
import org.im4java.process.ProcessStarter;

public abstract class ImageMagickThumbnailFilter
extends MediaFilter {
    private static final int DEFAULT_WIDTH = 180;
    private static final int DEFAULT_HEIGHT = 120;
    static final String DEFAULT_PATTERN = "Generated Thumbnail";
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected static final String PRE = ImageMagickThumbnailFilter.class.getName();

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".jpg";
    }

    @Override
    public String getBundleName() {
        return "THUMBNAIL";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return configurationService.getProperty(PRE + ".bitstreamDescription", "IM Thumbnail");
    }

    public File inputStreamToTempFile(InputStream source, String prefix, String suffix) throws IOException {
        File f = File.createTempFile(prefix, suffix);
        f.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(f);
        byte[] buffer = new byte[1024];
        int len = source.read(buffer);
        while (len != -1) {
            fos.write(buffer, 0, len);
            len = source.read(buffer);
        }
        fos.close();
        return f;
    }

    public File getThumbnailFile(File f, boolean verbose) throws IOException, InterruptedException, IM4JavaException {
        File f2 = new File(f.getParentFile(), f.getName() + ".jpg");
        f2.deleteOnExit();
        ConvertCmd cmd = new ConvertCmd();
        IMOperation op = new IMOperation();
        op.autoOrient();
        op.addImage(new String[]{f.getAbsolutePath()});
        op.thumbnail(Integer.valueOf(configurationService.getIntProperty("thumbnail.maxwidth", 180)), Integer.valueOf(configurationService.getIntProperty("thumbnail.maxheight", 120)));
        op.addImage(new String[]{f2.getAbsolutePath()});
        if (verbose) {
            System.out.println("IM Thumbnail Param: " + op);
        }
        cmd.run((Operation)op, new Object[0]);
        return f2;
    }

    public File getImageFile(File f, boolean verbose) throws IOException, InterruptedException, IM4JavaException {
        Info imageInfo;
        String imageClass;
        File f2 = new File(f.getParentFile(), f.getName() + ".miff");
        f2.deleteOnExit();
        ConvertCmd cmd = new ConvertCmd();
        IMOperation op = new IMOperation();
        String density = configurationService.getProperty(PRE + ".density");
        if (density != null) {
            op.density(Integer.valueOf(density));
        }
        PDPage pdfPage = Loader.loadPDF((File)f).getPage(0);
        PDRectangle pdfPageMediaBox = pdfPage.getMediaBox();
        PDRectangle pdfPageCropBox = pdfPage.getCropBox();
        if (pdfPageCropBox != pdfPageMediaBox) {
            op.define("pdf:use-cropbox=true");
        }
        String s = "[0]";
        op.addImage(new String[]{f.getAbsolutePath() + s});
        if (configurationService.getBooleanProperty(PRE + ".flatten", true)) {
            op.flatten();
        }
        String cmyk_profile = configurationService.getProperty(PRE + ".cmyk_profile");
        String srgb_profile = configurationService.getProperty(PRE + ".srgb_profile");
        if (cmyk_profile != null && srgb_profile != null && (imageClass = (imageInfo = new Info(f.getAbsolutePath() + s, true)).getImageClass()).contains("CMYK")) {
            op.profile(cmyk_profile);
            op.profile(srgb_profile);
        }
        op.addImage(new String[]{f2.getAbsolutePath()});
        if (verbose) {
            System.out.println("IM Image Param: " + op);
        }
        cmd.run((Operation)op, new Object[0]);
        return f2;
    }

    @Override
    public boolean preProcessBitstream(Context c, Item item, Bitstream source, boolean verbose) throws Exception {
        String nsrc = source.getName();
        for (Bundle b : this.itemService.getBundles(item, "THUMBNAIL")) {
            for (Bitstream bit : b.getBitstreams()) {
                Pattern replaceRegex;
                String n = bit.getName();
                if (n != null && nsrc != null && !n.startsWith(nsrc)) continue;
                String description = bit.getDescription();
                try {
                    String patt = configurationService.getProperty(PRE + ".replaceRegex", DEFAULT_PATTERN);
                    replaceRegex = Pattern.compile(patt == null ? DEFAULT_PATTERN : patt);
                }
                catch (PatternSyntaxException e) {
                    System.err.println("Invalid thumbnail replacement pattern: " + e.getMessage());
                    throw e;
                }
                if (description != null) {
                    if (replaceRegex.matcher(description).matches()) {
                        if (!verbose) continue;
                        System.out.format("%s %s matches pattern and is replaceable.%n", description, n);
                        continue;
                    }
                    if (description.equals(this.getDescription())) {
                        if (!verbose) continue;
                        System.out.format("%s %s is replaceable.%n", this.getDescription(), n);
                        continue;
                    }
                }
                System.out.format("Custom thumbnail exists for %s for item %s. Thumbnail will not be generated.%n", nsrc, item.getHandle());
                return false;
            }
        }
        return true;
    }

    static {
        String s = configurationService.getProperty(PRE + ".ProcessStarter");
        ProcessStarter.setGlobalSearchPath((String)s);
    }
}

