/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.time.DateUtils;
import org.dspace.administer.ProcessCleanerConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.ProcessStatus;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.Process;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.service.ProcessService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class ProcessCleaner
extends DSpaceRunnable<ProcessCleanerConfiguration<ProcessCleaner>> {
    private ConfigurationService configurationService;
    private ProcessService processService;
    private boolean cleanCompleted = false;
    private boolean cleanFailed = false;
    private boolean cleanRunning = false;
    private boolean help = false;
    private Integer days;

    @Override
    public void setup() throws ParseException {
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.processService = ScriptServiceFactory.getInstance().getProcessService();
        this.help = this.commandLine.hasOption('h');
        this.cleanFailed = this.commandLine.hasOption('f');
        this.cleanRunning = this.commandLine.hasOption('r');
        this.cleanCompleted = this.commandLine.hasOption('c') || !this.cleanFailed && !this.cleanRunning;
        this.days = this.configurationService.getIntProperty("process-cleaner.days", 14);
        if (this.days <= 0) {
            throw new IllegalStateException("The number of days must be a positive integer.");
        }
    }

    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.printHelp();
            return;
        }
        Context context = new Context();
        try {
            context.turnOffAuthorisationSystem();
            this.performDeletion(context);
        }
        finally {
            context.restoreAuthSystemState();
            context.complete();
        }
    }

    private void performDeletion(Context context) throws SQLException, IOException, AuthorizeException {
        List<ProcessStatus> statuses = this.getProcessToDeleteStatuses();
        Date creationDate = this.calculateCreationDate();
        this.handler.logInfo("Searching for processes with status: " + statuses);
        List<Process> processes = this.processService.findByStatusAndCreationTimeOlderThan(context, statuses, creationDate);
        this.handler.logInfo("Found " + processes.size() + " processes to be deleted");
        for (Process process : processes) {
            this.processService.delete(context, process);
        }
        this.handler.logInfo("Process cleanup completed");
    }

    private List<ProcessStatus> getProcessToDeleteStatuses() {
        ArrayList<ProcessStatus> statuses = new ArrayList<ProcessStatus>();
        if (this.cleanCompleted) {
            statuses.add(ProcessStatus.COMPLETED);
        }
        if (this.cleanFailed) {
            statuses.add(ProcessStatus.FAILED);
        }
        if (this.cleanRunning) {
            statuses.add(ProcessStatus.RUNNING);
        }
        return statuses;
    }

    private Date calculateCreationDate() {
        return DateUtils.addDays((Date)new Date(), (int)(-this.days.intValue()));
    }

    @Override
    public ProcessCleanerConfiguration<ProcessCleaner> getScriptConfiguration() {
        return (ProcessCleanerConfiguration)new DSpace().getServiceManager().getServiceByName("process-cleaner", ProcessCleanerConfiguration.class);
    }
}

