/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.actions.Action;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ProcessingAction
extends Action {
    @Autowired(required=true)
    protected ClaimedTaskService claimedTaskService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired
    protected XmlWorkflowService xmlWorkflowService;
    public static final String SUBMIT_EDIT_METADATA = "submit_edit_metadata";
    public static final String SUBMIT_CANCEL = "submit_cancel";
    protected static final String SUBMIT_APPROVE = "submit_approve";
    protected static final String SUBMIT_REJECT = "submit_reject";
    protected static final String RETURN_TO_POOL = "return_to_pool";
    protected static final String REJECT_REASON = "reason";

    @Override
    public boolean isAuthorized(Context context, HttpServletRequest request, XmlWorkflowItem wfi) throws SQLException {
        ClaimedTask task = null;
        if (context.getCurrentUser() != null) {
            task = this.claimedTaskService.findByWorkflowIdAndEPerson(context, wfi, context.getCurrentUser());
        }
        return task != null && task.getWorkflowID().equals(this.getParent().getStep().getWorkflow().getID()) && task.getStepID().equals(this.getParent().getStep().getId()) && task.getActionID().equals(this.getParent().getId());
    }

    public ActionResult processRejectPage(Context c, XmlWorkflowItem wfi, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        String reason = request.getParameter(REJECT_REASON);
        if (reason == null || 0 == reason.trim().length()) {
            this.addErrorField(request, REJECT_REASON);
            return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
        }
        this.xmlWorkflowService.sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), this.getProvenanceStartId(), reason);
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }

    @Override
    protected boolean isAdvanced() {
        return !this.getAdvancedOptions().isEmpty();
    }
}

