/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory.impl;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.orcid.client.OrcidConfiguration;
import org.dspace.orcid.exception.OrcidValidationException;
import org.dspace.orcid.model.factory.OrcidCommonObjectFactory;
import org.dspace.orcid.model.factory.OrcidFactoryUtils;
import org.dspace.orcid.model.validator.OrcidValidationError;
import org.dspace.util.MultiFormatDateParser;
import org.dspace.util.SimpleMapConverter;
import org.orcid.jaxb.model.common.ContributorRole;
import org.orcid.jaxb.model.common.FundingContributorRole;
import org.orcid.jaxb.model.common.Iso3166Country;
import org.orcid.jaxb.model.common.SequenceType;
import org.orcid.jaxb.model.v3.release.common.Contributor;
import org.orcid.jaxb.model.v3.release.common.ContributorAttributes;
import org.orcid.jaxb.model.v3.release.common.Country;
import org.orcid.jaxb.model.v3.release.common.CreditName;
import org.orcid.jaxb.model.v3.release.common.DisambiguatedOrganization;
import org.orcid.jaxb.model.v3.release.common.FuzzyDate;
import org.orcid.jaxb.model.v3.release.common.Organization;
import org.orcid.jaxb.model.v3.release.common.OrganizationAddress;
import org.orcid.jaxb.model.v3.release.common.Url;
import org.orcid.jaxb.model.v3.release.record.FundingContributor;
import org.orcid.jaxb.model.v3.release.record.FundingContributorAttributes;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidCommonObjectFactoryImpl
implements OrcidCommonObjectFactory {
    @Autowired
    private ItemService itemService;
    @Autowired
    private OrcidConfiguration orcidConfiguration;
    @Autowired
    private HandleService handleService;
    private SimpleMapConverter countryConverter;
    private String organizationTitleField;
    private String organizationCityField;
    private String organizationCountryField;
    private String contributorEmailField;
    private String contributorOrcidField;
    private Map<String, String> disambiguatedOrganizationIdentifierFields = new HashMap<String, String>();

    @Override
    public Optional<FuzzyDate> createFuzzyDate(MetadataValue metadataValue) {
        if (this.isUnprocessableValue(metadataValue)) {
            return Optional.empty();
        }
        Date date = MultiFormatDateParser.parse(metadataValue.getValue());
        if (date == null) {
            return Optional.empty();
        }
        LocalDate localDate = this.convertToLocalDate(date);
        return Optional.of(FuzzyDate.valueOf((Integer)localDate.getYear(), (Integer)localDate.getMonthValue(), (Integer)localDate.getDayOfMonth()));
    }

    @Override
    public Optional<Organization> createOrganization(Context context, Item orgUnit) {
        if (orgUnit == null) {
            return Optional.empty();
        }
        Organization organization = new Organization();
        organization.setName(this.getMetadataValue(orgUnit, this.organizationTitleField));
        organization.setAddress(this.createOrganizationAddress(orgUnit));
        organization.setDisambiguatedOrganization(this.createDisambiguatedOrganization(orgUnit));
        return Optional.of(organization);
    }

    @Override
    public Optional<Contributor> createContributor(Context context, MetadataValue metadataValue, ContributorRole role) {
        if (this.isUnprocessableValue(metadataValue)) {
            return Optional.empty();
        }
        Contributor contributor = new Contributor();
        contributor.setCreditName(new CreditName(metadataValue.getValue()));
        contributor.setContributorAttributes(this.getContributorAttributes(metadataValue, role));
        return Optional.of(contributor);
    }

    @Override
    public Optional<FundingContributor> createFundingContributor(Context context, MetadataValue metadataValue, FundingContributorRole role) {
        if (this.isUnprocessableValue(metadataValue)) {
            return Optional.empty();
        }
        FundingContributor contributor = new FundingContributor();
        contributor.setCreditName(new CreditName(metadataValue.getValue()));
        contributor.setContributorAttributes(this.getFundingContributorAttributes(metadataValue, role));
        return Optional.of(contributor);
    }

    @Override
    public Optional<Url> createUrl(Context context, Item item) {
        String handle = item.getHandle();
        if (StringUtils.isBlank((CharSequence)handle)) {
            return Optional.empty();
        }
        return Optional.of(new Url(this.handleService.getCanonicalForm(handle)));
    }

    @Override
    public Optional<Country> createCountry(Context context, MetadataValue metadataValue) {
        if (this.isUnprocessableValue(metadataValue)) {
            return Optional.empty();
        }
        Optional<Iso3166Country> country = this.convertToIso3166Country(metadataValue.getValue());
        if (country.isEmpty()) {
            throw new OrcidValidationException(OrcidValidationError.INVALID_COUNTRY);
        }
        return country.map(isoCountry -> new Country(isoCountry));
    }

    private ContributorAttributes getContributorAttributes(MetadataValue metadataValue, ContributorRole role) {
        ContributorAttributes attributes = new ContributorAttributes();
        attributes.setContributorRole((ContributorRole)(role != null ? role : null));
        attributes.setContributorSequence(metadataValue.getPlace() == 0 ? SequenceType.FIRST : SequenceType.ADDITIONAL);
        return attributes;
    }

    private OrganizationAddress createOrganizationAddress(Item organizationItem) {
        OrganizationAddress address = new OrganizationAddress();
        address.setCity(this.getMetadataValue(organizationItem, this.organizationCityField));
        this.convertToIso3166Country(this.getMetadataValue(organizationItem, this.organizationCountryField)).ifPresent(arg_0 -> ((OrganizationAddress)address).setCountry(arg_0));
        return address;
    }

    private FundingContributorAttributes getFundingContributorAttributes(MetadataValue metadataValue, FundingContributorRole role) {
        FundingContributorAttributes attributes = new FundingContributorAttributes();
        attributes.setContributorRole((FundingContributorRole)(role != null ? role : null));
        return attributes;
    }

    private DisambiguatedOrganization createDisambiguatedOrganization(Item organizationItem) {
        for (String identifierField : this.disambiguatedOrganizationIdentifierFields.keySet()) {
            String source = this.disambiguatedOrganizationIdentifierFields.get(identifierField);
            String identifier = this.getMetadataValue(organizationItem, identifierField);
            if (!StringUtils.isNotBlank((CharSequence)identifier)) continue;
            DisambiguatedOrganization disambiguatedOrganization = new DisambiguatedOrganization();
            disambiguatedOrganization.setDisambiguatedOrganizationIdentifier(identifier);
            disambiguatedOrganization.setDisambiguationSource(source);
            return disambiguatedOrganization;
        }
        return null;
    }

    private Optional<Iso3166Country> convertToIso3166Country(String countryValue) {
        return Optional.ofNullable(countryValue).map(value -> this.countryConverter != null ? this.countryConverter.getValue((String)value) : value).filter(value -> EnumUtils.isValidEnum(Iso3166Country.class, (String)value)).map(value -> Iso3166Country.fromValue((String)value));
    }

    private boolean isUnprocessableValue(MetadataValue value) {
        return value == null || StringUtils.isBlank((CharSequence)value.getValue());
    }

    private String getMetadataValue(Item item, String metadataField) {
        if (StringUtils.isNotBlank((CharSequence)metadataField)) {
            return this.itemService.getMetadataFirstValue(item, new MetadataFieldName(metadataField), "*");
        }
        return null;
    }

    private LocalDate convertToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public String getOrganizationCityField() {
        return this.organizationCityField;
    }

    public String getOrganizationCountryField() {
        return this.organizationCountryField;
    }

    public Map<String, String> getDisambiguatedOrganizationIdentifierFields() {
        return this.disambiguatedOrganizationIdentifierFields;
    }

    public String getContributorEmailField() {
        return this.contributorEmailField;
    }

    public String getContributorOrcidField() {
        return this.contributorOrcidField;
    }

    public void setItemService(ItemService itemService) {
        this.itemService = itemService;
    }

    public OrcidConfiguration getOrcidConfiguration() {
        return this.orcidConfiguration;
    }

    public void setOrcidConfiguration(OrcidConfiguration orcidConfiguration) {
        this.orcidConfiguration = orcidConfiguration;
    }

    public void setOrganizationCityField(String organizationCityField) {
        this.organizationCityField = organizationCityField;
    }

    public void setOrganizationCountryField(String organizationCountryField) {
        this.organizationCountryField = organizationCountryField;
    }

    public void setContributorEmailField(String contributorEmailField) {
        this.contributorEmailField = contributorEmailField;
    }

    public void setContributorOrcidField(String contributorOrcidField) {
        this.contributorOrcidField = contributorOrcidField;
    }

    public void setDisambiguatedOrganizationIdentifierFields(String disambiguatedOrganizationIds) {
        this.disambiguatedOrganizationIdentifierFields = OrcidFactoryUtils.parseConfigurations(disambiguatedOrganizationIds);
    }

    public SimpleMapConverter getCountryConverter() {
        return this.countryConverter;
    }

    public void setCountryConverter(SimpleMapConverter countryConverter) {
        this.countryConverter = countryConverter;
    }

    public String getOrganizationTitleField() {
        return this.organizationTitleField;
    }

    public void setOrganizationTitleField(String organizationTitleField) {
        this.organizationTitleField = organizationTitleField;
    }
}

