/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationService;
import org.dspace.discovery.utils.DiscoverQueryBuilder;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowItem;

public class SearchUtils {
    public static final String AUTHORITY_SEPARATOR = "###";
    public static final String LAST_INDEXED_FIELD = "SolrIndexer.lastIndexed";
    public static final String RESOURCE_UNIQUE_ID = "search.uniqueid";
    public static final String RESOURCE_TYPE_FIELD = "search.resourcetype";
    public static final String RESOURCE_ID_FIELD = "search.resourceid";
    public static final String NAMED_RESOURCE_TYPE = "namedresourcetype";
    public static final String FILTER_SEPARATOR = "\n|||\n";
    private static SearchService searchService;

    private SearchUtils() {
    }

    public static SearchService getSearchService() {
        if (searchService == null) {
            ServiceManager manager = DSpaceServicesFactory.getInstance().getServiceManager();
            searchService = (SearchService)manager.getServiceByName(SearchService.class.getName(), SearchService.class);
        }
        return searchService;
    }

    public static void clearCachedSearchService() {
        searchService = null;
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration() {
        return SearchUtils.getDiscoveryConfiguration(null, null, null);
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration(Context context, DSpaceObject dso) {
        return SearchUtils.getDiscoveryConfiguration(context, null, dso);
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration(Context context, String prefix, DSpaceObject dso) {
        if (prefix != null) {
            return SearchUtils.getDiscoveryConfigurationByName((String)(dso != null ? prefix + "." + dso.getHandle() : prefix));
        }
        return SearchUtils.getDiscoveryConfigurationByDSO(context, dso);
    }

    public static Set<DiscoveryConfiguration> addDiscoveryConfigurationForParents(Context context, Set<DiscoveryConfiguration> configurations, String prefix, DSpaceObject dso) throws SQLException {
        if (dso == null) {
            configurations.add(SearchUtils.getDiscoveryConfigurationByName(null));
            return configurations;
        }
        if (prefix != null) {
            configurations.add(SearchUtils.getDiscoveryConfigurationByName(prefix + "." + dso.getHandle()));
        } else {
            configurations.add(SearchUtils.getDiscoveryConfigurationByName(dso.getHandle()));
        }
        DSpaceObjectService<DSpaceObject> dSpaceObjectService = ContentServiceFactory.getInstance().getDSpaceObjectService(dso);
        DSpaceObject parentObject = dSpaceObjectService.getParentObject(context, dso);
        return SearchUtils.addDiscoveryConfigurationForParents(context, configurations, prefix, parentObject);
    }

    public static DiscoveryConfiguration getDiscoveryConfigurationByName(String configurationName) {
        DiscoveryConfigurationService configurationService = SearchUtils.getConfigurationService();
        return configurationService.getDiscoveryConfiguration(configurationName);
    }

    public static DiscoveryConfiguration getDiscoveryConfigurationByDSO(Context context, DSpaceObject dso) {
        DiscoveryConfigurationService configurationService = SearchUtils.getConfigurationService();
        return configurationService.getDiscoveryDSOConfiguration(context, dso);
    }

    public static DiscoveryConfigurationService getConfigurationService() {
        ServiceManager manager = DSpaceServicesFactory.getInstance().getServiceManager();
        return (DiscoveryConfigurationService)manager.getServiceByName(DiscoveryConfigurationService.class.getName(), DiscoveryConfigurationService.class);
    }

    public static List<String> getIgnoredMetadataFields(int type) {
        return SearchUtils.getConfigurationService().getToIgnoreMetadataFields().get(type);
    }

    public static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(Context context, Item item) throws SQLException {
        List<Collection> collections = item.getCollections();
        return SearchUtils.getAllDiscoveryConfigurations(context, null, collections, item);
    }

    public static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(Context context, WorkspaceItem witem) throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        collections.add(witem.getCollection());
        return SearchUtils.getAllDiscoveryConfigurations(context, "workspace", collections, witem.getItem());
    }

    public static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(Context context, WorkflowItem witem) throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        collections.add(witem.getCollection());
        return SearchUtils.getAllDiscoveryConfigurations(context, "workflow", collections, witem.getItem());
    }

    private static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(Context context, String prefix, List<Collection> collections, Item item) throws SQLException {
        HashSet<DiscoveryConfiguration> result = new HashSet<DiscoveryConfiguration>();
        for (Collection collection : collections) {
            SearchUtils.addDiscoveryConfigurationForParents(context, result, prefix, collection);
        }
        DiscoveryConfigurationService configurationService = SearchUtils.getConfigurationService();
        result.addAll(configurationService.getIndexAlwaysConfigurations());
        SearchUtils.addConfigurationIfExists(result, prefix);
        return Arrays.asList(result.toArray(new DiscoveryConfiguration[result.size()]));
    }

    private static void addConfigurationIfExists(Set<DiscoveryConfiguration> result, String confName) {
        DiscoveryConfiguration configurationExtra = SearchUtils.getDiscoveryConfigurationByName(confName);
        result.add(configurationExtra);
    }

    public static DiscoverQueryBuilder getQueryBuilder() {
        ServiceManager manager = DSpaceServicesFactory.getInstance().getServiceManager();
        return (DiscoverQueryBuilder)manager.getServiceByName(DiscoverQueryBuilder.class.getName(), DiscoverQueryBuilder.class);
    }
}

