/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.StreamIngestionCrosswalk;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.Context;
import org.dspace.core.Utils;

public class LicenseStreamIngestionCrosswalk
implements StreamIngestionCrosswalk {
    private static Logger log = LogManager.getLogger(LicenseStreamIngestionCrosswalk.class);

    @Override
    public void ingest(Context context, DSpaceObject dso, InputStream in, String MIMEType) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() == 2) {
            if (log.isDebugEnabled()) {
                log.debug("Reading a DSpace Deposit license, MIMEtype=" + MIMEType);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utils.copy(in, baos);
            PackageUtils.addDepositLicense(context, baos.toString(), (Item)dso, null);
        }
    }

    public String getMIMEType() {
        return "text/plain";
    }
}

