/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.Type;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="bitstreamformatregistry")
public class BitstreamFormat
implements Serializable,
ReloadableEntity<Integer> {
    @Id
    @Column(name="bitstream_format_id", nullable=false, unique=true)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="bitstreamformatregistry_seq")
    @SequenceGenerator(name="bitstreamformatregistry_seq", sequenceName="bitstreamformatregistry_seq", allocationSize=1, initialValue=1)
    private Integer id;
    @Column(name="short_description", length=128, unique=true)
    private String shortDescription;
    @Column(name="description", columnDefinition="text")
    private String description;
    @Column(name="mimetype", length=256)
    private String mimetype;
    @Column(name="support_level")
    private int supportLevel = -1;
    @Column(name="internal")
    private boolean internal = false;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="fileextension", joinColumns={@JoinColumn(name="bitstream_format_id")})
    @CollectionId(columns={@Column(name="file_extension_id")}, type=@Type(type="integer"), generator="fileextension_seq")
    @SequenceGenerator(name="fileextension_seq", sequenceName="fileextension_seq", allocationSize=1)
    @Column(name="extension")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    private List<String> fileExtensions = new ArrayList<String>();
    @Transient
    private transient BitstreamFormatService bitstreamFormatService;
    @Transient
    public static final int UNKNOWN = 0;
    @Transient
    public static final int KNOWN = 1;
    @Transient
    public static final int SUPPORTED = 2;

    protected BitstreamFormat() {
    }

    @Override
    public final Integer getID() {
        return this.id;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    void setShortDescriptionInternal(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getMIMEType() {
        return this.mimetype;
    }

    public void setMIMEType(String s) {
        this.mimetype = s;
    }

    public int getSupportLevel() {
        return this.supportLevel;
    }

    void setSupportLevelInternal(int supportLevel) {
        this.supportLevel = supportLevel;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean b) {
        this.internal = b;
    }

    public List<String> getExtensions() {
        return this.fileExtensions;
    }

    public void setExtensions(List<String> exts) {
        this.fileExtensions = exts;
    }

    public void setShortDescription(Context context, String s) throws SQLException {
        this.getBitstreamFormatService().setShortDescription(context, this, s);
    }

    public void setSupportLevel(int sl) {
        this.getBitstreamFormatService().setSupportLevel(this, sl);
    }

    private BitstreamFormatService getBitstreamFormatService() {
        if (this.bitstreamFormatService == null) {
            this.bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
        }
        return this.bitstreamFormatService;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BitstreamFormat)) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)other);
        if (this.getClass() != objClass) {
            return false;
        }
        BitstreamFormat otherBitstreamFormat = (BitstreamFormat)other;
        return this.getID().equals(otherBitstreamFormat.getID());
    }

    public int hashCode() {
        int hash = 5;
        hash += 70 * hash + this.getID();
        return hash;
    }
}

