/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class WosAttribute2ValueContributor
implements MetadataContributor<Element> {
    private static final Logger log = LogManager.getLogger();
    private String query;
    private String attribute;
    private boolean firstChild;
    private String childName;
    private Map<String, String> prefixToNamespaceMapping;
    private Map<String, MetadataFieldConfig> attributeValue2metadata;
    private MetadataFieldMapping<Element, MetadataContributor<Element>> metadataFieldMapping;

    public WosAttribute2ValueContributor() {
    }

    public WosAttribute2ValueContributor(String query, Map<String, String> prefixToNamespaceMapping, Map<String, MetadataFieldConfig> attributeValue2metadata) {
        this.query = query;
        this.prefixToNamespaceMapping = prefixToNamespaceMapping;
        this.attributeValue2metadata = attributeValue2metadata;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(Element t) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (String ns : this.prefixToNamespaceMapping.keySet()) {
            namespaces.add(Namespace.getNamespace((String)this.prefixToNamespaceMapping.get(ns), (String)ns));
        }
        XPathExpression xpath = XPathFactory.instance().compile(this.query, Filters.fpassthrough(), null, namespaces);
        List nodes = xpath.evaluate((Object)t);
        for (Object el : nodes) {
            if (el instanceof Element) {
                Element element = (Element)el;
                String attributeValue = element.getAttributeValue(this.attribute);
                this.setField(attributeValue, element, values);
                continue;
            }
            log.warn("node of type: " + el.getClass());
        }
        return values;
    }

    private void setField(String attributeValue, Element el, List<MetadatumDTO> values) {
        for (String id : this.attributeValue2metadata.keySet()) {
            if (!StringUtils.equals((CharSequence)id, (CharSequence)attributeValue)) continue;
            if (this.firstChild) {
                String value = el.getChild(this.childName).getValue();
                values.add(this.metadataFieldMapping.toDCValue(this.attributeValue2metadata.get(id), value));
                continue;
            }
            values.add(this.metadataFieldMapping.toDCValue(this.attributeValue2metadata.get(id), el.getText()));
        }
    }

    public MetadataFieldMapping<Element, MetadataContributor<Element>> getMetadataFieldMapping() {
        return this.metadataFieldMapping;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<Element, MetadataContributor<Element>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
    }

    @Resource(name="isiFullprefixMapping")
    public void setPrefixToNamespaceMapping(Map<String, String> prefixToNamespaceMapping) {
        this.prefixToNamespaceMapping = prefixToNamespaceMapping;
    }

    public Map<String, String> getPrefixToNamespaceMapping() {
        return this.prefixToNamespaceMapping;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Map<String, MetadataFieldConfig> getAttributeValue2metadata() {
        return this.attributeValue2metadata;
    }

    public void setAttributeValue2metadata(Map<String, MetadataFieldConfig> attributeValue2metadata) {
        this.attributeValue2metadata = attributeValue2metadata;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(boolean firstChild) {
        this.firstChild = firstChild;
    }

    public String getChildName() {
        return this.childName;
    }

    public void setChildName(String childName) {
        this.childName = childName;
    }
}

