/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest.dao.impl;

import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.Collection;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.HarvestedCollection_;
import org.dspace.harvest.dao.HarvestedCollectionDAO;

public class HarvestedCollectionDAOImpl
extends AbstractHibernateDAO<HarvestedCollection>
implements HarvestedCollectionDAO {
    protected HarvestedCollectionDAOImpl() {
    }

    @Override
    public HarvestedCollection findByStatusAndMinimalTypeOrderByLastHarvestedDesc(Context context, int status, int type, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<HarvestedCollection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, HarvestedCollection.class);
        Root harvestedCollectionRoot = criteriaQuery.from(HarvestedCollection.class);
        criteriaQuery.select((Selection)harvestedCollectionRoot);
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.desc((Expression)harvestedCollectionRoot.get(HarvestedCollection_.lastHarvested)));
        criteriaQuery.orderBy(orderList);
        return (HarvestedCollection)this.singleResult(context, criteriaQuery);
    }

    @Override
    public HarvestedCollection findByStatusAndMinimalTypeOrderByLastHarvestedAsc(Context context, int status, int type, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<HarvestedCollection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, HarvestedCollection.class);
        Root harvestedCollectionRoot = criteriaQuery.from(HarvestedCollection.class);
        criteriaQuery.select((Selection)harvestedCollectionRoot);
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)harvestedCollectionRoot.get(HarvestedCollection_.lastHarvested)));
        criteriaQuery.orderBy(orderList);
        return (HarvestedCollection)this.singleResult(context, criteriaQuery);
    }

    @Override
    public List<HarvestedCollection> findByStatus(Context context, int status) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<HarvestedCollection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, HarvestedCollection.class);
        Root harvestedCollectionRoot = criteriaQuery.from(HarvestedCollection.class);
        criteriaQuery.select((Selection)harvestedCollectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)harvestedCollectionRoot.get(HarvestedCollection_.harvestStatus), (Object)status));
        return this.list(context, criteriaQuery, false, HarvestedCollection.class, -1, -1);
    }

    @Override
    public HarvestedCollection findByCollection(Context context, Collection collection) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<HarvestedCollection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, HarvestedCollection.class);
        Root harvestedCollectionRoot = criteriaQuery.from(HarvestedCollection.class);
        criteriaQuery.select((Selection)harvestedCollectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)harvestedCollectionRoot.get(HarvestedCollection_.collection), (Object)collection));
        return (HarvestedCollection)this.singleResult(context, criteriaQuery);
    }

    @Override
    public List<HarvestedCollection> findByLastHarvestedAndHarvestTypeAndHarvestStatusesAndHarvestTime(Context context, Date startTime, int minimalType, int[] statuses, int expirationStatus, Date expirationTime) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<HarvestedCollection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, HarvestedCollection.class);
        Root harvestedCollectionRoot = criteriaQuery.from(HarvestedCollection.class);
        criteriaQuery.select((Selection)harvestedCollectionRoot);
        Predicate wasNotHarvestedInCurrentRun = criteriaBuilder.or((Expression)criteriaBuilder.lessThan((Expression)harvestedCollectionRoot.get(HarvestedCollection_.lastHarvested), (Comparable)startTime), (Expression)criteriaBuilder.isNull((Expression)harvestedCollectionRoot.get(HarvestedCollection_.lastHarvested)));
        LinkedList<Predicate> hasCorrectStatusOrIsExpiredRestrictions = new LinkedList<Predicate>();
        for (int status : statuses) {
            hasCorrectStatusOrIsExpiredRestrictions.add(criteriaBuilder.equal((Expression)harvestedCollectionRoot.get(HarvestedCollection_.harvestStatus), (Object)status));
        }
        Predicate harvestExpiredRestriction = criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)harvestedCollectionRoot.get(HarvestedCollection_.harvestStatus), (Object)expirationStatus), (Expression)criteriaBuilder.greaterThan((Expression)harvestedCollectionRoot.get(HarvestedCollection_.harvestStartTime), (Comparable)expirationTime));
        hasCorrectStatusOrIsExpiredRestrictions.add(harvestExpiredRestriction);
        Predicate hasCorrectStatusOrIsExpiredPredicate = criteriaBuilder.or(hasCorrectStatusOrIsExpiredRestrictions.toArray(new Predicate[0]));
        Predicate hasMinimalType = criteriaBuilder.greaterThan((Expression)harvestedCollectionRoot.get(HarvestedCollection_.harvestType), (Comparable)Integer.valueOf(minimalType));
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{wasNotHarvestedInCurrentRun, hasMinimalType, hasCorrectStatusOrIsExpiredPredicate}));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)harvestedCollectionRoot.get(HarvestedCollection_.lastHarvested)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, HarvestedCollection.class, -1, -1);
    }

    @Override
    public int count(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root harvestedCollectionRoot = criteriaQuery.from(HarvestedCollection.class);
        return this.count(context, criteriaQuery, criteriaBuilder, harvestedCollectionRoot);
    }

    protected CriteriaQuery getByStatusAndMinimalTypeCriteria(Context context, int status, int type) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<HarvestedCollection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, HarvestedCollection.class);
        Root harvestedCollectionRoot = criteriaQuery.from(HarvestedCollection.class);
        criteriaQuery.select((Selection)harvestedCollectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.greaterThan((Expression)harvestedCollectionRoot.get(HarvestedCollection_.harvestType), (Comparable)Integer.valueOf(type)), (Expression)criteriaBuilder.equal((Expression)harvestedCollectionRoot.get(HarvestedCollection_.harvestStatus), (Object)status)));
        return criteriaQuery;
    }
}

