/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.FacetYearRange;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.discovery.utils.parameter.QueryBuilderSearchFilter;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DiscoverQueryBuilder
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(DiscoverQueryBuilder.class);
    @Autowired
    private SearchService searchService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private List<IndexFactory> indexableFactories;
    private int pageSizeLimit;

    public void afterPropertiesSet() throws Exception {
        this.pageSizeLimit = this.configurationService.getIntProperty("rest.search.max.results", 100);
    }

    public DiscoverQuery buildQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String query, List<QueryBuilderSearchFilter> searchFilters, String dsoType, Integer pageSize, Long offset, String sortProperty, String sortDirection) throws SearchServiceException {
        List<String> dsoTypes = dsoType != null ? Collections.singletonList(dsoType) : Collections.emptyList();
        return this.buildQuery(context, scope, discoveryConfiguration, query, searchFilters, dsoTypes, pageSize, offset, sortProperty, sortDirection);
    }

    public DiscoverQuery buildQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String query, List<QueryBuilderSearchFilter> searchFilters, List<String> dsoTypes, Integer pageSize, Long offset, String sortProperty, String sortDirection) throws IllegalArgumentException, SearchServiceException {
        DiscoverQuery queryArgs = this.buildCommonDiscoverQuery(context, discoveryConfiguration, query, searchFilters, dsoTypes);
        this.addFaceting(context, scope, queryArgs, discoveryConfiguration);
        this.configurePagination(pageSize, offset, queryArgs);
        this.configureSorting(sortProperty, sortDirection, queryArgs, discoveryConfiguration.getSearchSortConfiguration());
        this.addDiscoveryHitHighlightFields(discoveryConfiguration, queryArgs);
        return queryArgs;
    }

    private void addDiscoveryHitHighlightFields(DiscoveryConfiguration discoveryConfiguration, DiscoverQuery queryArgs) {
        if (discoveryConfiguration.getHitHighlightingConfiguration() != null) {
            List<DiscoveryHitHighlightFieldConfiguration> metadataFields = discoveryConfiguration.getHitHighlightingConfiguration().getMetadataFields();
            for (DiscoveryHitHighlightFieldConfiguration fieldConfiguration : metadataFields) {
                queryArgs.addHitHighlightingField(new DiscoverHitHighlightingField(fieldConfiguration.getField(), fieldConfiguration.getMaxSize(), fieldConfiguration.getSnippets()));
            }
        }
    }

    public DiscoverQuery buildFacetQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String prefix, String query, List<QueryBuilderSearchFilter> searchFilters, String dsoType, Integer pageSize, Long offset, String facetName) throws IllegalArgumentException {
        List<String> dsoTypes = dsoType != null ? Collections.singletonList(dsoType) : Collections.emptyList();
        return this.buildFacetQuery(context, scope, discoveryConfiguration, prefix, query, searchFilters, dsoTypes, pageSize, offset, facetName);
    }

    public DiscoverQuery buildFacetQuery(Context context, IndexableObject scope, DiscoveryConfiguration discoveryConfiguration, String prefix, String query, List<QueryBuilderSearchFilter> searchFilters, List<String> dsoTypes, Integer pageSize, Long offset, String facetName) throws IllegalArgumentException {
        DiscoverQuery queryArgs = this.buildCommonDiscoverQuery(context, discoveryConfiguration, query, searchFilters, dsoTypes);
        this.addFacetingForFacets(context, scope, prefix, queryArgs, discoveryConfiguration, facetName, pageSize);
        queryArgs.setMaxResults(0);
        this.configurePaginationForFacets(offset, queryArgs);
        return queryArgs;
    }

    private void configurePaginationForFacets(Long offset, DiscoverQuery queryArgs) {
        if (offset != null) {
            queryArgs.setFacetOffset(Math.toIntExact(offset));
        }
    }

    private DiscoverQuery addFacetingForFacets(Context context, IndexableObject scope, String prefix, DiscoverQuery queryArgs, DiscoveryConfiguration discoveryConfiguration, String facetName, Integer pageSize) throws IllegalArgumentException {
        DiscoverySearchFilterFacet facet = discoveryConfiguration.getSidebarFacet(facetName);
        if (facet == null) {
            throw new IllegalArgumentException(facetName + " is not a valid search facet");
        }
        queryArgs.setFacetMinCount(1);
        pageSize = pageSize != null ? Math.min(this.pageSizeLimit, pageSize) : this.pageSizeLimit;
        this.fillFacetIntoQueryArgs(context, scope, prefix, queryArgs, facet, pageSize);
        return queryArgs;
    }

    private void fillFacetIntoQueryArgs(Context context, IndexableObject scope, String prefix, DiscoverQuery queryArgs, DiscoverySearchFilterFacet facet, int pageSize) {
        if (facet.getType().equals("date")) {
            try {
                FacetYearRange facetYearRange = this.searchService.getFacetYearRange(context, scope, facet, queryArgs.getFilterQueries(), queryArgs);
                queryArgs.addYearRangeFacet(facet, facetYearRange);
            }
            catch (Exception e) {
                log.error(LogHelper.getHeader(context, "Error in Discovery while setting up date facet range", "date facet: " + facet), (Throwable)e);
            }
        } else {
            int facetLimit = pageSize + 1;
            prefix = StringUtils.isNotBlank((CharSequence)prefix) ? prefix.toLowerCase() : null;
            queryArgs.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), facet.getType(), facetLimit, facet.getSortOrderSidebar(), StringUtils.trimToNull((String)prefix)));
        }
    }

    private DiscoverQuery buildCommonDiscoverQuery(Context context, DiscoveryConfiguration discoveryConfiguration, String query, List<QueryBuilderSearchFilter> searchFilters, List<String> dsoTypes) throws IllegalArgumentException {
        DiscoverQuery queryArgs = this.buildBaseQueryForConfiguration(discoveryConfiguration);
        queryArgs.addFilterQueries(this.convertFiltersToString(context, discoveryConfiguration, searchFilters));
        if (StringUtils.isNotBlank((CharSequence)query)) {
            queryArgs.setQuery(query);
        }
        if (CollectionUtils.isNotEmpty(dsoTypes)) {
            dsoTypes.stream().map(this::getDsoType).forEach(queryArgs::addDSpaceObjectFilter);
        }
        return queryArgs;
    }

    private DiscoverQuery buildBaseQueryForConfiguration(DiscoveryConfiguration discoveryConfiguration) {
        DiscoverQuery queryArgs = new DiscoverQuery();
        queryArgs.setDiscoveryConfigurationName(discoveryConfiguration.getId());
        queryArgs.addFilterQueries(discoveryConfiguration.getDefaultFilterQueries().toArray(new String[discoveryConfiguration.getDefaultFilterQueries().size()]));
        return queryArgs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureSorting(String sortProperty, String sortDirection, DiscoverQuery queryArgs, DiscoverySortConfiguration searchSortConfiguration) throws IllegalArgumentException, SearchServiceException {
        String sortBy = sortProperty;
        String sortOrder = sortDirection;
        if (sortBy == null) {
            sortBy = this.getDefaultSortField(searchSortConfiguration);
        }
        if (sortOrder == null) {
            sortOrder = this.getDefaultSortDirection(searchSortConfiguration, sortOrder);
        }
        if (StringUtils.isNotBlank((CharSequence)sortBy) && !this.isConfigured(sortBy, searchSortConfiguration)) {
            throw new SearchServiceException("The field: " + sortBy + " is not configured for the configuration!");
        }
        DiscoverySortFieldConfiguration sortFieldConfiguration = searchSortConfiguration.getSortFieldConfiguration(sortBy);
        if (sortFieldConfiguration == null) throw new IllegalArgumentException(sortBy + " is not a valid sort field");
        String sortField = this.searchService.toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
        if ("asc".equalsIgnoreCase(sortOrder)) {
            queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.asc);
            return;
        } else {
            if (!"desc".equalsIgnoreCase(sortOrder)) throw new IllegalArgumentException(sortOrder + " is not a valid sort order");
            queryArgs.setSortField(sortField, DiscoverQuery.SORT_ORDER.desc);
        }
    }

    private boolean isConfigured(String sortBy, DiscoverySortConfiguration searchSortConfiguration) {
        return Objects.nonNull(searchSortConfiguration.getSortFieldConfiguration(sortBy));
    }

    private String getDefaultSortDirection(DiscoverySortConfiguration searchSortConfiguration, String sortOrder) {
        if (searchSortConfiguration.getDefaultSortField() != null) {
            sortOrder = searchSortConfiguration.getDefaultSortField().getDefaultSortOrder().name();
        } else if (Objects.nonNull(searchSortConfiguration.getSortFields()) && !searchSortConfiguration.getSortFields().isEmpty()) {
            sortOrder = searchSortConfiguration.getSortFields().get(0).getDefaultSortOrder().name();
        }
        return sortOrder;
    }

    private String getDefaultSortField(DiscoverySortConfiguration searchSortConfiguration) {
        String sortBy = "score";
        if (searchSortConfiguration.getDefaultSortField() != null) {
            sortBy = searchSortConfiguration.getDefaultSortField().getMetadataField();
        } else if (Objects.nonNull(searchSortConfiguration.getSortFields()) && !searchSortConfiguration.getSortFields().isEmpty()) {
            DiscoverySortFieldConfiguration defaultSort = searchSortConfiguration.getSortFields().get(0);
            if (StringUtils.isBlank((CharSequence)defaultSort.getMetadataField())) {
                return sortBy;
            }
            sortBy = defaultSort.getMetadataField();
        }
        return sortBy;
    }

    private void configurePagination(Integer size, Long offset, DiscoverQuery queryArgs) {
        queryArgs.setMaxResults(size != null ? Math.min(this.pageSizeLimit, size) : this.pageSizeLimit);
        queryArgs.setStart(offset != null ? Math.toIntExact(offset) : 0);
    }

    private String getDsoType(String dsoType) throws IllegalArgumentException {
        for (IndexFactory indexFactory : this.indexableFactories) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)indexFactory.getType(), (CharSequence)dsoType)) continue;
            return indexFactory.getType();
        }
        throw new IllegalArgumentException(dsoType + " is not a valid DSpace Object type");
    }

    public void setIndexableFactories(List<IndexFactory> indexableFactories) {
        this.indexableFactories = indexableFactories;
    }

    private DiscoverQuery addFaceting(Context context, IndexableObject scope, DiscoverQuery queryArgs, DiscoveryConfiguration discoveryConfiguration) {
        List<DiscoverySearchFilterFacet> facets = discoveryConfiguration.getSidebarFacets();
        log.debug("facets for configuration " + discoveryConfiguration.getId() + ": " + (facets != null ? Integer.valueOf(facets.size()) : null));
        if (facets != null) {
            queryArgs.setFacetMinCount(1);
            for (DiscoverySearchFilterFacet facet : facets) {
                this.fillFacetIntoQueryArgs(context, scope, null, queryArgs, facet, facet.getFacetLimit());
            }
        }
        return queryArgs;
    }

    private String[] convertFiltersToString(Context context, DiscoveryConfiguration discoveryConfiguration, List<QueryBuilderSearchFilter> searchFilters) throws IllegalArgumentException {
        ArrayList<String> filterQueries = new ArrayList<String>(CollectionUtils.size(searchFilters));
        try {
            for (QueryBuilderSearchFilter searchFilter : CollectionUtils.emptyIfNull(searchFilters)) {
                DiscoverySearchFilter filter = discoveryConfiguration.getSearchFilter(searchFilter.getName());
                if (filter == null) {
                    throw new IllegalArgumentException(searchFilter.getName() + " is not a valid search filter");
                }
                DiscoverFilterQuery filterQuery = this.searchService.toFilterQuery(context, filter.getIndexFieldName(), searchFilter.getOperator(), searchFilter.getValue(), discoveryConfiguration);
                if (filterQuery == null) continue;
                filterQueries.add(filterQuery.getFilterQuery());
            }
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("There was a problem parsing the search filters.", e);
        }
        return filterQueries.toArray(new String[filterQueries.size()]);
    }
}

