/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authority.service.AuthorityValueService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.discovery.FullTextContentStreams;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightingConfiguration;
import org.dspace.discovery.configuration.DiscoveryMoreLikeThisConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.configuration.HierarchicalSidebarFacetConfiguration;
import org.dspace.discovery.indexobject.DSpaceObjectIndexFactoryImpl;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.factory.ItemIndexFactory;
import org.dspace.discovery.indexobject.factory.WorkflowItemIndexFactory;
import org.dspace.discovery.indexobject.factory.WorkspaceItemIndexFactory;
import org.dspace.eperson.EPerson;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.MultiFormatDateParser;
import org.dspace.util.SolrUtils;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class ItemIndexFactoryImpl
extends DSpaceObjectIndexFactoryImpl<IndexableItem, Item>
implements ItemIndexFactory {
    private static final Logger log = LogManager.getLogger(ItemIndexFactoryImpl.class);
    public static final String VARIANTS_STORE_SEPARATOR = "###";
    public static final String STORE_SEPARATOR = "\n|||\n";
    public static final String STATUS_FIELD = "database_status";
    public static final String STATUS_FIELD_PREDB = "predb";
    @Autowired
    protected HandleService handleService;
    @Autowired
    protected ItemService itemService;
    @Autowired(required=true)
    protected ChoiceAuthorityService choiceAuthorityService;
    @Autowired(required=true)
    protected AuthorityValueService authorityValueService;
    @Autowired
    protected MetadataAuthorityService metadataAuthorityService;
    @Autowired
    protected WorkspaceItemService workspaceItemService;
    @Autowired
    protected XmlWorkflowItemService xmlWorkflowItemService;
    @Autowired
    protected WorkflowItemIndexFactory workflowItemIndexFactory;
    @Autowired
    protected WorkspaceItemIndexFactory workspaceItemIndexFactory;
    @Autowired
    protected VersionHistoryService versionHistoryService;

    @Override
    public Iterator<IndexableItem> findAll(Context context) throws SQLException {
        final Iterator<Item> items = this.itemService.findAllRegularItems(context);
        return new Iterator<IndexableItem>(){

            @Override
            public boolean hasNext() {
                return items.hasNext();
            }

            @Override
            public IndexableItem next() {
                return new IndexableItem((Item)items.next());
            }
        };
    }

    @Override
    public String getType() {
        return IndexableItem.TYPE;
    }

    @Override
    public SolrInputDocument buildDocument(Context context, IndexableItem indexableItem) throws SQLException, IOException {
        SolrInputDocument doc = super.buildDocument(context, indexableItem);
        Item item = (Item)indexableItem.getIndexedObject();
        doc.addField("archived", (Object)item.isArchived());
        doc.addField("withdrawn", (Object)item.isWithdrawn());
        doc.addField("discoverable", (Object)item.isDiscoverable());
        doc.addField("lastModified", (Object)SolrUtils.getDateFormatter().format(item.getLastModified()));
        doc.addField("latestVersion", (Object)this.itemService.isLatestVersion(context, item));
        EPerson submitter = item.getSubmitter();
        if (submitter != null && !DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("discovery.index.item.submitter.enabled", false)) {
            doc.addField("submitter_authority", (Object)submitter.getID().toString());
        } else if (submitter != null) {
            this.addFacetIndex(doc, "submitter", submitter.getID().toString(), submitter.getFullName());
        }
        List<DiscoveryConfiguration> discoveryConfigurations = SearchUtils.getAllDiscoveryConfigurations(context, item);
        this.addDiscoveryFields(doc, context, (Item)indexableItem.getIndexedObject(), discoveryConfigurations);
        String typeText = StringUtils.deleteWhitespace((String)indexableItem.getTypeText().toLowerCase());
        String acvalue = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.facet.namedtype." + typeText, typeText + VARIANTS_STORE_SEPARATOR + typeText);
        if (StringUtils.isNotBlank((CharSequence)acvalue)) {
            this.addNamedResourceTypeIndex(doc, acvalue);
        }
        return doc;
    }

    @Override
    public SolrInputDocument buildNewDocument(Context context, IndexableItem indexableItem) throws SQLException, IOException {
        SolrInputDocument doc = this.buildDocument(context, indexableItem);
        doc.addField(STATUS_FIELD, (Object)STATUS_FIELD_PREDB);
        return doc;
    }

    @Override
    public void addDiscoveryFields(SolrInputDocument doc, Context context, Item item, List<DiscoveryConfiguration> discoveryConfigurations) throws SQLException, IOException {
        Collection collection = (Collection)this.itemService.getParentObject(context, item);
        ArrayList<CallSite> sortFieldsAdded = new ArrayList<CallSite>();
        HashMap searchFilters = new HashMap();
        HashSet<String> hitHighlightingFields = new HashSet<String>();
        try {
            HashMap<String, DiscoverySortFieldConfiguration> sortFields = new HashMap<String, DiscoverySortFieldConfiguration>();
            HashMap<String, DiscoveryRecentSubmissionsConfiguration> recentSubmissionsConfigurationMap = new HashMap<String, DiscoveryRecentSubmissionsConfiguration>();
            HashSet<String> moreLikeThisFields = new HashSet<String>();
            HashSet<String> appliedConf = new HashSet<String>();
            HashSet<String> appliedDiscoverySearchFilter = new HashSet<String>();
            for (DiscoveryConfiguration discoveryConfiguration : discoveryConfigurations) {
                DiscoveryMoreLikeThisConfiguration moreLikeThisConfiguration;
                DiscoveryHitHighlightingConfiguration hitHighlightingConfiguration;
                DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration;
                if (appliedConf.contains(discoveryConfiguration.getId())) continue;
                appliedConf.add(discoveryConfiguration.getId());
                for (int i = 0; i < discoveryConfiguration.getSearchFilters().size(); ++i) {
                    if (appliedDiscoverySearchFilter.contains(discoveryConfiguration.getSearchFilters().get(i).getIndexFieldName())) continue;
                    appliedDiscoverySearchFilter.add(discoveryConfiguration.getSearchFilters().get(i).getIndexFieldName());
                    LinkedList metadataValueList = new LinkedList();
                    boolean shouldExposeMinMax = false;
                    DiscoverySearchFilter discoverySearchFilter = discoveryConfiguration.getSearchFilters().get(i);
                    if (StringUtils.equalsIgnoreCase((CharSequence)discoverySearchFilter.getFilterType(), (CharSequence)"facet") && ((DiscoverySearchFilterFacet)discoverySearchFilter).exposeMinAndMaxValue()) {
                        shouldExposeMinMax = true;
                    }
                    for (int j = 0; j < discoverySearchFilter.getMetadataFields().size(); ++j) {
                        String metadataField = discoverySearchFilter.getMetadataFields().get(j);
                        List resultingList = searchFilters.get(metadataField) != null ? (List)searchFilters.get(metadataField) : new ArrayList();
                        if (shouldExposeMinMax) {
                            String[] splittedMetadataField = metadataField.split("\\.");
                            String schema = splittedMetadataField[0];
                            String element = splittedMetadataField.length > 1 ? splittedMetadataField[1] : null;
                            String qualifier = splittedMetadataField.length > 2 ? splittedMetadataField[2] : null;
                            metadataValueList.addAll(this.itemService.getMetadata(item, schema, element, qualifier, "*"));
                        }
                        resultingList.add(discoverySearchFilter);
                        searchFilters.put(metadataField, resultingList);
                    }
                    if (metadataValueList.isEmpty() || !shouldExposeMinMax) continue;
                    metadataValueList.sort((mdv1, mdv2) -> mdv1.getValue().compareTo(mdv2.getValue()));
                    MetadataValue firstMetadataValue = (MetadataValue)metadataValueList.get(0);
                    MetadataValue lastMetadataValue = (MetadataValue)metadataValueList.get(metadataValueList.size() - 1);
                    doc.addField(discoverySearchFilter.getIndexFieldName() + "_min", (Object)firstMetadataValue.getValue());
                    doc.addField(discoverySearchFilter.getIndexFieldName() + "_min_sort", (Object)firstMetadataValue.getValue());
                    doc.addField(discoverySearchFilter.getIndexFieldName() + "_max", (Object)lastMetadataValue.getValue());
                    doc.addField(discoverySearchFilter.getIndexFieldName() + "_max_sort", (Object)lastMetadataValue.getValue());
                }
                DiscoverySortConfiguration sortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
                if (sortConfiguration != null) {
                    for (DiscoverySortFieldConfiguration discoverySortConfiguration : sortConfiguration.getSortFields()) {
                        sortFields.put(discoverySortConfiguration.getMetadataField(), discoverySortConfiguration);
                    }
                }
                if ((recentSubmissionConfiguration = discoveryConfiguration.getRecentSubmissionConfiguration()) != null) {
                    recentSubmissionsConfigurationMap.put(recentSubmissionConfiguration.getMetadataSortField(), recentSubmissionConfiguration);
                }
                if ((hitHighlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration()) != null) {
                    List<DiscoveryHitHighlightFieldConfiguration> fieldConfigurations = hitHighlightingConfiguration.getMetadataFields();
                    for (DiscoveryHitHighlightFieldConfiguration fieldConfiguration : fieldConfigurations) {
                        hitHighlightingFields.add(fieldConfiguration.getField());
                    }
                }
                if ((moreLikeThisConfiguration = discoveryConfiguration.getMoreLikeThisConfiguration()) == null) continue;
                for (String metadataField : moreLikeThisConfiguration.getSimilarityMetadataFields()) {
                    moreLikeThisFields.add(metadataField);
                }
            }
            ArrayList<String> toProjectionFields = new ArrayList<String>();
            String[] projectionFields = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("discovery.index.projection");
            if (projectionFields != null) {
                for (String field : projectionFields) {
                    toProjectionFields.add(field.trim());
                }
            }
            List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(item.getType());
            List<MetadataValue> mydc = this.itemService.getMetadata(item, "*", "*", "*", "*");
            for (MetadataValue meta : mydc) {
                boolean ignoreAuthority;
                int minConfidence;
                String field;
                MetadataField metadataField = meta.getMetadataField();
                MetadataSchema metadataSchema = metadataField.getMetadataSchema();
                String unqualifiedField = field = metadataSchema.getName() + "." + metadataField.getElement();
                String value = meta.getValue();
                if (value == null) continue;
                if (metadataField.getQualifier() != null && !metadataField.getQualifier().trim().equals("")) {
                    field = field + "." + metadataField.getQualifier();
                }
                if (toIgnoreMetadataFields != null && (toIgnoreMetadataFields.contains(field) || toIgnoreMetadataFields.contains(unqualifiedField + ".*"))) continue;
                String authority = null;
                String preferedLabel = null;
                List<String> variants = null;
                boolean isAuthorityControlled = this.metadataAuthorityService.isAuthorityControlled(metadataField);
                int n = minConfidence = isAuthorityControlled ? this.metadataAuthorityService.getMinConfidence(metadataField) : 600;
                if (isAuthorityControlled && meta.getAuthority() != null && meta.getConfidence() >= minConfidence && !(ignoreAuthority = ((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore." + field, (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore", (Object)Boolean.FALSE)), true)).booleanValue())) {
                    boolean ignoreVariants;
                    authority = meta.getAuthority();
                    boolean ignorePrefered = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-prefered." + field, (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-prefered", (Object)Boolean.FALSE)), true);
                    if (!ignorePrefered && !authority.startsWith("will be generated::")) {
                        try {
                            preferedLabel = this.choiceAuthorityService.getLabel(meta, collection, meta.getLanguage());
                        }
                        catch (Exception e) {
                            log.warn("Failed to get preferred label for " + field, (Throwable)e);
                        }
                    }
                    if (!(ignoreVariants = ((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-variants." + field, (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-variants", (Object)Boolean.FALSE)), true)).booleanValue())) {
                        try {
                            variants = this.choiceAuthorityService.getVariants(meta, collection);
                        }
                        catch (Exception e) {
                            log.warn("Failed to get variants for " + field, (Throwable)e);
                        }
                    }
                }
                if (searchFilters.get(field) != null || searchFilters.get(unqualifiedField + ".*") != null) {
                    List searchFilterConfigs = (List)searchFilters.get(field);
                    if (searchFilterConfigs == null) {
                        searchFilterConfigs = (List)searchFilters.get(unqualifiedField + ".*");
                    }
                    for (DiscoverySearchFilter searchFilter : searchFilterConfigs) {
                        Date date = null;
                        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
                        if (separator == null) {
                            separator = STORE_SEPARATOR;
                        }
                        if (searchFilter.getType().equals("date") && (date = MultiFormatDateParser.parse(value)) != null) {
                            value = DateFormatUtils.formatUTC((Date)date, (String)"yyyy-MM-dd");
                        }
                        doc.addField(searchFilter.getIndexFieldName(), (Object)value);
                        doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)value);
                        if (authority != null && preferedLabel == null) {
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)(value + VARIANTS_STORE_SEPARATOR + authority));
                            doc.addField(searchFilter.getIndexFieldName() + "_authority", (Object)authority);
                            doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(value.toLowerCase() + separator + value + VARIANTS_STORE_SEPARATOR + authority));
                        }
                        if (preferedLabel != null) {
                            doc.addField(searchFilter.getIndexFieldName(), preferedLabel);
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)preferedLabel);
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)(preferedLabel + VARIANTS_STORE_SEPARATOR + authority));
                            doc.addField(searchFilter.getIndexFieldName() + "_authority", (Object)authority);
                            doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(preferedLabel.toLowerCase() + separator + preferedLabel + VARIANTS_STORE_SEPARATOR + authority));
                        }
                        if (variants != null) {
                            for (String var : variants) {
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)var);
                                doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(var.toLowerCase() + separator + var + VARIANTS_STORE_SEPARATOR + authority));
                            }
                        }
                        doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(value.toLowerCase() + separator + value));
                        if (preferedLabel != null) {
                            doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(preferedLabel.toLowerCase() + separator + preferedLabel));
                        }
                        if (variants != null) {
                            for (String var : variants) {
                                doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(var.toLowerCase() + separator + var));
                            }
                        }
                        if (!searchFilter.getFilterType().equals("facet")) continue;
                        this.indexIfFilterTypeFacet(doc, searchFilter, value, date, authority, preferedLabel, separator);
                    }
                }
                if (!(sortFields.get(field) == null && recentSubmissionsConfigurationMap.get(field) == null || sortFieldsAdded.contains(field))) {
                    String type = sortFields.get(field) != null ? ((DiscoverySortFieldConfiguration)sortFields.get(field)).getType() : ((DiscoveryRecentSubmissionsConfiguration)recentSubmissionsConfigurationMap.get(field)).getType();
                    if (type.equals("date")) {
                        Date date = MultiFormatDateParser.parse(value);
                        if (date != null) {
                            String stringDate = SolrUtils.getDateFormatter().format(date);
                            doc.addField(field + "_dt", (Object)stringDate);
                        } else {
                            log.warn("Error while indexing sort date field, item: " + item.getHandle() + " metadata field: " + field + " date value: " + date);
                        }
                    } else {
                        doc.addField(field + "_sort", (Object)value);
                    }
                    sortFieldsAdded.add((CallSite)((Object)field));
                }
                if (hitHighlightingFields.contains(field) || hitHighlightingFields.contains("*") || hitHighlightingFields.contains(unqualifiedField + ".*")) {
                    if (authority != null) {
                        doc.addField(field + "_hl", (Object)(value + VARIANTS_STORE_SEPARATOR + authority));
                    } else {
                        doc.addField(field + "_hl", (Object)value);
                    }
                }
                if (moreLikeThisFields.contains(field) || moreLikeThisFields.contains(unqualifiedField + ".*")) {
                    doc.addField(field + "_mlt", (Object)value);
                }
                doc.addField(field, (Object)value);
                if (authority != null) {
                    doc.addField(field + "_authority", (Object)authority);
                }
                if (toProjectionFields.contains(field) || toProjectionFields.contains(unqualifiedField + ".*")) {
                    StringBuffer variantsToStore = new StringBuffer();
                    if (variants != null) {
                        for (String var : variants) {
                            variantsToStore.append(VARIANTS_STORE_SEPARATOR);
                            variantsToStore.append(var);
                        }
                    }
                    doc.addField(field + "_stored", (Object)(value + STORE_SEPARATOR + preferedLabel + STORE_SEPARATOR + (variantsToStore.length() > VARIANTS_STORE_SEPARATOR.length() ? variantsToStore.substring(VARIANTS_STORE_SEPARATOR.length()) : "null") + STORE_SEPARATOR + authority + STORE_SEPARATOR + meta.getLanguage()));
                }
                if (meta.getLanguage() == null || meta.getLanguage().trim().equals("")) continue;
                String langField = field + "." + meta.getLanguage();
                doc.addField(langField, (Object)value);
            }
        }
        catch (Exception e) {
            log.error(LogHelper.getHeader(context, "item_metadata_discovery_error", "Item identifier: " + item.getID()), (Throwable)e);
        }
        log.debug("  Added Metadata");
        try {
            List<MetadataValue> values = this.itemService.getMetadataByMetadataString(item, "dc.relation.ispartof");
            if (values != null && values.size() > 0 && values.get(0) != null && values.get(0).getValue() != null) {
                String handlePrefix = this.handleService.getCanonicalPrefix();
                doc.addField("publication_grp", (Object)values.get(0).getValue().replaceFirst(handlePrefix, ""));
            } else {
                doc.addField("publication_grp", (Object)item.getHandle());
            }
        }
        catch (Exception e) {
            log.error(LogHelper.getHeader(context, "item_publication_group_discovery_error", "Item identifier: " + item.getID()), (Throwable)e);
        }
        log.debug("  Added Grouping");
    }

    @Override
    public void writeDocument(Context context, IndexableItem indexableObject, SolrInputDocument solrInputDocument) throws SQLException, IOException, SolrServerException {
        this.writeDocument(solrInputDocument, new FullTextContentStreams(context, (Item)indexableObject.getIndexedObject()));
    }

    @Override
    public List<String> getLocations(Context context, IndexableItem indexableDSpaceObject) throws SQLException {
        Item item = (Item)indexableDSpaceObject.getIndexedObject();
        ArrayList<String> locations = new ArrayList<String>();
        List<Community> communities = this.itemService.getCommunities(context, item);
        List<Collection> collections = item.getCollections();
        int i = 0;
        for (i = 0; i < communities.size(); ++i) {
            locations.add("m" + communities.get(i).getID());
        }
        for (i = 0; i < collections.size(); ++i) {
            locations.add("l" + collections.get(i).getID());
        }
        return locations;
    }

    @Override
    public void delete(IndexableItem indexableObject) throws IOException, SolrServerException {
        super.delete(indexableObject);
        this.deleteInProgressData(indexableObject.getUniqueIndexID());
    }

    private void deleteInProgressData(String indexableObjectIdentifier) throws SolrServerException, IOException {
        String query = "inprogress.item:\"" + indexableObjectIdentifier + "\"";
        log.debug("Try to delete all in progress submission [DELETEBYQUERY]:" + query);
        this.solrSearchCore.getSolr().deleteByQuery(query);
    }

    @Override
    public void delete(String indexableObjectIdentifier) throws IOException, SolrServerException {
        super.delete(indexableObjectIdentifier);
        this.deleteInProgressData(indexableObjectIdentifier);
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof Item;
    }

    @Override
    public List getIndexableObjects(Context context, Item item) throws SQLException {
        if (item.isArchived() || item.isWithdrawn()) {
            return List.of(new IndexableItem(item));
        }
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(context, item);
        if (workspaceItem != null) {
            return List.copyOf(this.workspaceItemIndexFactory.getIndexableObjects(context, workspaceItem));
        }
        XmlWorkflowItem xmlWorkflowItem = (XmlWorkflowItem)this.xmlWorkflowItemService.findByItem(context, item);
        if (xmlWorkflowItem != null) {
            return List.copyOf(this.workflowItemIndexFactory.getIndexableObjects(context, xmlWorkflowItem));
        }
        if (!this.itemService.isLatestVersion(context, item)) {
            return List.of(new IndexableItem(item));
        }
        return List.of();
    }

    @Override
    public Optional<IndexableItem> findIndexableObject(Context context, String id) throws SQLException {
        Item item = (Item)this.itemService.find(context, UUID.fromString(id));
        return item == null ? Optional.empty() : Optional.of(new IndexableItem(item));
    }

    private void indexIfFilterTypeFacet(SolrInputDocument doc, DiscoverySearchFilter searchFilter, String value, Date date, String authority, String preferedLabel, String separator) {
        if (searchFilter.getType().equals("text")) {
            if (authority != null) {
                String facetValue = preferedLabel != null ? preferedLabel : value;
                doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(facetValue.toLowerCase() + separator + facetValue + VARIANTS_STORE_SEPARATOR + authority));
            } else {
                doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(value.toLowerCase() + separator + value));
            }
            this.saveFacetPrefixParts(doc, searchFilter, value, separator, authority, preferedLabel);
        } else if (searchFilter.getType().equals("date")) {
            if (date != null) {
                String indexField = searchFilter.getIndexFieldName() + ".year";
                String yearUTC = DateFormatUtils.formatUTC((Date)date, (String)"yyyy");
                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)yearUTC);
                doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)yearUTC);
                doc.addField(indexField, (Object)yearUTC);
                if (yearUTC.startsWith("0")) {
                    doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)yearUTC.replaceFirst("0*", ""));
                    doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)yearUTC.replaceFirst("0*", ""));
                    doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)value.replaceFirst("0*", ""));
                    doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)value.replaceFirst("0*", ""));
                }
                if (doc.getField(indexField + "_sort") == null) {
                    doc.addField(indexField + "_sort", (Object)yearUTC);
                }
            }
        } else if (searchFilter.getType().equals("hierarchical")) {
            HierarchicalSidebarFacetConfiguration hierarchicalSidebarFacetConfiguration = (HierarchicalSidebarFacetConfiguration)searchFilter;
            Object[] subValues = value.split(hierarchicalSidebarFacetConfiguration.getSplitter());
            if (hierarchicalSidebarFacetConfiguration.isSkipFirstNodeLevel() && 1 < subValues.length) {
                subValues = (String[])ArrayUtils.subarray((Object[])subValues, (int)1, (int)subValues.length);
            }
            for (int i = 0; i < subValues.length; ++i) {
                StringBuilder valueBuilder = new StringBuilder();
                for (int j = 0; j <= i; ++j) {
                    valueBuilder.append((String)subValues[j]);
                    if (j >= i) continue;
                    valueBuilder.append(hierarchicalSidebarFacetConfiguration.getSplitter());
                }
                String indexValue = valueBuilder.toString().trim();
                doc.addField(searchFilter.getIndexFieldName() + "_tax_" + i + "_filter", (Object)(indexValue.toLowerCase() + separator + indexValue));
                for (int j = i; j < subValues.length; ++j) {
                    doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(indexValue.toLowerCase() + separator + indexValue));
                    doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)indexValue);
                }
            }
            this.saveFacetPrefixParts(doc, searchFilter, value, separator, authority, preferedLabel);
        }
    }

    private void saveFacetPrefixParts(SolrInputDocument doc, DiscoverySearchFilter searchFilter, String value, String separator, String authority, String preferedLabel) {
        value = StringUtils.normalizeSpace((String)value);
        Pattern pattern = Pattern.compile("\\b\\w+\\b", 258);
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            int index = matcher.start();
            String currentPart = StringUtils.substring((String)value, (int)index);
            if (authority != null) {
                String facetValue = preferedLabel != null ? preferedLabel : currentPart;
                doc.addField(searchFilter.getIndexFieldName() + "_prefix", (Object)(facetValue.toLowerCase() + separator + value + VARIANTS_STORE_SEPARATOR + authority));
                continue;
            }
            doc.addField(searchFilter.getIndexFieldName() + "_prefix", (Object)(currentPart.toLowerCase() + separator + value));
        }
    }
}

