/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.discovery.indexobject.factory.IndexObjectFactoryFactory;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.services.factory.DSpaceServicesFactory;

public class IndexEventConsumer
implements Consumer {
    private static Logger log = LogManager.getLogger(IndexEventConsumer.class);
    private Set<IndexableObject> objectsToUpdate = new HashSet<IndexableObject>();
    private Set<IndexableObject> createdItemsToUpdate = new HashSet<IndexableObject>();
    private Set<String> uniqueIdsToDelete = new HashSet<String>();
    IndexingService indexer = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
    IndexObjectFactoryFactory indexObjectServiceFactory = IndexObjectFactoryFactory.getInstance();

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        int st;
        if (this.objectsToUpdate == null) {
            this.objectsToUpdate = new HashSet<IndexableObject>();
            this.uniqueIdsToDelete = new HashSet<String>();
            this.createdItemsToUpdate = new HashSet<IndexableObject>();
        }
        if ((st = event.getSubjectType()) != 2 && st != 1 && st != 3 && st != 4 && st != 5) {
            log.warn("IndexConsumer should not have been given this kind of Subject in an event, skipping: " + event.toString());
            return;
        }
        DSpaceObject subject = event.getSubject(ctx);
        DSpaceObject object = event.getObject(ctx);
        int et = event.getEventType();
        if (st == 1) {
            if ((et == 8 || et == 16) && subject != null && ((Bundle)subject).getName().equals("TEXT")) {
                st = 2;
                et = 2;
                subject = ((Bundle)subject).getItems().get(0);
                if (log.isDebugEnabled()) {
                    log.debug("Transforming Bundle event into MODIFY of Item " + subject.getHandle());
                }
            } else {
                return;
            }
        }
        switch (et) {
            case 1: 
            case 2: 
            case 4: {
                if (subject == null) {
                    if (st == 5) {
                        for (String id : event.getIdentifiers()) {
                            IndexFactory indexableObjectService = IndexObjectFactoryFactory.getInstance().getIndexFactoryByType(event.getDetail());
                            Optional indexableObject = Optional.empty();
                            indexableObject = indexableObjectService.findIndexableObject(ctx, id);
                            if (indexableObject.isPresent()) {
                                log.debug("consume() adding event to update queue: " + event.toString());
                                this.objectsToUpdate.addAll(this.indexObjectServiceFactory.getIndexableObjects(ctx, ((IndexableObject)indexableObject.get()).getIndexedObject()));
                                continue;
                            }
                            log.warn("Cannot resolve " + id);
                        }
                        break;
                    }
                    log.warn(event.getEventTypeAsString() + " event, could not get object for " + event.getSubjectTypeAsString() + " id=" + event.getSubjectID() + ", perhaps it has been deleted.");
                    break;
                }
                log.debug("consume() adding event to update queue: " + event.toString());
                if (event.getSubjectType() == 2) {
                    IndexFactory indexableObjectService = IndexObjectFactoryFactory.getInstance().getIndexFactoryByType(Constants.typeText[event.getSubjectType()]);
                    String detail = indexableObjectService.getType() + "-" + event.getSubjectID().toString();
                    this.uniqueIdsToDelete.add(detail);
                }
                this.objectsToUpdate.addAll(this.indexObjectServiceFactory.getIndexableObjects(ctx, subject));
                break;
            }
            case 8: 
            case 16: {
                if (event.getSubjectType() == 5) {
                    log.debug(event.getEventTypeAsString() + " event triggered for Site object. Skipping it.");
                    break;
                }
                if (object == null) {
                    log.warn(event.getEventTypeAsString() + " event, could not get object for " + event.getObjectTypeAsString() + " id=" + event.getObjectID() + ", perhaps it has been deleted.");
                    break;
                }
                log.debug("consume() adding event to update queue: " + event.toString());
                this.objectsToUpdate.addAll(this.indexObjectServiceFactory.getIndexableObjects(ctx, subject));
                if (subject == null || subject.getType() != 3 || object.getType() != 2) break;
                this.createdItemsToUpdate.addAll(this.indexObjectServiceFactory.getIndexableObjects(ctx, object));
                break;
            }
            case 32: {
                if (event.getSubjectType() == -1 || event.getSubjectID() == null) {
                    log.warn("got null subject type and/or ID on DELETE event, skipping it.");
                    break;
                }
                IndexFactory indexableObjectService = IndexObjectFactoryFactory.getInstance().getIndexFactoryByType(Constants.typeText[event.getSubjectType()]);
                String detail = indexableObjectService.getType() + "-" + event.getSubjectID().toString();
                log.debug("consume() adding event to delete queue: " + event.toString());
                this.uniqueIdsToDelete.add(detail);
                break;
            }
            default: {
                log.warn("IndexConsumer should not have been given a event of type=" + event.getEventTypeAsString() + " on subject=" + event.getSubjectTypeAsString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Context ctx) throws Exception {
        Context.Mode originalMode = ctx.getCurrentMode();
        ctx.setMode(Context.Mode.READ_ONLY);
        try {
            for (String uid : this.uniqueIdsToDelete) {
                try {
                    this.indexer.unIndexContent(ctx, uid, false);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("UN-Indexed Item, handle=" + uid);
                }
                catch (Exception e) {
                    log.error("Failed while UN-indexing object: " + uid, (Throwable)e);
                }
            }
            for (IndexableObject iu : this.objectsToUpdate) {
                this.indexObject(ctx, iu, false);
            }
            for (IndexableObject iu : this.createdItemsToUpdate) {
                this.indexObject(ctx, iu, true);
            }
        }
        finally {
            if (!this.objectsToUpdate.isEmpty() || !this.uniqueIdsToDelete.isEmpty()) {
                this.indexer.commit();
                this.objectsToUpdate.clear();
                this.uniqueIdsToDelete.clear();
                this.createdItemsToUpdate.clear();
            }
            ctx.setMode(originalMode);
        }
    }

    private void indexObject(Context ctx, IndexableObject iu, boolean preDb) throws SQLException {
        iu.setIndexedObject(ctx.reloadEntity(iu.getIndexedObject()));
        String uniqueIndexID = iu.getUniqueIndexID();
        if (uniqueIndexID != null) {
            try {
                this.indexer.indexContent(ctx, iu, true, false, preDb);
                log.debug("Indexed " + iu.getTypeText() + ", id=" + iu.getID() + ", unique_id=" + uniqueIndexID);
            }
            catch (Exception e) {
                log.error("Failed while indexing object: ", (Throwable)e);
            }
        }
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

