/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.logic.condition;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.logic.LogicalStatementException;
import org.dspace.content.logic.condition.AbstractCondition;
import org.dspace.core.Context;

public class InCommunityCondition
extends AbstractCondition {
    private static final Logger log = LogManager.getLogger();

    @Override
    public boolean getResult(Context context, Item item) throws LogicalStatementException {
        block10: {
            List<Community> communities;
            List communityHandles = (List)this.getParameters().get("communities");
            List<Collection> itemCollections = item.getCollections();
            for (Collection collection : itemCollections) {
                try {
                    communities = collection.getCommunities();
                    for (Community community : communities) {
                        if (!communityHandles.contains(community.getHandle())) continue;
                        return true;
                    }
                }
                catch (SQLException e) {
                    log.error(e.getMessage());
                    throw new LogicalStatementException(e);
                }
            }
            try {
                DSpaceObject parent = this.itemService.getParentObject(context, item);
                if (parent instanceof Collection) {
                    log.debug("Got parent DSO for item: " + parent.getID().toString());
                    log.debug("Parent DSO handle: " + parent.getHandle());
                    try {
                        Collection collection;
                        collection = (Collection)parent;
                        communities = collection.getCommunities();
                        for (Community community : communities) {
                            if (!communityHandles.contains(community.getHandle())) continue;
                            return true;
                        }
                        break block10;
                    }
                    catch (SQLException e) {
                        log.error(e.getMessage());
                        throw new LogicalStatementException(e);
                    }
                }
                log.debug("Parent DSO is null or is not a Collection...");
            }
            catch (SQLException e) {
                log.error("Error obtaining parent DSO", (Throwable)e);
                throw new LogicalStatementException(e);
            }
        }
        return false;
    }
}

