/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.license.FormattableArgument;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class LicenseUtils {
    private static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private static final BitstreamFormatService bitstreamFormat = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    private LicenseUtils() {
    }

    public static String getLicenseText(Locale locale, Collection collection, Item item, EPerson eperson, Map<String, Object> additionalInfo) {
        Formatter formatter = new Formatter(locale);
        int numArgs = 7 + (additionalInfo != null ? additionalInfo.size() : 0);
        Object[] args = new Object[numArgs];
        args[0] = eperson.getFirstName();
        args[1] = eperson.getLastName();
        args[2] = eperson.getEmail();
        args[3] = new Date();
        args[4] = new FormattableArgument("collection", collection);
        args[5] = new FormattableArgument("item", item);
        args[6] = new FormattableArgument("eperson", eperson);
        if (additionalInfo != null) {
            int i = 7;
            for (Map.Entry<String, Object> info : additionalInfo.entrySet()) {
                args[i] = new FormattableArgument(info.getKey(), info.getValue());
                ++i;
            }
        }
        String licenseTemplate = collectionService.getLicense(collection);
        return formatter.format(licenseTemplate, args).toString();
    }

    public static String getLicenseText(Locale locale, Collection collection, Item item, EPerson eperson) {
        return LicenseUtils.getLicenseText(locale, collection, item, eperson, null);
    }

    public static void grantLicense(Context context, Item item, String licenseText, String acceptanceDate) throws SQLException, IOException, AuthorizeException {
        byte[] licenseBytes = licenseText.getBytes("UTF-8");
        ByteArrayInputStream bais = new ByteArrayInputStream(licenseBytes);
        Bitstream b = itemService.createSingleBitstream(context, bais, item, "LICENSE");
        b.setName(context, "license.txt");
        b.setSource(context, "Written by org.dspace.content.LicenseUtils");
        DCDate acceptanceDCDate = DCDate.getCurrent();
        if (acceptanceDate != null) {
            acceptanceDCDate = new DCDate(acceptanceDate);
        }
        b.setAcceptanceDate(context, acceptanceDCDate);
        BitstreamFormat bf = bitstreamFormat.findByShortDescription(context, "License");
        b.setFormat(bf);
        bitstreamService.update(context, b);
    }
}

