/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.spring.annotation;

import com.google.common.collect.Lists;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.common.timer.HashedWheelTimer;
import org.dromara.dynamictp.core.executor.NamedThreadFactory;
import org.dromara.dynamictp.spring.DtpPostProcessor;
import org.dromara.dynamictp.spring.holder.SpringContextHolder;
import org.dromara.dynamictp.spring.util.BeanRegistrationUtil;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public class DtpBaseBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String APPLICATION_CONTEXT_HOLDER = "dtpApplicationContextHolder";
    private static final String HASHED_WHEEL_TIMER = "dtpHashedWheelTimer";
    private static final String DTP_POST_PROCESSOR = "dtpPostProcessor";

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerHashedWheelTimer(registry);
        BeanRegistrationUtil.registerIfAbsent(registry, APPLICATION_CONTEXT_HOLDER, SpringContextHolder.class, new Object[0]);
        BeanRegistrationUtil.registerIfAbsent(registry, DTP_POST_PROCESSOR, DtpPostProcessor.class, null, Lists.newArrayList((Object[])new String[]{APPLICATION_CONTEXT_HOLDER, HASHED_WHEEL_TIMER}), new Object[0]);
    }

    private void registerHashedWheelTimer(BeanDefinitionRegistry registry) {
        Object[] constructorArgs = new Object[]{new NamedThreadFactory("dtp-runnable-timeout", true), 10, TimeUnit.MILLISECONDS};
        BeanRegistrationUtil.registerIfAbsent(registry, HASHED_WHEEL_TIMER, HashedWheelTimer.class, constructorArgs);
    }
}

