/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.spring;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.plugin.DtpInterceptorRegistry;
import org.dromara.dynamictp.common.util.ConstructorUtil;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.executor.eager.EagerDtpExecutor;
import org.dromara.dynamictp.core.executor.eager.TaskQueue;
import org.dromara.dynamictp.core.support.DtpLifecycleSupport;
import org.dromara.dynamictp.core.support.DynamicTp;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.proxy.ScheduledThreadPoolExecutorProxy;
import org.dromara.dynamictp.core.support.proxy.ThreadPoolExecutorProxy;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DtpPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
PriorityOrdered {
    private static final Logger log = LoggerFactory.getLogger(DtpPostProcessor.class);
    private static final String REGISTER_SOURCE = "beanPostProcessor";
    private DefaultListableBeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (!(bean instanceof ThreadPoolExecutor) && !(bean instanceof ThreadPoolTaskExecutor)) {
            return bean;
        }
        if (bean instanceof DtpExecutor) {
            return this.registerAndReturnDtp(bean);
        }
        return this.registerAndReturnCommon(bean, beanName);
    }

    private Object registerAndReturnDtp(Object bean) {
        DtpExecutor dtpExecutor = (DtpExecutor)bean;
        Object[] args = ConstructorUtil.buildTpExecutorConstructorArgs((ThreadPoolExecutor)dtpExecutor);
        Class[] argTypes = ConstructorUtil.buildTpExecutorConstructorArgTypes();
        Set pluginNames = dtpExecutor.getPluginNames();
        DtpExecutor enhancedBean = (DtpExecutor)DtpInterceptorRegistry.plugin((Object)bean, (Set)pluginNames, (Class[])argTypes, (Object[])args);
        if (enhancedBean instanceof EagerDtpExecutor) {
            ((TaskQueue)enhancedBean.getQueue()).setExecutor((EagerDtpExecutor)enhancedBean);
        }
        DtpRegistry.registerExecutor((ExecutorWrapper)ExecutorWrapper.of((DtpExecutor)enhancedBean), (String)REGISTER_SOURCE);
        return enhancedBean;
    }

    private Object registerAndReturnCommon(Object bean, String beanName) {
        String dtpAnnoValue;
        try {
            DynamicTp dynamicTp = (DynamicTp)this.beanFactory.findAnnotationOnBean(beanName, DynamicTp.class);
            if (Objects.nonNull(dynamicTp)) {
                dtpAnnoValue = dynamicTp.value();
            } else {
                BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
                if (!(beanDefinition instanceof AnnotatedBeanDefinition)) {
                    return bean;
                }
                AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
                MethodMetadata methodMetadata = (MethodMetadata)annotatedBeanDefinition.getSource();
                if (Objects.isNull(methodMetadata) || !methodMetadata.isAnnotated(DynamicTp.class.getName())) {
                    return bean;
                }
                dtpAnnoValue = Optional.ofNullable(methodMetadata.getAnnotationAttributes(DynamicTp.class.getName())).orElse(Collections.emptyMap()).getOrDefault("value", "").toString();
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.warn("There is no bean with the given name {}", (Object)beanName, (Object)e);
            return bean;
        }
        String poolName = StringUtils.isNotBlank((CharSequence)dtpAnnoValue) ? dtpAnnoValue : beanName;
        return this.doRegisterAndReturnCommon(bean, poolName);
    }

    private Object doRegisterAndReturnCommon(Object bean, String poolName) {
        if (bean instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor poolTaskExecutor = (ThreadPoolTaskExecutor)bean;
            ThreadPoolExecutorProxy proxy = this.newProxy(poolName, poolTaskExecutor.getThreadPoolExecutor());
            try {
                ReflectionUtil.setFieldValue((String)"threadPoolExecutor", (Object)bean, (Object)proxy);
                this.tryWrapTaskDecorator(poolName, poolTaskExecutor, proxy);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            DtpRegistry.registerExecutor((ExecutorWrapper)new ExecutorWrapper(poolName, (Executor)proxy), (String)REGISTER_SOURCE);
            return bean;
        }
        Object proxy = bean instanceof ScheduledThreadPoolExecutor ? this.newScheduledTpProxy(poolName, (ScheduledThreadPoolExecutor)bean) : this.newProxy(poolName, (ThreadPoolExecutor)bean);
        DtpRegistry.registerExecutor((ExecutorWrapper)new ExecutorWrapper(poolName, (Executor)proxy), (String)REGISTER_SOURCE);
        return proxy;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private ThreadPoolExecutorProxy newProxy(String name, ThreadPoolExecutor originExecutor) {
        ThreadPoolExecutorProxy proxy = new ThreadPoolExecutorProxy(originExecutor);
        DtpLifecycleSupport.shutdownGracefulAsync((ExecutorService)originExecutor, (String)name, (int)0);
        return proxy;
    }

    private ScheduledThreadPoolExecutorProxy newScheduledTpProxy(String name, ScheduledThreadPoolExecutor originExecutor) {
        ScheduledThreadPoolExecutorProxy proxy = new ScheduledThreadPoolExecutorProxy(originExecutor);
        DtpLifecycleSupport.shutdownGracefulAsync((ExecutorService)originExecutor, (String)name, (int)0);
        return proxy;
    }

    private void tryWrapTaskDecorator(final String poolName, ThreadPoolTaskExecutor poolTaskExecutor, ThreadPoolExecutorProxy proxy) throws IllegalAccessException {
        final Object taskDecorator = ReflectionUtil.getFieldValue((String)"taskDecorator", (Object)poolTaskExecutor);
        if (Objects.isNull(taskDecorator)) {
            return;
        }
        TaskWrapper taskWrapper = taskDecorator instanceof TaskWrapper ? (TaskWrapper)taskDecorator : new TaskWrapper(){

            public String name() {
                return poolName + "#taskDecorator";
            }

            public Runnable wrap(Runnable runnable) {
                return ((TaskDecorator)taskDecorator).decorate(runnable);
            }
        };
        ReflectionUtil.setFieldValue((String)"taskWrappers", (Object)proxy, (Object)Lists.newArrayList((Object[])new TaskWrapper[]{taskWrapper}));
        TaskWrappers.getInstance();
        TaskWrappers.register((TaskWrapper)taskWrapper);
    }
}

