/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver;

import java.util.concurrent.Executor;
import org.dromara.dynamictp.adapter.common.AbstractDtpAdapter;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.core.converter.ExecutorConverter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.spring.holder.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public abstract class AbstractWebServerDtpAdapter<A extends Executor>
extends AbstractDtpAdapter
implements ApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebServerDtpAdapter.class);

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof WebServerInitializedEvent) {
            try {
                DtpProperties dtpProperties = (DtpProperties)ContextManagerHelper.getBean(DtpProperties.class);
                this.initialize();
                this.afterInitialize();
                this.refresh(dtpProperties);
            }
            catch (Exception e) {
                log.error("Init web server thread pool failed.", (Throwable)e);
            }
        }
    }

    protected void initialize() {
        super.initialize();
        if (this.executors.get(this.getTpName()) == null) {
            ApplicationContext applicationContext = SpringContextHolder.getInstance();
            WebServer webServer = ((WebServerApplicationContext)applicationContext).getWebServer();
            this.doEnhance(webServer);
            log.info("DynamicTp adapter, web server {} executor init end, executor: {}", (Object)this.getTpName(), (Object)ExecutorConverter.toMainFields((ExecutorWrapper)((ExecutorWrapper)this.executors.get(this.getTpName()))));
        }
    }

    protected String getTpName() {
        return this.getTpPrefix();
    }

    protected abstract void doEnhance(WebServer var1);
}

