/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.notifier;

import cn.hutool.core.net.url.UrlBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.em.NotifyPlatformEnum;
import org.dromara.dynamictp.common.entity.MarkdownReq;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.notifier.AbstractHttpNotifier;
import org.dromara.dynamictp.common.util.DingSignUtil;
import org.dromara.dynamictp.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingNotifier
extends AbstractHttpNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingNotifier.class);
    private static final String ALL = "all";

    @Override
    public String platform() {
        return NotifyPlatformEnum.DING.name().toLowerCase();
    }

    @Override
    protected String buildMsgBody(NotifyPlatform platform, String content) {
        MarkdownReq.Markdown markdown = new MarkdownReq.Markdown();
        markdown.setTitle("\u52a8\u6001\u7ebf\u7a0b\u6c60\u901a\u77e5");
        markdown.setText(content);
        MarkdownReq.At at = new MarkdownReq.At();
        ArrayList mobiles = Lists.newArrayList((Object[])platform.getReceivers().split(","));
        at.setAtMobiles(mobiles);
        if (mobiles.contains(ALL) || CollectionUtils.isEmpty((Collection)mobiles)) {
            at.setIsAtAll(true);
        }
        MarkdownReq markdownReq = new MarkdownReq();
        markdownReq.setMsgtype("markdown");
        markdownReq.setMarkdown(markdown);
        markdownReq.setAt(at);
        return JsonUtil.toJson(markdownReq);
    }

    @Override
    protected String buildUrl(NotifyPlatform platform) {
        String webhook = Optional.ofNullable(platform.getWebhook()).orElse("https://oapi.dingtalk.com/robot/send");
        return this.getTargetUrl(platform.getSecret(), platform.getUrlKey(), webhook);
    }

    private String getTargetUrl(String secret, String accessToken, String webhook) {
        UrlBuilder builder = UrlBuilder.of((String)webhook);
        if (StringUtils.isNotBlank((CharSequence)accessToken) && StringUtils.isBlank((CharSequence)builder.getQuery().get((CharSequence)"access_token"))) {
            builder.addQuery("access_token", (Object)accessToken);
        }
        if (StringUtils.isNotBlank((CharSequence)secret)) {
            long timestamp = System.currentTimeMillis();
            builder.addQuery("timestamp", (Object)timestamp);
            builder.addQuery("sign", (Object)DingSignUtil.dingSign(secret, timestamp));
        }
        return builder.build();
    }
}

