/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.manager;

import com.google.common.eventbus.EventBus;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventBusManager.class);
    private static final EventBus EVENT_BUS = new EventBus();
    private static final Set<Object> REGISTERED_OBJECTS = ConcurrentHashMap.newKeySet();

    private EventBusManager() {
    }

    public static void register(Object object) {
        if (REGISTERED_OBJECTS.add(object)) {
            EVENT_BUS.register(object);
        }
    }

    public static void unregister(Object object) {
        if (REGISTERED_OBJECTS.remove(object)) {
            try {
                EVENT_BUS.unregister(object);
            }
            catch (IllegalArgumentException e) {
                log.warn("Attempted to unregister an object that was not registered: {}", object, (Object)e);
            }
        }
    }

    public static void post(Object event) {
        EVENT_BUS.post(event);
    }

    public static EventBus getInstance() {
        return EVENT_BUS;
    }

    public static void destroy() {
        for (Object object : REGISTERED_OBJECTS) {
            try {
                EVENT_BUS.unregister(object);
            }
            catch (Exception e) {
                log.warn("Attempted to unregister an object that was not registered: {}", object, (Object)e);
            }
        }
        REGISTERED_OBJECTS.clear();
    }
}

