/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.em.NotifyItemEnum;
import org.dromara.dynamictp.common.util.DefaultValueUtil;
import org.dromara.dynamictp.common.util.StringUtil;

public class NotifyItem {
    private boolean enabled = true;
    private String type;
    private int threshold;
    private int count;
    private int period = 120;
    private int silencePeriod = 120;
    private int clusterLimit = 1;
    private String receivers;
    private List<String> platformIds;

    public static List<NotifyItem> mergeAllNotifyItems(List<NotifyItem> source) {
        if (CollectionUtils.isEmpty(source)) {
            return NotifyItem.getAllNotifyItems();
        }
        List configuredTypes = source.stream().map(NotifyItem::getType).collect(Collectors.toList());
        List defaultItems = NotifyItem.getAllNotifyItems().stream().filter(t -> !StringUtil.containsIgnoreCase((CharSequence)t.getType(), configuredTypes)).collect(Collectors.toList());
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>(6);
        notifyItems.addAll(defaultItems);
        NotifyItem.populateDefaultValues(source);
        notifyItems.addAll(source);
        return notifyItems;
    }

    public static List<NotifyItem> getAllNotifyItems() {
        NotifyItem rejectNotify = new NotifyItem();
        rejectNotify.setType(NotifyItemEnum.REJECT.getValue());
        NotifyItem runTimeoutNotify = new NotifyItem();
        runTimeoutNotify.setType(NotifyItemEnum.RUN_TIMEOUT.getValue());
        NotifyItem queueTimeoutNotify = new NotifyItem();
        queueTimeoutNotify.setType(NotifyItemEnum.QUEUE_TIMEOUT.getValue());
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>(6);
        notifyItems.addAll(NotifyItem.getSimpleNotifyItems());
        notifyItems.add(rejectNotify);
        notifyItems.add(runTimeoutNotify);
        notifyItems.add(queueTimeoutNotify);
        NotifyItem.populateDefaultValues(notifyItems);
        return notifyItems;
    }

    public static List<NotifyItem> getSimpleNotifyItems() {
        NotifyItem changeNotify = new NotifyItem();
        changeNotify.setType(NotifyItemEnum.CHANGE.getValue());
        changeNotify.setSilencePeriod(1);
        NotifyItem livenessNotify = new NotifyItem();
        livenessNotify.setType(NotifyItemEnum.LIVENESS.getValue());
        NotifyItem capacityNotify = new NotifyItem();
        capacityNotify.setType(NotifyItemEnum.CAPACITY.getValue());
        ArrayList<NotifyItem> notifyItems = new ArrayList<NotifyItem>(3);
        notifyItems.add(livenessNotify);
        notifyItems.add(changeNotify);
        notifyItems.add(capacityNotify);
        return notifyItems;
    }

    private static void populateDefaultValues(List<NotifyItem> source) {
        if (CollectionUtils.isEmpty(source)) {
            return;
        }
        for (NotifyItem item : source) {
            NotifyItemEnum itemEnum = NotifyItemEnum.of(item.getType());
            switch (Objects.requireNonNull(itemEnum)) {
                case REJECT: {
                    DefaultValueUtil.setIfZero(item::getCount, item::setCount, 1);
                    break;
                }
                case RUN_TIMEOUT: 
                case QUEUE_TIMEOUT: {
                    DefaultValueUtil.setIfZero(item::getCount, item::setCount, 10);
                    break;
                }
                case LIVENESS: 
                case CAPACITY: {
                    DefaultValueUtil.setIfZero(item::getThreshold, item::setThreshold, 70);
                    DefaultValueUtil.setIfZero(item::getCount, item::setCount, 1);
                    break;
                }
            }
        }
    }

    @Generated
    public NotifyItem() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public int getThreshold() {
        return this.threshold;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public int getPeriod() {
        return this.period;
    }

    @Generated
    public int getSilencePeriod() {
        return this.silencePeriod;
    }

    @Generated
    public int getClusterLimit() {
        return this.clusterLimit;
    }

    @Generated
    public String getReceivers() {
        return this.receivers;
    }

    @Generated
    public List<String> getPlatformIds() {
        return this.platformIds;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Generated
    public void setCount(int count) {
        this.count = count;
    }

    @Generated
    public void setPeriod(int period) {
        this.period = period;
    }

    @Generated
    public void setSilencePeriod(int silencePeriod) {
        this.silencePeriod = silencePeriod;
    }

    @Generated
    public void setClusterLimit(int clusterLimit) {
        this.clusterLimit = clusterLimit;
    }

    @Generated
    public void setReceivers(String receivers) {
        this.receivers = receivers;
    }

    @Generated
    public void setPlatformIds(List<String> platformIds) {
        this.platformIds = platformIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotifyItem)) {
            return false;
        }
        NotifyItem other = (NotifyItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getPeriod() != other.getPeriod()) {
            return false;
        }
        if (this.getSilencePeriod() != other.getSilencePeriod()) {
            return false;
        }
        if (this.getClusterLimit() != other.getClusterLimit()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$receivers = this.getReceivers();
        String other$receivers = other.getReceivers();
        if (this$receivers == null ? other$receivers != null : !this$receivers.equals(other$receivers)) {
            return false;
        }
        List<String> this$platformIds = this.getPlatformIds();
        List<String> other$platformIds = other.getPlatformIds();
        return !(this$platformIds == null ? other$platformIds != null : !((Object)this$platformIds).equals(other$platformIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotifyItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getThreshold();
        result = result * 59 + this.getCount();
        result = result * 59 + this.getPeriod();
        result = result * 59 + this.getSilencePeriod();
        result = result * 59 + this.getClusterLimit();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $receivers = this.getReceivers();
        result = result * 59 + ($receivers == null ? 43 : $receivers.hashCode());
        List<String> $platformIds = this.getPlatformIds();
        result = result * 59 + ($platformIds == null ? 43 : ((Object)$platformIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotifyItem(enabled=" + this.isEnabled() + ", type=" + this.getType() + ", threshold=" + this.getThreshold() + ", count=" + this.getCount() + ", period=" + this.getPeriod() + ", silencePeriod=" + this.getSilencePeriod() + ", clusterLimit=" + this.getClusterLimit() + ", receivers=" + this.getReceivers() + ", platformIds=" + String.valueOf(this.getPlatformIds()) + ")";
    }
}

