/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.entity.DtpExecutorProps;
import org.dromara.dynamictp.common.entity.TpExecutorProps;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ReflectionUtil;

public final class DtpPropertiesBinderUtil {
    private DtpPropertiesBinderUtil() {
    }

    public static void tryResetWithGlobalConfig(Object source, DtpProperties dtpProperties) {
        if (Objects.isNull(dtpProperties.getGlobalExecutorProps())) {
            return;
        }
        if (CollectionUtils.isNotEmpty(dtpProperties.getExecutors())) {
            DtpPropertiesBinderUtil.tryResetCusExecutors(dtpProperties, source);
        }
        DtpPropertiesBinderUtil.tryResetAdapterExecutors(dtpProperties, source);
    }

    private static void tryResetCusExecutors(DtpProperties dtpProperties, Object source) {
        List<Field> dtpPropsFields = ReflectionUtil.getAllFields(DtpExecutorProps.class);
        DtpExecutorProps globalExecutorProps = dtpProperties.getGlobalExecutorProps();
        int[] idx = new int[]{0};
        dtpProperties.getExecutors().forEach(executor -> {
            dtpPropsFields.forEach(field -> {
                String propKey = "dynamictp.executors[" + idx[0] + "]." + field.getName();
                DtpPropertiesBinderUtil.setBasicField(source, field, executor, propKey);
            });
            String executorFieldNamePrefix = "dynamictp.executors[" + idx[0] + "]";
            DtpPropertiesBinderUtil.setCollectionField(source, globalExecutorProps, executor, executorFieldNamePrefix);
            nArray[0] = idx[0] + 1;
        });
    }

    private static void tryResetAdapterExecutors(DtpProperties dtpProperties, Object source) {
        List<Field> dtpPropertiesFields = ReflectionUtil.getAllFields(DtpProperties.class);
        List<Field> tpExecutorPropFields = ReflectionUtil.getAllFields(TpExecutorProps.class);
        DtpExecutorProps globalExecutorProps = dtpProperties.getGlobalExecutorProps();
        dtpPropertiesFields.forEach(dtpPropertiesField -> {
            ParameterizedType paramType;
            Type[] argTypes;
            Object candidateExecutor = ReflectUtil.getFieldValue((Object)dtpProperties, (Field)dtpPropertiesField);
            if (Objects.isNull(candidateExecutor)) {
                return;
            }
            String candidateExecutorFieldName = dtpPropertiesField.getName();
            if (dtpPropertiesField.getType().isAssignableFrom(TpExecutorProps.class)) {
                tpExecutorPropFields.forEach(field -> DtpPropertiesBinderUtil.setBasicField(source, field, candidateExecutorFieldName, candidateExecutor));
                String executorFieldNamePrefix = "dynamictp." + dtpPropertiesField.getName();
                DtpPropertiesBinderUtil.setCollectionField(source, globalExecutorProps, candidateExecutor, executorFieldNamePrefix);
            } else if (dtpPropertiesField.getGenericType() instanceof ParameterizedType && (argTypes = (paramType = (ParameterizedType)dtpPropertiesField.getGenericType()).getActualTypeArguments()).length == 1 && argTypes[0].equals(TpExecutorProps.class)) {
                List executors = (List)candidateExecutor;
                if (CollectionUtils.isEmpty((Collection)executors)) {
                    return;
                }
                int[] idx = new int[]{0};
                executors.forEach(executor -> {
                    tpExecutorPropFields.forEach(field -> DtpPropertiesBinderUtil.setBasicField(source, field, candidateExecutorFieldName, executor, idx));
                    String executorFieldNamePrefix = "dynamictp." + candidateExecutorFieldName + "[" + idx[0] + "]";
                    DtpPropertiesBinderUtil.setCollectionField(source, globalExecutorProps, executor, executorFieldNamePrefix);
                    nArray[0] = idx[0] + 1;
                });
            }
        });
    }

    private static Object getProperty(String key, Object environment) {
        if (environment instanceof Map) {
            Map properties = (Map)environment;
            return properties.get(key);
        }
        return ContextManagerHelper.getEnvironmentProperty(key, environment);
    }

    private static void setBasicField(Object source, Field field, String executorFieldName, Object executor, int[] idx) {
        String propKey = "dynamictp." + executorFieldName + "[" + idx[0] + "]." + field.getName();
        DtpPropertiesBinderUtil.setBasicField(source, field, executor, propKey);
    }

    private static void setBasicField(Object source, Field field, String executorFieldName, Object executor) {
        String propKey = "dynamictp." + executorFieldName + "." + field.getName();
        DtpPropertiesBinderUtil.setBasicField(source, field, executor, propKey);
    }

    private static void setBasicField(Object source, Field field, Object executor, String propKey) {
        Object propVal = DtpPropertiesBinderUtil.getProperty(propKey, source);
        if (Objects.nonNull(propVal)) {
            return;
        }
        Object globalFieldVal = DtpPropertiesBinderUtil.getProperty("dynamictp.globalExecutorProps." + field.getName(), source);
        if (Objects.isNull(globalFieldVal)) {
            return;
        }
        ReflectUtil.setFieldValue((Object)executor, (String)field.getName(), (Object)globalFieldVal);
    }

    private static void setCollectionField(Object source, DtpExecutorProps globalExecutorProps, Object executor, String prefix) {
        if (DtpPropertiesBinderUtil.isNotContains(prefix + ".taskWrapperNames[0]", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getTaskWrapperNames())) {
            ReflectUtil.setFieldValue((Object)executor, (String)"taskWrapperNames", globalExecutorProps.getTaskWrapperNames());
        }
        if (DtpPropertiesBinderUtil.isNotContains(prefix + ".platformIds[0]", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getPlatformIds())) {
            ReflectUtil.setFieldValue((Object)executor, (String)"platformIds", globalExecutorProps.getPlatformIds());
        }
        if (DtpPropertiesBinderUtil.isNotContains(prefix + ".notifyItems[0].type", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getNotifyItems())) {
            ReflectUtil.setFieldValue((Object)executor, (String)"notifyItems", globalExecutorProps.getNotifyItems());
        }
        if (DtpPropertiesBinderUtil.isNotContains(prefix + ".awareNames[0]", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getAwareNames())) {
            ReflectUtil.setFieldValue((Object)executor, (String)"awareNames", globalExecutorProps.getAwareNames());
        }
        try {
            if (DtpPropertiesBinderUtil.isNotContains(prefix + ".pluginNames[0]", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getPluginNames())) {
                ReflectUtil.setFieldValue((Object)executor, (String)"pluginNames", globalExecutorProps.getPluginNames());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isNotContains(String key, Object environment) {
        return !DtpPropertiesBinderUtil.contains(key, environment);
    }

    private static boolean contains(String key, Object environment) {
        if (environment instanceof Map) {
            Map properties = (Map)environment;
            return properties.containsKey(key);
        }
        return StringUtils.isNotBlank((CharSequence)ContextManagerHelper.getEnvironmentProperty(key, environment));
    }
}

