/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.entity.ServiceInstance;
import org.dromara.dynamictp.common.manager.ContextManagerHelper;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    private static final ServiceInstance SERVICE_INSTANCE;

    private CommonUtil() {
    }

    public static ServiceInstance getInstance() {
        return SERVICE_INSTANCE;
    }

    private static InetAddress getLocalHostExactAddress() throws SocketException, UnknownHostException {
        InetAddress candidateAddress = null;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress.isLoopbackAddress() || !inetAddress.isSiteLocalAddress()) continue;
                if (!networkInterface.isPointToPoint()) {
                    return inetAddress;
                }
                candidateAddress = inetAddress;
            }
        }
        return candidateAddress == null ? InetAddress.getLocalHost() : candidateAddress;
    }

    static {
        String address = null;
        try {
            address = CommonUtil.getLocalHostExactAddress().getHostAddress();
        }
        catch (SocketException | UnknownHostException e) {
            log.error("get localhost address error.", (Throwable)e);
        }
        String env = DtpProperties.getInstance().getEnv();
        if (StringUtils.isBlank((CharSequence)env)) {
            env = ContextManagerHelper.getEnvironmentProperty("APP.ENV");
        }
        String appName = ContextManagerHelper.getEnvironmentProperty("APP.NAME");
        String portStr = ContextManagerHelper.getEnvironmentProperty("APP.PORT");
        int port = StringUtils.isNotBlank((CharSequence)portStr) ? Integer.parseInt(portStr) : 0;
        SERVICE_INSTANCE = new ServiceInstance(address, port, appName, env);
    }
}

