/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.parser.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.dromara.dynamictp.common.parser.json.AbstractJsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonParser
extends AbstractJsonParser {
    private static final Logger log = LoggerFactory.getLogger(JacksonParser.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PACKAGE_NAME = "com.fasterxml.jackson.databind.ObjectMapper";
    private volatile ObjectMapper mapper;

    @Override
    public <T> T fromJson(String json, Type typeOfT) {
        try {
            ObjectMapper objectMapper = this.getMapper();
            return (T)objectMapper.readValue(json, objectMapper.constructType(typeOfT));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        try {
            return this.getMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper getMapper() {
        if (this.mapper == null) {
            JacksonParser jacksonParser = this;
            synchronized (jacksonParser) {
                if (this.mapper == null) {
                    this.mapper = this.createMapper();
                }
            }
        }
        return this.mapper;
    }

    protected ObjectMapper createMapper() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).serializationInclusion(JsonInclude.Include.NON_EMPTY)).addModules(new Module[]{javaTimeModule})).addModules(new Module[]{new JavaTimeModule()})).defaultDateFormat((DateFormat)new SimpleDateFormat(DATE_FORMAT))).build();
    }

    @Override
    protected String getMapperClassName() {
        return PACKAGE_NAME;
    }
}

