/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.notifier;

import cn.hutool.core.net.url.UrlBuilder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.em.NotifyPlatformEnum;
import org.dromara.dynamictp.common.entity.NotifyPlatform;
import org.dromara.dynamictp.common.notifier.AbstractHttpNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LarkNotifier
extends AbstractHttpNotifier {
    private static final Logger log = LoggerFactory.getLogger(LarkNotifier.class);
    public static final String LF = "\n";
    public static final String HMAC_SHA_256 = "HmacSHA256";

    @Override
    public String platform() {
        return NotifyPlatformEnum.LARK.name().toLowerCase();
    }

    protected String genSign(String secret, Long timestamp) throws NoSuchAlgorithmException, InvalidKeyException {
        String stringToSign = timestamp + LF + secret;
        Mac mac = Mac.getInstance(HMAC_SHA_256);
        mac.init(new SecretKeySpec(stringToSign.getBytes(StandardCharsets.UTF_8), HMAC_SHA_256));
        byte[] signData = mac.doFinal(new byte[0]);
        return new String(Base64.encodeBase64((byte[])signData));
    }

    @Override
    protected String buildMsgBody(NotifyPlatform platform, String content) {
        if (StringUtils.isBlank((CharSequence)platform.getSecret())) {
            return content;
        }
        try {
            long secondsTimestamp = System.currentTimeMillis() / 1000L;
            String sign = this.genSign(platform.getSecret(), secondsTimestamp);
            content = content.replaceFirst("\\{", String.format("{\"timestamp\": \"%s\",\"sign\": \"%s\",", secondsTimestamp, sign));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("DynamicTp notify, lark generate signature failed...", (Throwable)e);
        }
        return content;
    }

    @Override
    protected String buildUrl(NotifyPlatform platform) {
        if (StringUtils.isBlank((CharSequence)platform.getUrlKey())) {
            return platform.getWebhook();
        }
        UrlBuilder builder = UrlBuilder.of((String)Optional.ofNullable(platform.getWebhook()).orElse("https://open.feishu.cn/open-apis/bot/v2/hook"));
        List segments = builder.getPath().getSegments();
        if (!Objects.equals(platform.getUrlKey(), segments.get(segments.size() - 1))) {
            builder.addPath((CharSequence)platform.getUrlKey());
        }
        return builder.build();
    }
}

