/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.manager;

import java.util.Map;
import org.dromara.dynamictp.common.manager.ContextManager;
import org.dromara.dynamictp.common.manager.NullContextManager;
import org.dromara.dynamictp.common.util.ExtensionServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManagerHelper {
    private static final Logger log = LoggerFactory.getLogger(ContextManagerHelper.class);
    private static ContextManager contextManager = ExtensionServiceLoader.getFirst(ContextManager.class);

    public static <T> T getBean(Class<T> clazz) {
        return contextManager.getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return contextManager.getBean(name, clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return contextManager.getBeansOfType(clazz);
    }

    public static Object getEnvironment() {
        return contextManager.getEnvironment();
    }

    public static String getEnvironmentProperty(String key) {
        return contextManager.getEnvironmentProperty(key);
    }

    public static String getEnvironmentProperty(String key, Object environment) {
        return contextManager.getEnvironmentProperty(key, environment);
    }

    public static String getEnvironmentProperty(String key, String defaultValue) {
        return contextManager.getEnvironmentProperty(key, defaultValue);
    }

    static {
        if (contextManager == null) {
            contextManager = new NullContextManager();
            throw new IllegalStateException("No ContextManager implementation found");
        }
    }
}

