/*
 *  Copyright 2007-2008, Plutext Pty Ltd.
 *   
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


package org.docx4j.dml;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;


/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the org.docx4j.dml package. 
 * <p>An ObjectFactory allows you to programatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {

    private final static QName _Blip_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "blip");
    private final static QName _ThemeOverride_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "themeOverride");
    private final static QName _ThemeManager_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "themeManager");
    private final static QName _Graphic_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "graphic");
    private final static QName _TblStyleLst_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "tblStyleLst");
    private final static QName _Tbl_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "tbl");
    private final static QName _CTPresetColorTint_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "tint");
    private final static QName _CTPresetColorShade_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "shade");
    private final static QName _CTPresetColorComp_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "comp");
    private final static QName _CTPresetColorInv_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "inv");
    private final static QName _CTPresetColorGray_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "gray");
    private final static QName _CTPresetColorAlpha_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "alpha");
    private final static QName _CTPresetColorAlphaOff_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "alphaOff");
    private final static QName _CTPresetColorAlphaMod_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "alphaMod");
    private final static QName _CTPresetColorHue_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "hue");
    private final static QName _CTPresetColorHueOff_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "hueOff");
    private final static QName _CTPresetColorHueMod_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "hueMod");
    private final static QName _CTPresetColorSat_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "sat");
    private final static QName _CTPresetColorSatOff_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "satOff");
    private final static QName _CTPresetColorSatMod_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "satMod");
    private final static QName _CTPresetColorLum_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "lum");
    private final static QName _CTPresetColorLumOff_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "lumOff");
    private final static QName _CTPresetColorLumMod_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "lumMod");
    private final static QName _CTPresetColorRed_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "red");
    private final static QName _CTPresetColorRedOff_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "redOff");
    private final static QName _CTPresetColorRedMod_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "redMod");
    private final static QName _CTPresetColorGreen_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "green");
    private final static QName _CTPresetColorGreenOff_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "greenOff");
    private final static QName _CTPresetColorGreenMod_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "greenMod");
    private final static QName _CTPresetColorBlue_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "blue");
    private final static QName _CTPresetColorBlueOff_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "blueOff");
    private final static QName _CTPresetColorBlueMod_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "blueMod");
    private final static QName _CTPresetColorGamma_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "gamma");
    private final static QName _CTPresetColorInvGamma_QNAME = new QName("http://schemas.openxmlformats.org/drawingml/2006/main", "invGamma");

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.docx4j.dml
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link FontCollection }
     * 
     */
    public FontCollection createFontCollection() {
        return new FontCollection();
    }

    /**
     * Create an instance of {@link CTBaseStylesOverride }
     * 
     */
    public CTBaseStylesOverride createCTBaseStylesOverride() {
        return new CTBaseStylesOverride();
    }

    /**
     * Create an instance of {@link BaseStyles }
     * 
     */
    public BaseStyles createBaseStyles() {
        return new BaseStyles();
    }

    /**
     * Create an instance of {@link CTBlip }
     * 
     */
    public CTBlip createCTBlip() {
        return new CTBlip();
    }

    /**
     * Create an instance of {@link Theme }
     * 
     */
    public Theme createTheme() {
        return new Theme();
    }

    /**
     * Create an instance of {@link CTObjectStyleDefaults }
     * 
     */
    public CTObjectStyleDefaults createCTObjectStyleDefaults() {
        return new CTObjectStyleDefaults();
    }

    /**
     * Create an instance of {@link CTColorSchemeList }
     * 
     */
    public CTColorSchemeList createCTColorSchemeList() {
        return new CTColorSchemeList();
    }

    /**
     * Create an instance of {@link CTCustomColorList }
     * 
     */
    public CTCustomColorList createCTCustomColorList() {
        return new CTCustomColorList();
    }

    /**
     * Create an instance of {@link CTOfficeArtExtensionList }
     * 
     */
    public CTOfficeArtExtensionList createCTOfficeArtExtensionList() {
        return new CTOfficeArtExtensionList();
    }

    /**
     * Create an instance of {@link CTEmptyElement }
     * 
     */
    public CTEmptyElement createCTEmptyElement() {
        return new CTEmptyElement();
    }

    /**
     * Create an instance of {@link Graphic }
     * 
     */
    public Graphic createGraphic() {
        return new Graphic();
    }

    /**
     * Create an instance of {@link CTTableStyleList }
     * 
     */
    public CTTableStyleList createCTTableStyleList() {
        return new CTTableStyleList();
    }

    /**
     * Create an instance of {@link CTTable }
     * 
     */
    public CTTable createCTTable() {
        return new CTTable();
    }

    /**
     * Create an instance of {@link CTOfficeArtExtension }
     * 
     */
    public CTOfficeArtExtension createCTOfficeArtExtension() {
        return new CTOfficeArtExtension();
    }

    /**
     * Create an instance of {@link CTAngle }
     * 
     */
    public CTAngle createCTAngle() {
        return new CTAngle();
    }

    /**
     * Create an instance of {@link CTPositiveFixedAngle }
     * 
     */
    public CTPositiveFixedAngle createCTPositiveFixedAngle() {
        return new CTPositiveFixedAngle();
    }

    /**
     * Create an instance of {@link CTPercentage }
     * 
     */
    public CTPercentage createCTPercentage() {
        return new CTPercentage();
    }

    /**
     * Create an instance of {@link CTPositivePercentage }
     * 
     */
    public CTPositivePercentage createCTPositivePercentage() {
        return new CTPositivePercentage();
    }

    /**
     * Create an instance of {@link CTFixedPercentage }
     * 
     */
    public CTFixedPercentage createCTFixedPercentage() {
        return new CTFixedPercentage();
    }

    /**
     * Create an instance of {@link CTPositiveFixedPercentage }
     * 
     */
    public CTPositiveFixedPercentage createCTPositiveFixedPercentage() {
        return new CTPositiveFixedPercentage();
    }

    /**
     * Create an instance of {@link CTRatio }
     * 
     */
    public CTRatio createCTRatio() {
        return new CTRatio();
    }

    /**
     * Create an instance of {@link CTPoint2D }
     * 
     */
    public CTPoint2D createCTPoint2D() {
        return new CTPoint2D();
    }

    /**
     * Create an instance of {@link CTPositiveSize2D }
     * 
     */
    public CTPositiveSize2D createCTPositiveSize2D() {
        return new CTPositiveSize2D();
    }

    /**
     * Create an instance of {@link CTComplementTransform }
     * 
     */
    public CTComplementTransform createCTComplementTransform() {
        return new CTComplementTransform();
    }

    /**
     * Create an instance of {@link CTInverseTransform }
     * 
     */
    public CTInverseTransform createCTInverseTransform() {
        return new CTInverseTransform();
    }

    /**
     * Create an instance of {@link CTGrayscaleTransform }
     * 
     */
    public CTGrayscaleTransform createCTGrayscaleTransform() {
        return new CTGrayscaleTransform();
    }

    /**
     * Create an instance of {@link CTGammaTransform }
     * 
     */
    public CTGammaTransform createCTGammaTransform() {
        return new CTGammaTransform();
    }

    /**
     * Create an instance of {@link CTInverseGammaTransform }
     * 
     */
    public CTInverseGammaTransform createCTInverseGammaTransform() {
        return new CTInverseGammaTransform();
    }

    /**
     * Create an instance of {@link CTScRgbColor }
     * 
     */
    public CTScRgbColor createCTScRgbColor() {
        return new CTScRgbColor();
    }

    /**
     * Create an instance of {@link CTSRgbColor }
     * 
     */
    public CTSRgbColor createCTSRgbColor() {
        return new CTSRgbColor();
    }

    /**
     * Create an instance of {@link CTHslColor }
     * 
     */
    public CTHslColor createCTHslColor() {
        return new CTHslColor();
    }

    /**
     * Create an instance of {@link CTSystemColor }
     * 
     */
    public CTSystemColor createCTSystemColor() {
        return new CTSystemColor();
    }

    /**
     * Create an instance of {@link CTSchemeColor }
     * 
     */
    public CTSchemeColor createCTSchemeColor() {
        return new CTSchemeColor();
    }

    /**
     * Create an instance of {@link CTPresetColor }
     * 
     */
    public CTPresetColor createCTPresetColor() {
        return new CTPresetColor();
    }

    /**
     * Create an instance of {@link CTScale2D }
     * 
     */
    public CTScale2D createCTScale2D() {
        return new CTScale2D();
    }

    /**
     * Create an instance of {@link CTTransform2D }
     * 
     */
    public CTTransform2D createCTTransform2D() {
        return new CTTransform2D();
    }

    /**
     * Create an instance of {@link CTGroupTransform2D }
     * 
     */
    public CTGroupTransform2D createCTGroupTransform2D() {
        return new CTGroupTransform2D();
    }

    /**
     * Create an instance of {@link CTPoint3D }
     * 
     */
    public CTPoint3D createCTPoint3D() {
        return new CTPoint3D();
    }

    /**
     * Create an instance of {@link CTVector3D }
     * 
     */
    public CTVector3D createCTVector3D() {
        return new CTVector3D();
    }

    /**
     * Create an instance of {@link CTSphereCoords }
     * 
     */
    public CTSphereCoords createCTSphereCoords() {
        return new CTSphereCoords();
    }

    /**
     * Create an instance of {@link CTRelativeRect }
     * 
     */
    public CTRelativeRect createCTRelativeRect() {
        return new CTRelativeRect();
    }

    /**
     * Create an instance of {@link CTColor }
     * 
     */
    public CTColor createCTColor() {
        return new CTColor();
    }

    /**
     * Create an instance of {@link CTColorMRU }
     * 
     */
    public CTColorMRU createCTColorMRU() {
        return new CTColorMRU();
    }

    /**
     * Create an instance of {@link CTEmbeddedWAVAudioFile }
     * 
     */
    public CTEmbeddedWAVAudioFile createCTEmbeddedWAVAudioFile() {
        return new CTEmbeddedWAVAudioFile();
    }

    /**
     * Create an instance of {@link CTHyperlink }
     * 
     */
    public CTHyperlink createCTHyperlink() {
        return new CTHyperlink();
    }

    /**
     * Create an instance of {@link CTCamera }
     * 
     */
    public CTCamera createCTCamera() {
        return new CTCamera();
    }

    /**
     * Create an instance of {@link CTLightRig }
     * 
     */
    public CTLightRig createCTLightRig() {
        return new CTLightRig();
    }

    /**
     * Create an instance of {@link CTBackdrop }
     * 
     */
    public CTBackdrop createCTBackdrop() {
        return new CTBackdrop();
    }

    /**
     * Create an instance of {@link CTScene3D }
     * 
     */
    public CTScene3D createCTScene3D() {
        return new CTScene3D();
    }

    /**
     * Create an instance of {@link CTGeomGuide }
     * 
     */
    public CTGeomGuide createCTGeomGuide() {
        return new CTGeomGuide();
    }

    /**
     * Create an instance of {@link CTGeomGuideList }
     * 
     */
    public CTGeomGuideList createCTGeomGuideList() {
        return new CTGeomGuideList();
    }

    /**
     * Create an instance of {@link CTAdjPoint2D }
     * 
     */
    public CTAdjPoint2D createCTAdjPoint2D() {
        return new CTAdjPoint2D();
    }

    /**
     * Create an instance of {@link CTGeomRect }
     * 
     */
    public CTGeomRect createCTGeomRect() {
        return new CTGeomRect();
    }

    /**
     * Create an instance of {@link CTXYAdjustHandle }
     * 
     */
    public CTXYAdjustHandle createCTXYAdjustHandle() {
        return new CTXYAdjustHandle();
    }

    /**
     * Create an instance of {@link CTPolarAdjustHandle }
     * 
     */
    public CTPolarAdjustHandle createCTPolarAdjustHandle() {
        return new CTPolarAdjustHandle();
    }

    /**
     * Create an instance of {@link CTConnectionSite }
     * 
     */
    public CTConnectionSite createCTConnectionSite() {
        return new CTConnectionSite();
    }

    /**
     * Create an instance of {@link CTAdjustHandleList }
     * 
     */
    public CTAdjustHandleList createCTAdjustHandleList() {
        return new CTAdjustHandleList();
    }

    /**
     * Create an instance of {@link CTConnectionSiteList }
     * 
     */
    public CTConnectionSiteList createCTConnectionSiteList() {
        return new CTConnectionSiteList();
    }

    /**
     * Create an instance of {@link CTConnection }
     * 
     */
    public CTConnection createCTConnection() {
        return new CTConnection();
    }

    /**
     * Create an instance of {@link CTPath2DMoveTo }
     * 
     */
    public CTPath2DMoveTo createCTPath2DMoveTo() {
        return new CTPath2DMoveTo();
    }

    /**
     * Create an instance of {@link CTPath2DLineTo }
     * 
     */
    public CTPath2DLineTo createCTPath2DLineTo() {
        return new CTPath2DLineTo();
    }

    /**
     * Create an instance of {@link CTPath2DArcTo }
     * 
     */
    public CTPath2DArcTo createCTPath2DArcTo() {
        return new CTPath2DArcTo();
    }

    /**
     * Create an instance of {@link CTPath2DQuadBezierTo }
     * 
     */
    public CTPath2DQuadBezierTo createCTPath2DQuadBezierTo() {
        return new CTPath2DQuadBezierTo();
    }

    /**
     * Create an instance of {@link CTPath2DCubicBezierTo }
     * 
     */
    public CTPath2DCubicBezierTo createCTPath2DCubicBezierTo() {
        return new CTPath2DCubicBezierTo();
    }

    /**
     * Create an instance of {@link CTPath2DClose }
     * 
     */
    public CTPath2DClose createCTPath2DClose() {
        return new CTPath2DClose();
    }

    /**
     * Create an instance of {@link CTPath2D }
     * 
     */
    public CTPath2D createCTPath2D() {
        return new CTPath2D();
    }

    /**
     * Create an instance of {@link CTPath2DList }
     * 
     */
    public CTPath2DList createCTPath2DList() {
        return new CTPath2DList();
    }

    /**
     * Create an instance of {@link CTPresetGeometry2D }
     * 
     */
    public CTPresetGeometry2D createCTPresetGeometry2D() {
        return new CTPresetGeometry2D();
    }

    /**
     * Create an instance of {@link CTPresetTextShape }
     * 
     */
    public CTPresetTextShape createCTPresetTextShape() {
        return new CTPresetTextShape();
    }

    /**
     * Create an instance of {@link CTCustomGeometry2D }
     * 
     */
    public CTCustomGeometry2D createCTCustomGeometry2D() {
        return new CTCustomGeometry2D();
    }

    /**
     * Create an instance of {@link CTBevel }
     * 
     */
    public CTBevel createCTBevel() {
        return new CTBevel();
    }

    /**
     * Create an instance of {@link CTShape3D }
     * 
     */
    public CTShape3D createCTShape3D() {
        return new CTShape3D();
    }

    /**
     * Create an instance of {@link CTFlatText }
     * 
     */
    public CTFlatText createCTFlatText() {
        return new CTFlatText();
    }

    /**
     * Create an instance of {@link CTAlphaBiLevelEffect }
     * 
     */
    public CTAlphaBiLevelEffect createCTAlphaBiLevelEffect() {
        return new CTAlphaBiLevelEffect();
    }

    /**
     * Create an instance of {@link CTAlphaCeilingEffect }
     * 
     */
    public CTAlphaCeilingEffect createCTAlphaCeilingEffect() {
        return new CTAlphaCeilingEffect();
    }

    /**
     * Create an instance of {@link CTAlphaFloorEffect }
     * 
     */
    public CTAlphaFloorEffect createCTAlphaFloorEffect() {
        return new CTAlphaFloorEffect();
    }

    /**
     * Create an instance of {@link CTAlphaInverseEffect }
     * 
     */
    public CTAlphaInverseEffect createCTAlphaInverseEffect() {
        return new CTAlphaInverseEffect();
    }

    /**
     * Create an instance of {@link CTAlphaModulateFixedEffect }
     * 
     */
    public CTAlphaModulateFixedEffect createCTAlphaModulateFixedEffect() {
        return new CTAlphaModulateFixedEffect();
    }

    /**
     * Create an instance of {@link CTAlphaOutsetEffect }
     * 
     */
    public CTAlphaOutsetEffect createCTAlphaOutsetEffect() {
        return new CTAlphaOutsetEffect();
    }

    /**
     * Create an instance of {@link CTAlphaReplaceEffect }
     * 
     */
    public CTAlphaReplaceEffect createCTAlphaReplaceEffect() {
        return new CTAlphaReplaceEffect();
    }

    /**
     * Create an instance of {@link CTBiLevelEffect }
     * 
     */
    public CTBiLevelEffect createCTBiLevelEffect() {
        return new CTBiLevelEffect();
    }

    /**
     * Create an instance of {@link CTBlurEffect }
     * 
     */
    public CTBlurEffect createCTBlurEffect() {
        return new CTBlurEffect();
    }

    /**
     * Create an instance of {@link CTColorChangeEffect }
     * 
     */
    public CTColorChangeEffect createCTColorChangeEffect() {
        return new CTColorChangeEffect();
    }

    /**
     * Create an instance of {@link CTColorReplaceEffect }
     * 
     */
    public CTColorReplaceEffect createCTColorReplaceEffect() {
        return new CTColorReplaceEffect();
    }

    /**
     * Create an instance of {@link CTDuotoneEffect }
     * 
     */
    public CTDuotoneEffect createCTDuotoneEffect() {
        return new CTDuotoneEffect();
    }

    /**
     * Create an instance of {@link CTGlowEffect }
     * 
     */
    public CTGlowEffect createCTGlowEffect() {
        return new CTGlowEffect();
    }

    /**
     * Create an instance of {@link CTGrayscaleEffect }
     * 
     */
    public CTGrayscaleEffect createCTGrayscaleEffect() {
        return new CTGrayscaleEffect();
    }

    /**
     * Create an instance of {@link CTHSLEffect }
     * 
     */
    public CTHSLEffect createCTHSLEffect() {
        return new CTHSLEffect();
    }

    /**
     * Create an instance of {@link CTInnerShadowEffect }
     * 
     */
    public CTInnerShadowEffect createCTInnerShadowEffect() {
        return new CTInnerShadowEffect();
    }

    /**
     * Create an instance of {@link CTLuminanceEffect }
     * 
     */
    public CTLuminanceEffect createCTLuminanceEffect() {
        return new CTLuminanceEffect();
    }

    /**
     * Create an instance of {@link CTOuterShadowEffect }
     * 
     */
    public CTOuterShadowEffect createCTOuterShadowEffect() {
        return new CTOuterShadowEffect();
    }

    /**
     * Create an instance of {@link CTPresetShadowEffect }
     * 
     */
    public CTPresetShadowEffect createCTPresetShadowEffect() {
        return new CTPresetShadowEffect();
    }

    /**
     * Create an instance of {@link CTReflectionEffect }
     * 
     */
    public CTReflectionEffect createCTReflectionEffect() {
        return new CTReflectionEffect();
    }

    /**
     * Create an instance of {@link CTRelativeOffsetEffect }
     * 
     */
    public CTRelativeOffsetEffect createCTRelativeOffsetEffect() {
        return new CTRelativeOffsetEffect();
    }

    /**
     * Create an instance of {@link CTSoftEdgesEffect }
     * 
     */
    public CTSoftEdgesEffect createCTSoftEdgesEffect() {
        return new CTSoftEdgesEffect();
    }

    /**
     * Create an instance of {@link CTTintEffect }
     * 
     */
    public CTTintEffect createCTTintEffect() {
        return new CTTintEffect();
    }

    /**
     * Create an instance of {@link CTTransformEffect }
     * 
     */
    public CTTransformEffect createCTTransformEffect() {
        return new CTTransformEffect();
    }

    /**
     * Create an instance of {@link CTNoFillProperties }
     * 
     */
    public CTNoFillProperties createCTNoFillProperties() {
        return new CTNoFillProperties();
    }

    /**
     * Create an instance of {@link CTSolidColorFillProperties }
     * 
     */
    public CTSolidColorFillProperties createCTSolidColorFillProperties() {
        return new CTSolidColorFillProperties();
    }

    /**
     * Create an instance of {@link CTLinearShadeProperties }
     * 
     */
    public CTLinearShadeProperties createCTLinearShadeProperties() {
        return new CTLinearShadeProperties();
    }

    /**
     * Create an instance of {@link CTPathShadeProperties }
     * 
     */
    public CTPathShadeProperties createCTPathShadeProperties() {
        return new CTPathShadeProperties();
    }

    /**
     * Create an instance of {@link CTGradientStop }
     * 
     */
    public CTGradientStop createCTGradientStop() {
        return new CTGradientStop();
    }

    /**
     * Create an instance of {@link CTGradientStopList }
     * 
     */
    public CTGradientStopList createCTGradientStopList() {
        return new CTGradientStopList();
    }

    /**
     * Create an instance of {@link CTGradientFillProperties }
     * 
     */
    public CTGradientFillProperties createCTGradientFillProperties() {
        return new CTGradientFillProperties();
    }

    /**
     * Create an instance of {@link CTTileInfoProperties }
     * 
     */
    public CTTileInfoProperties createCTTileInfoProperties() {
        return new CTTileInfoProperties();
    }

    /**
     * Create an instance of {@link CTStretchInfoProperties }
     * 
     */
    public CTStretchInfoProperties createCTStretchInfoProperties() {
        return new CTStretchInfoProperties();
    }

    /**
     * Create an instance of {@link CTBlipFillProperties }
     * 
     */
    public CTBlipFillProperties createCTBlipFillProperties() {
        return new CTBlipFillProperties();
    }

    /**
     * Create an instance of {@link CTPatternFillProperties }
     * 
     */
    public CTPatternFillProperties createCTPatternFillProperties() {
        return new CTPatternFillProperties();
    }

    /**
     * Create an instance of {@link CTGroupFillProperties }
     * 
     */
    public CTGroupFillProperties createCTGroupFillProperties() {
        return new CTGroupFillProperties();
    }

    /**
     * Create an instance of {@link CTFillProperties }
     * 
     */
    public CTFillProperties createCTFillProperties() {
        return new CTFillProperties();
    }

    /**
     * Create an instance of {@link CTFillEffect }
     * 
     */
    public CTFillEffect createCTFillEffect() {
        return new CTFillEffect();
    }

    /**
     * Create an instance of {@link CTFillOverlayEffect }
     * 
     */
    public CTFillOverlayEffect createCTFillOverlayEffect() {
        return new CTFillOverlayEffect();
    }

    /**
     * Create an instance of {@link CTEffectReference }
     * 
     */
    public CTEffectReference createCTEffectReference() {
        return new CTEffectReference();
    }

    /**
     * Create an instance of {@link CTEffectContainer }
     * 
     */
    public CTEffectContainer createCTEffectContainer() {
        return new CTEffectContainer();
    }

    /**
     * Create an instance of {@link CTAlphaModulateEffect }
     * 
     */
    public CTAlphaModulateEffect createCTAlphaModulateEffect() {
        return new CTAlphaModulateEffect();
    }

    /**
     * Create an instance of {@link CTBlendEffect }
     * 
     */
    public CTBlendEffect createCTBlendEffect() {
        return new CTBlendEffect();
    }

    /**
     * Create an instance of {@link CTEffectList }
     * 
     */
    public CTEffectList createCTEffectList() {
        return new CTEffectList();
    }

    /**
     * Create an instance of {@link CTEffectProperties }
     * 
     */
    public CTEffectProperties createCTEffectProperties() {
        return new CTEffectProperties();
    }

    /**
     * Create an instance of {@link CTLineEndProperties }
     * 
     */
    public CTLineEndProperties createCTLineEndProperties() {
        return new CTLineEndProperties();
    }

    /**
     * Create an instance of {@link CTLineJoinBevel }
     * 
     */
    public CTLineJoinBevel createCTLineJoinBevel() {
        return new CTLineJoinBevel();
    }

    /**
     * Create an instance of {@link CTLineJoinRound }
     * 
     */
    public CTLineJoinRound createCTLineJoinRound() {
        return new CTLineJoinRound();
    }

    /**
     * Create an instance of {@link CTLineJoinMiterProperties }
     * 
     */
    public CTLineJoinMiterProperties createCTLineJoinMiterProperties() {
        return new CTLineJoinMiterProperties();
    }

    /**
     * Create an instance of {@link CTPresetLineDashProperties }
     * 
     */
    public CTPresetLineDashProperties createCTPresetLineDashProperties() {
        return new CTPresetLineDashProperties();
    }

    /**
     * Create an instance of {@link CTDashStop }
     * 
     */
    public CTDashStop createCTDashStop() {
        return new CTDashStop();
    }

    /**
     * Create an instance of {@link CTDashStopList }
     * 
     */
    public CTDashStopList createCTDashStopList() {
        return new CTDashStopList();
    }

    /**
     * Create an instance of {@link CTLineProperties }
     * 
     */
    public CTLineProperties createCTLineProperties() {
        return new CTLineProperties();
    }

    /**
     * Create an instance of {@link CTShapeProperties }
     * 
     */
    public CTShapeProperties createCTShapeProperties() {
        return new CTShapeProperties();
    }

    /**
     * Create an instance of {@link CTGroupShapeProperties }
     * 
     */
    public CTGroupShapeProperties createCTGroupShapeProperties() {
        return new CTGroupShapeProperties();
    }

    /**
     * Create an instance of {@link TextFont }
     * 
     */
    public TextFont createTextFont() {
        return new TextFont();
    }

    /**
     * Create an instance of {@link CTTextUnderlineLineFollowText }
     * 
     */
    public CTTextUnderlineLineFollowText createCTTextUnderlineLineFollowText() {
        return new CTTextUnderlineLineFollowText();
    }

    /**
     * Create an instance of {@link CTTextUnderlineFillFollowText }
     * 
     */
    public CTTextUnderlineFillFollowText createCTTextUnderlineFillFollowText() {
        return new CTTextUnderlineFillFollowText();
    }

    /**
     * Create an instance of {@link CTTextUnderlineFillGroupWrapper }
     * 
     */
    public CTTextUnderlineFillGroupWrapper createCTTextUnderlineFillGroupWrapper() {
        return new CTTextUnderlineFillGroupWrapper();
    }

    /**
     * Create an instance of {@link CTTextCharacterProperties }
     * 
     */
    public CTTextCharacterProperties createCTTextCharacterProperties() {
        return new CTTextCharacterProperties();
    }

    /**
     * Create an instance of {@link CTColorScheme }
     * 
     */
    public CTColorScheme createCTColorScheme() {
        return new CTColorScheme();
    }

    /**
     * Create an instance of {@link CTCustomColor }
     * 
     */
    public CTCustomColor createCTCustomColor() {
        return new CTCustomColor();
    }

    /**
     * Create an instance of {@link CTEffectStyleItem }
     * 
     */
    public CTEffectStyleItem createCTEffectStyleItem() {
        return new CTEffectStyleItem();
    }

    /**
     * Create an instance of {@link CTFillStyleList }
     * 
     */
    public CTFillStyleList createCTFillStyleList() {
        return new CTFillStyleList();
    }

    /**
     * Create an instance of {@link CTLineStyleList }
     * 
     */
    public CTLineStyleList createCTLineStyleList() {
        return new CTLineStyleList();
    }

    /**
     * Create an instance of {@link CTEffectStyleList }
     * 
     */
    public CTEffectStyleList createCTEffectStyleList() {
        return new CTEffectStyleList();
    }

    /**
     * Create an instance of {@link CTBackgroundFillStyleList }
     * 
     */
    public CTBackgroundFillStyleList createCTBackgroundFillStyleList() {
        return new CTBackgroundFillStyleList();
    }

    /**
     * Create an instance of {@link CTStyleMatrix }
     * 
     */
    public CTStyleMatrix createCTStyleMatrix() {
        return new CTStyleMatrix();
    }

    /**
     * Create an instance of {@link CTAudioFile }
     * 
     */
    public CTAudioFile createCTAudioFile() {
        return new CTAudioFile();
    }

    /**
     * Create an instance of {@link CTVideoFile }
     * 
     */
    public CTVideoFile createCTVideoFile() {
        return new CTVideoFile();
    }

    /**
     * Create an instance of {@link CTQuickTimeFile }
     * 
     */
    public CTQuickTimeFile createCTQuickTimeFile() {
        return new CTQuickTimeFile();
    }

    /**
     * Create an instance of {@link CTAudioCDTime }
     * 
     */
    public CTAudioCDTime createCTAudioCDTime() {
        return new CTAudioCDTime();
    }

    /**
     * Create an instance of {@link CTAudioCD }
     * 
     */
    public CTAudioCD createCTAudioCD() {
        return new CTAudioCD();
    }

    /**
     * Create an instance of {@link CTTextBulletColorFollowText }
     * 
     */
    public CTTextBulletColorFollowText createCTTextBulletColorFollowText() {
        return new CTTextBulletColorFollowText();
    }

    /**
     * Create an instance of {@link CTTextBulletSizeFollowText }
     * 
     */
    public CTTextBulletSizeFollowText createCTTextBulletSizeFollowText() {
        return new CTTextBulletSizeFollowText();
    }

    /**
     * Create an instance of {@link CTTextBulletSizePercent }
     * 
     */
    public CTTextBulletSizePercent createCTTextBulletSizePercent() {
        return new CTTextBulletSizePercent();
    }

    /**
     * Create an instance of {@link CTTextBulletSizePoint }
     * 
     */
    public CTTextBulletSizePoint createCTTextBulletSizePoint() {
        return new CTTextBulletSizePoint();
    }

    /**
     * Create an instance of {@link CTTextBulletTypefaceFollowText }
     * 
     */
    public CTTextBulletTypefaceFollowText createCTTextBulletTypefaceFollowText() {
        return new CTTextBulletTypefaceFollowText();
    }

    /**
     * Create an instance of {@link CTTextAutonumberBullet }
     * 
     */
    public CTTextAutonumberBullet createCTTextAutonumberBullet() {
        return new CTTextAutonumberBullet();
    }

    /**
     * Create an instance of {@link CTTextCharBullet }
     * 
     */
    public CTTextCharBullet createCTTextCharBullet() {
        return new CTTextCharBullet();
    }

    /**
     * Create an instance of {@link CTTextBlipBullet }
     * 
     */
    public CTTextBlipBullet createCTTextBlipBullet() {
        return new CTTextBlipBullet();
    }

    /**
     * Create an instance of {@link CTTextNoBullet }
     * 
     */
    public CTTextNoBullet createCTTextNoBullet() {
        return new CTTextNoBullet();
    }

    /**
     * Create an instance of {@link CTRegularTextRun }
     * 
     */
    public CTRegularTextRun createCTRegularTextRun() {
        return new CTRegularTextRun();
    }

    /**
     * Create an instance of {@link CTTextSpacingPercent }
     * 
     */
    public CTTextSpacingPercent createCTTextSpacingPercent() {
        return new CTTextSpacingPercent();
    }

    /**
     * Create an instance of {@link CTTextSpacingPoint }
     * 
     */
    public CTTextSpacingPoint createCTTextSpacingPoint() {
        return new CTTextSpacingPoint();
    }

    /**
     * Create an instance of {@link CTTextTabStop }
     * 
     */
    public CTTextTabStop createCTTextTabStop() {
        return new CTTextTabStop();
    }

    /**
     * Create an instance of {@link CTTextTabStopList }
     * 
     */
    public CTTextTabStopList createCTTextTabStopList() {
        return new CTTextTabStopList();
    }

    /**
     * Create an instance of {@link CTTextLineBreak }
     * 
     */
    public CTTextLineBreak createCTTextLineBreak() {
        return new CTTextLineBreak();
    }

    /**
     * Create an instance of {@link CTTextSpacing }
     * 
     */
    public CTTextSpacing createCTTextSpacing() {
        return new CTTextSpacing();
    }

    /**
     * Create an instance of {@link CTTextParagraphProperties }
     * 
     */
    public CTTextParagraphProperties createCTTextParagraphProperties() {
        return new CTTextParagraphProperties();
    }

    /**
     * Create an instance of {@link CTTextField }
     * 
     */
    public CTTextField createCTTextField() {
        return new CTTextField();
    }

    /**
     * Create an instance of {@link CTTextParagraph }
     * 
     */
    public CTTextParagraph createCTTextParagraph() {
        return new CTTextParagraph();
    }

    /**
     * Create an instance of {@link CTTextListStyle }
     * 
     */
    public CTTextListStyle createCTTextListStyle() {
        return new CTTextListStyle();
    }

    /**
     * Create an instance of {@link CTTextNormalAutofit }
     * 
     */
    public CTTextNormalAutofit createCTTextNormalAutofit() {
        return new CTTextNormalAutofit();
    }

    /**
     * Create an instance of {@link CTTextShapeAutofit }
     * 
     */
    public CTTextShapeAutofit createCTTextShapeAutofit() {
        return new CTTextShapeAutofit();
    }

    /**
     * Create an instance of {@link CTTextNoAutofit }
     * 
     */
    public CTTextNoAutofit createCTTextNoAutofit() {
        return new CTTextNoAutofit();
    }

    /**
     * Create an instance of {@link CTTextBodyProperties }
     * 
     */
    public CTTextBodyProperties createCTTextBodyProperties() {
        return new CTTextBodyProperties();
    }

    /**
     * Create an instance of {@link CTTextBody }
     * 
     */
    public CTTextBody createCTTextBody() {
        return new CTTextBody();
    }

    /**
     * Create an instance of {@link CTStyleMatrixReference }
     * 
     */
    public CTStyleMatrixReference createCTStyleMatrixReference() {
        return new CTStyleMatrixReference();
    }

    /**
     * Create an instance of {@link CTFontReference }
     * 
     */
    public CTFontReference createCTFontReference() {
        return new CTFontReference();
    }

    /**
     * Create an instance of {@link CTShapeStyle }
     * 
     */
    public CTShapeStyle createCTShapeStyle() {
        return new CTShapeStyle();
    }

    /**
     * Create an instance of {@link CTDefaultShapeDefinition }
     * 
     */
    public CTDefaultShapeDefinition createCTDefaultShapeDefinition() {
        return new CTDefaultShapeDefinition();
    }

    /**
     * Create an instance of {@link CTColorMapping }
     * 
     */
    public CTColorMapping createCTColorMapping() {
        return new CTColorMapping();
    }

    /**
     * Create an instance of {@link CTColorMappingOverride }
     * 
     */
    public CTColorMappingOverride createCTColorMappingOverride() {
        return new CTColorMappingOverride();
    }

    /**
     * Create an instance of {@link CTColorSchemeAndMapping }
     * 
     */
    public CTColorSchemeAndMapping createCTColorSchemeAndMapping() {
        return new CTColorSchemeAndMapping();
    }

    /**
     * Create an instance of {@link CTClipboardStyleSheet }
     * 
     */
    public CTClipboardStyleSheet createCTClipboardStyleSheet() {
        return new CTClipboardStyleSheet();
    }

    /**
     * Create an instance of {@link CTConnectorLocking }
     * 
     */
    public CTConnectorLocking createCTConnectorLocking() {
        return new CTConnectorLocking();
    }

    /**
     * Create an instance of {@link CTShapeLocking }
     * 
     */
    public CTShapeLocking createCTShapeLocking() {
        return new CTShapeLocking();
    }

    /**
     * Create an instance of {@link CTPictureLocking }
     * 
     */
    public CTPictureLocking createCTPictureLocking() {
        return new CTPictureLocking();
    }

    /**
     * Create an instance of {@link CTGroupLocking }
     * 
     */
    public CTGroupLocking createCTGroupLocking() {
        return new CTGroupLocking();
    }

    /**
     * Create an instance of {@link CTGraphicalObjectFrameLocking }
     * 
     */
    public CTGraphicalObjectFrameLocking createCTGraphicalObjectFrameLocking() {
        return new CTGraphicalObjectFrameLocking();
    }

    /**
     * Create an instance of {@link CTNonVisualDrawingProps }
     * 
     */
    public CTNonVisualDrawingProps createCTNonVisualDrawingProps() {
        return new CTNonVisualDrawingProps();
    }

    /**
     * Create an instance of {@link CTNonVisualDrawingShapeProps }
     * 
     */
    public CTNonVisualDrawingShapeProps createCTNonVisualDrawingShapeProps() {
        return new CTNonVisualDrawingShapeProps();
    }

    /**
     * Create an instance of {@link CTNonVisualConnectorProperties }
     * 
     */
    public CTNonVisualConnectorProperties createCTNonVisualConnectorProperties() {
        return new CTNonVisualConnectorProperties();
    }

    /**
     * Create an instance of {@link CTNonVisualPictureProperties }
     * 
     */
    public CTNonVisualPictureProperties createCTNonVisualPictureProperties() {
        return new CTNonVisualPictureProperties();
    }

    /**
     * Create an instance of {@link CTNonVisualGroupDrawingShapeProps }
     * 
     */
    public CTNonVisualGroupDrawingShapeProps createCTNonVisualGroupDrawingShapeProps() {
        return new CTNonVisualGroupDrawingShapeProps();
    }

    /**
     * Create an instance of {@link CTNonVisualGraphicFrameProperties }
     * 
     */
    public CTNonVisualGraphicFrameProperties createCTNonVisualGraphicFrameProperties() {
        return new CTNonVisualGraphicFrameProperties();
    }

    /**
     * Create an instance of {@link GraphicData }
     * 
     */
    public GraphicData createGraphicData() {
        return new GraphicData();
    }

    /**
     * Create an instance of {@link CTBackgroundFormatting }
     * 
     */
    public CTBackgroundFormatting createCTBackgroundFormatting() {
        return new CTBackgroundFormatting();
    }

    /**
     * Create an instance of {@link CTWholeE2OFormatting }
     * 
     */
    public CTWholeE2OFormatting createCTWholeE2OFormatting() {
        return new CTWholeE2OFormatting();
    }

    /**
     * Create an instance of {@link CTAnimationDgmElement }
     * 
     */
    public CTAnimationDgmElement createCTAnimationDgmElement() {
        return new CTAnimationDgmElement();
    }

    /**
     * Create an instance of {@link CTAnimationChartElement }
     * 
     */
    public CTAnimationChartElement createCTAnimationChartElement() {
        return new CTAnimationChartElement();
    }

    /**
     * Create an instance of {@link CTAnimationElementChoice }
     * 
     */
    public CTAnimationElementChoice createCTAnimationElementChoice() {
        return new CTAnimationElementChoice();
    }

    /**
     * Create an instance of {@link CTAnimationDgmBuildProperties }
     * 
     */
    public CTAnimationDgmBuildProperties createCTAnimationDgmBuildProperties() {
        return new CTAnimationDgmBuildProperties();
    }

    /**
     * Create an instance of {@link CTAnimationChartBuildProperties }
     * 
     */
    public CTAnimationChartBuildProperties createCTAnimationChartBuildProperties() {
        return new CTAnimationChartBuildProperties();
    }

    /**
     * Create an instance of {@link CTAnimationGraphicalObjectBuildProperties }
     * 
     */
    public CTAnimationGraphicalObjectBuildProperties createCTAnimationGraphicalObjectBuildProperties() {
        return new CTAnimationGraphicalObjectBuildProperties();
    }

    /**
     * Create an instance of {@link CTGvmlUseShapeRectangle }
     * 
     */
    public CTGvmlUseShapeRectangle createCTGvmlUseShapeRectangle() {
        return new CTGvmlUseShapeRectangle();
    }

    /**
     * Create an instance of {@link CTGvmlTextShape }
     * 
     */
    public CTGvmlTextShape createCTGvmlTextShape() {
        return new CTGvmlTextShape();
    }

    /**
     * Create an instance of {@link CTGvmlShapeNonVisual }
     * 
     */
    public CTGvmlShapeNonVisual createCTGvmlShapeNonVisual() {
        return new CTGvmlShapeNonVisual();
    }

    /**
     * Create an instance of {@link CTGvmlShape }
     * 
     */
    public CTGvmlShape createCTGvmlShape() {
        return new CTGvmlShape();
    }

    /**
     * Create an instance of {@link CTGvmlConnectorNonVisual }
     * 
     */
    public CTGvmlConnectorNonVisual createCTGvmlConnectorNonVisual() {
        return new CTGvmlConnectorNonVisual();
    }

    /**
     * Create an instance of {@link CTGvmlConnector }
     * 
     */
    public CTGvmlConnector createCTGvmlConnector() {
        return new CTGvmlConnector();
    }

    /**
     * Create an instance of {@link CTGvmlPictureNonVisual }
     * 
     */
    public CTGvmlPictureNonVisual createCTGvmlPictureNonVisual() {
        return new CTGvmlPictureNonVisual();
    }

    /**
     * Create an instance of {@link CTGvmlPicture }
     * 
     */
    public CTGvmlPicture createCTGvmlPicture() {
        return new CTGvmlPicture();
    }

    /**
     * Create an instance of {@link CTGvmlGraphicFrameNonVisual }
     * 
     */
    public CTGvmlGraphicFrameNonVisual createCTGvmlGraphicFrameNonVisual() {
        return new CTGvmlGraphicFrameNonVisual();
    }

    /**
     * Create an instance of {@link CTGvmlGraphicalObjectFrame }
     * 
     */
    public CTGvmlGraphicalObjectFrame createCTGvmlGraphicalObjectFrame() {
        return new CTGvmlGraphicalObjectFrame();
    }

    /**
     * Create an instance of {@link CTGvmlGroupShapeNonVisual }
     * 
     */
    public CTGvmlGroupShapeNonVisual createCTGvmlGroupShapeNonVisual() {
        return new CTGvmlGroupShapeNonVisual();
    }

    /**
     * Create an instance of {@link CTGvmlGroupShape }
     * 
     */
    public CTGvmlGroupShape createCTGvmlGroupShape() {
        return new CTGvmlGroupShape();
    }

    /**
     * Create an instance of {@link CTCell3D }
     * 
     */
    public CTCell3D createCTCell3D() {
        return new CTCell3D();
    }

    /**
     * Create an instance of {@link CTThemeableLineStyle }
     * 
     */
    public CTThemeableLineStyle createCTThemeableLineStyle() {
        return new CTThemeableLineStyle();
    }

    /**
     * Create an instance of {@link CTTableStyleTextStyle }
     * 
     */
    public CTTableStyleTextStyle createCTTableStyleTextStyle() {
        return new CTTableStyleTextStyle();
    }

    /**
     * Create an instance of {@link CTTableCellBorderStyle }
     * 
     */
    public CTTableCellBorderStyle createCTTableCellBorderStyle() {
        return new CTTableCellBorderStyle();
    }

    /**
     * Create an instance of {@link CTTableBackgroundStyle }
     * 
     */
    public CTTableBackgroundStyle createCTTableBackgroundStyle() {
        return new CTTableBackgroundStyle();
    }

    /**
     * Create an instance of {@link CTTableStyleCellStyle }
     * 
     */
    public CTTableStyleCellStyle createCTTableStyleCellStyle() {
        return new CTTableStyleCellStyle();
    }

    /**
     * Create an instance of {@link CTTablePartStyle }
     * 
     */
    public CTTablePartStyle createCTTablePartStyle() {
        return new CTTablePartStyle();
    }

    /**
     * Create an instance of {@link CTTableStyle }
     * 
     */
    public CTTableStyle createCTTableStyle() {
        return new CTTableStyle();
    }

    /**
     * Create an instance of {@link CTTableCellProperties }
     * 
     */
    public CTTableCellProperties createCTTableCellProperties() {
        return new CTTableCellProperties();
    }

    /**
     * Create an instance of {@link CTTableCol }
     * 
     */
    public CTTableCol createCTTableCol() {
        return new CTTableCol();
    }

    /**
     * Create an instance of {@link CTTableGrid }
     * 
     */
    public CTTableGrid createCTTableGrid() {
        return new CTTableGrid();
    }

    /**
     * Create an instance of {@link CTTableCell }
     * 
     */
    public CTTableCell createCTTableCell() {
        return new CTTableCell();
    }

    /**
     * Create an instance of {@link CTTableRow }
     * 
     */
    public CTTableRow createCTTableRow() {
        return new CTTableRow();
    }

    /**
     * Create an instance of {@link CTTableProperties }
     * 
     */
    public CTTableProperties createCTTableProperties() {
        return new CTTableProperties();
    }

    /**
     * Create an instance of {@link FontCollection.Font }
     * 
     */
    public FontCollection.Font createFontCollectionFont() {
        return new FontCollection.Font();
    }

    /**
     * Create an instance of {@link CTBaseStylesOverride.FontScheme }
     * 
     */
    public CTBaseStylesOverride.FontScheme createCTBaseStylesOverrideFontScheme() {
        return new CTBaseStylesOverride.FontScheme();
    }

    /**
     * Create an instance of {@link BaseStyles.FontScheme }
     * 
     */
    public BaseStyles.FontScheme createBaseStylesFontScheme() {
        return new BaseStyles.FontScheme();
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBlip }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blip")
    public JAXBElement<CTBlip> createBlip(CTBlip value) {
        return new JAXBElement<CTBlip>(_Blip_QNAME, CTBlip.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTBaseStylesOverride }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "themeOverride")
    public JAXBElement<CTBaseStylesOverride> createThemeOverride(CTBaseStylesOverride value) {
        return new JAXBElement<CTBaseStylesOverride>(_ThemeOverride_QNAME, CTBaseStylesOverride.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTEmptyElement }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "themeManager")
    public JAXBElement<CTEmptyElement> createThemeManager(CTEmptyElement value) {
        return new JAXBElement<CTEmptyElement>(_ThemeManager_QNAME, CTEmptyElement.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link Graphic }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "graphic")
    public JAXBElement<Graphic> createGraphic(Graphic value) {
        return new JAXBElement<Graphic>(_Graphic_QNAME, Graphic.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTTableStyleList }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "tblStyleLst")
    public JAXBElement<CTTableStyleList> createTblStyleLst(CTTableStyleList value) {
        return new JAXBElement<CTTableStyleList>(_TblStyleLst_QNAME, CTTableStyleList.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTTable }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "tbl")
    public JAXBElement<CTTable> createTbl(CTTable value) {
        return new JAXBElement<CTTable>(_Tbl_QNAME, CTTable.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "tint", scope = CTPresetColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTPresetColorTint(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorTint_QNAME, CTPositiveFixedPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "shade", scope = CTPresetColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTPresetColorShade(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorShade_QNAME, CTPositiveFixedPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTComplementTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "comp", scope = CTPresetColor.class)
    public JAXBElement<CTComplementTransform> createCTPresetColorComp(CTComplementTransform value) {
        return new JAXBElement<CTComplementTransform>(_CTPresetColorComp_QNAME, CTComplementTransform.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "inv", scope = CTPresetColor.class)
    public JAXBElement<CTInverseTransform> createCTPresetColorInv(CTInverseTransform value) {
        return new JAXBElement<CTInverseTransform>(_CTPresetColorInv_QNAME, CTInverseTransform.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGrayscaleTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gray", scope = CTPresetColor.class)
    public JAXBElement<CTGrayscaleTransform> createCTPresetColorGray(CTGrayscaleTransform value) {
        return new JAXBElement<CTGrayscaleTransform>(_CTPresetColorGray_QNAME, CTGrayscaleTransform.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alpha", scope = CTPresetColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTPresetColorAlpha(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorAlpha_QNAME, CTPositiveFixedPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaOff", scope = CTPresetColor.class)
    public JAXBElement<CTFixedPercentage> createCTPresetColorAlphaOff(CTFixedPercentage value) {
        return new JAXBElement<CTFixedPercentage>(_CTPresetColorAlphaOff_QNAME, CTFixedPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaMod", scope = CTPresetColor.class)
    public JAXBElement<CTPositivePercentage> createCTPresetColorAlphaMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorAlphaMod_QNAME, CTPositivePercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hue", scope = CTPresetColor.class)
    public JAXBElement<CTPositiveFixedAngle> createCTPresetColorHue(CTPositiveFixedAngle value) {
        return new JAXBElement<CTPositiveFixedAngle>(_CTPresetColorHue_QNAME, CTPositiveFixedAngle.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueOff", scope = CTPresetColor.class)
    public JAXBElement<CTAngle> createCTPresetColorHueOff(CTAngle value) {
        return new JAXBElement<CTAngle>(_CTPresetColorHueOff_QNAME, CTAngle.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueMod", scope = CTPresetColor.class)
    public JAXBElement<CTPositivePercentage> createCTPresetColorHueMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorHueMod_QNAME, CTPositivePercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "sat", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorSat(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSat_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satOff", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorSatOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatOff_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satMod", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorSatMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatMod_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lum", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorLum(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLum_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumOff", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorLumOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumOff_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumMod", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorLumMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumMod_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "red", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorRed(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRed_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redOff", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorRedOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedOff_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redMod", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorRedMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedMod_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "green", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorGreen(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreen_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenOff", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorGreenOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenOff_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenMod", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorGreenMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenMod_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blue", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorBlue(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlue_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueOff", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorBlueOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueOff_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueMod", scope = CTPresetColor.class)
    public JAXBElement<CTPercentage> createCTPresetColorBlueMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueMod_QNAME, CTPercentage.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gamma", scope = CTPresetColor.class)
    public JAXBElement<CTGammaTransform> createCTPresetColorGamma(CTGammaTransform value) {
        return new JAXBElement<CTGammaTransform>(_CTPresetColorGamma_QNAME, CTGammaTransform.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "invGamma", scope = CTPresetColor.class)
    public JAXBElement<CTInverseGammaTransform> createCTPresetColorInvGamma(CTInverseGammaTransform value) {
        return new JAXBElement<CTInverseGammaTransform>(_CTPresetColorInvGamma_QNAME, CTInverseGammaTransform.class, CTPresetColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "tint", scope = CTSchemeColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSchemeColorTint(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorTint_QNAME, CTPositiveFixedPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "shade", scope = CTSchemeColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSchemeColorShade(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorShade_QNAME, CTPositiveFixedPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTComplementTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "comp", scope = CTSchemeColor.class)
    public JAXBElement<CTComplementTransform> createCTSchemeColorComp(CTComplementTransform value) {
        return new JAXBElement<CTComplementTransform>(_CTPresetColorComp_QNAME, CTComplementTransform.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "inv", scope = CTSchemeColor.class)
    public JAXBElement<CTInverseTransform> createCTSchemeColorInv(CTInverseTransform value) {
        return new JAXBElement<CTInverseTransform>(_CTPresetColorInv_QNAME, CTInverseTransform.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGrayscaleTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gray", scope = CTSchemeColor.class)
    public JAXBElement<CTGrayscaleTransform> createCTSchemeColorGray(CTGrayscaleTransform value) {
        return new JAXBElement<CTGrayscaleTransform>(_CTPresetColorGray_QNAME, CTGrayscaleTransform.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alpha", scope = CTSchemeColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSchemeColorAlpha(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorAlpha_QNAME, CTPositiveFixedPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaOff", scope = CTSchemeColor.class)
    public JAXBElement<CTFixedPercentage> createCTSchemeColorAlphaOff(CTFixedPercentage value) {
        return new JAXBElement<CTFixedPercentage>(_CTPresetColorAlphaOff_QNAME, CTFixedPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaMod", scope = CTSchemeColor.class)
    public JAXBElement<CTPositivePercentage> createCTSchemeColorAlphaMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorAlphaMod_QNAME, CTPositivePercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hue", scope = CTSchemeColor.class)
    public JAXBElement<CTPositiveFixedAngle> createCTSchemeColorHue(CTPositiveFixedAngle value) {
        return new JAXBElement<CTPositiveFixedAngle>(_CTPresetColorHue_QNAME, CTPositiveFixedAngle.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueOff", scope = CTSchemeColor.class)
    public JAXBElement<CTAngle> createCTSchemeColorHueOff(CTAngle value) {
        return new JAXBElement<CTAngle>(_CTPresetColorHueOff_QNAME, CTAngle.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueMod", scope = CTSchemeColor.class)
    public JAXBElement<CTPositivePercentage> createCTSchemeColorHueMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorHueMod_QNAME, CTPositivePercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "sat", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorSat(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSat_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satOff", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorSatOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatOff_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satMod", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorSatMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatMod_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lum", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorLum(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLum_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumOff", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorLumOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumOff_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumMod", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorLumMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumMod_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "red", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorRed(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRed_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redOff", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorRedOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedOff_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redMod", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorRedMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedMod_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "green", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorGreen(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreen_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenOff", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorGreenOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenOff_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenMod", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorGreenMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenMod_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blue", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorBlue(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlue_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueOff", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorBlueOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueOff_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueMod", scope = CTSchemeColor.class)
    public JAXBElement<CTPercentage> createCTSchemeColorBlueMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueMod_QNAME, CTPercentage.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gamma", scope = CTSchemeColor.class)
    public JAXBElement<CTGammaTransform> createCTSchemeColorGamma(CTGammaTransform value) {
        return new JAXBElement<CTGammaTransform>(_CTPresetColorGamma_QNAME, CTGammaTransform.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "invGamma", scope = CTSchemeColor.class)
    public JAXBElement<CTInverseGammaTransform> createCTSchemeColorInvGamma(CTInverseGammaTransform value) {
        return new JAXBElement<CTInverseGammaTransform>(_CTPresetColorInvGamma_QNAME, CTInverseGammaTransform.class, CTSchemeColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "tint", scope = CTSystemColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSystemColorTint(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorTint_QNAME, CTPositiveFixedPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "shade", scope = CTSystemColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSystemColorShade(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorShade_QNAME, CTPositiveFixedPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTComplementTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "comp", scope = CTSystemColor.class)
    public JAXBElement<CTComplementTransform> createCTSystemColorComp(CTComplementTransform value) {
        return new JAXBElement<CTComplementTransform>(_CTPresetColorComp_QNAME, CTComplementTransform.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "inv", scope = CTSystemColor.class)
    public JAXBElement<CTInverseTransform> createCTSystemColorInv(CTInverseTransform value) {
        return new JAXBElement<CTInverseTransform>(_CTPresetColorInv_QNAME, CTInverseTransform.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGrayscaleTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gray", scope = CTSystemColor.class)
    public JAXBElement<CTGrayscaleTransform> createCTSystemColorGray(CTGrayscaleTransform value) {
        return new JAXBElement<CTGrayscaleTransform>(_CTPresetColorGray_QNAME, CTGrayscaleTransform.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alpha", scope = CTSystemColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSystemColorAlpha(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorAlpha_QNAME, CTPositiveFixedPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaOff", scope = CTSystemColor.class)
    public JAXBElement<CTFixedPercentage> createCTSystemColorAlphaOff(CTFixedPercentage value) {
        return new JAXBElement<CTFixedPercentage>(_CTPresetColorAlphaOff_QNAME, CTFixedPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaMod", scope = CTSystemColor.class)
    public JAXBElement<CTPositivePercentage> createCTSystemColorAlphaMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorAlphaMod_QNAME, CTPositivePercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hue", scope = CTSystemColor.class)
    public JAXBElement<CTPositiveFixedAngle> createCTSystemColorHue(CTPositiveFixedAngle value) {
        return new JAXBElement<CTPositiveFixedAngle>(_CTPresetColorHue_QNAME, CTPositiveFixedAngle.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueOff", scope = CTSystemColor.class)
    public JAXBElement<CTAngle> createCTSystemColorHueOff(CTAngle value) {
        return new JAXBElement<CTAngle>(_CTPresetColorHueOff_QNAME, CTAngle.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueMod", scope = CTSystemColor.class)
    public JAXBElement<CTPositivePercentage> createCTSystemColorHueMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorHueMod_QNAME, CTPositivePercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "sat", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorSat(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSat_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satOff", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorSatOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatOff_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satMod", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorSatMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatMod_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lum", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorLum(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLum_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumOff", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorLumOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumOff_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumMod", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorLumMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumMod_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "red", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorRed(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRed_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redOff", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorRedOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedOff_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redMod", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorRedMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedMod_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "green", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorGreen(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreen_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenOff", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorGreenOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenOff_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenMod", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorGreenMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenMod_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blue", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorBlue(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlue_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueOff", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorBlueOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueOff_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueMod", scope = CTSystemColor.class)
    public JAXBElement<CTPercentage> createCTSystemColorBlueMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueMod_QNAME, CTPercentage.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gamma", scope = CTSystemColor.class)
    public JAXBElement<CTGammaTransform> createCTSystemColorGamma(CTGammaTransform value) {
        return new JAXBElement<CTGammaTransform>(_CTPresetColorGamma_QNAME, CTGammaTransform.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "invGamma", scope = CTSystemColor.class)
    public JAXBElement<CTInverseGammaTransform> createCTSystemColorInvGamma(CTInverseGammaTransform value) {
        return new JAXBElement<CTInverseGammaTransform>(_CTPresetColorInvGamma_QNAME, CTInverseGammaTransform.class, CTSystemColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "tint", scope = CTHslColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTHslColorTint(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorTint_QNAME, CTPositiveFixedPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "shade", scope = CTHslColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTHslColorShade(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorShade_QNAME, CTPositiveFixedPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTComplementTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "comp", scope = CTHslColor.class)
    public JAXBElement<CTComplementTransform> createCTHslColorComp(CTComplementTransform value) {
        return new JAXBElement<CTComplementTransform>(_CTPresetColorComp_QNAME, CTComplementTransform.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "inv", scope = CTHslColor.class)
    public JAXBElement<CTInverseTransform> createCTHslColorInv(CTInverseTransform value) {
        return new JAXBElement<CTInverseTransform>(_CTPresetColorInv_QNAME, CTInverseTransform.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGrayscaleTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gray", scope = CTHslColor.class)
    public JAXBElement<CTGrayscaleTransform> createCTHslColorGray(CTGrayscaleTransform value) {
        return new JAXBElement<CTGrayscaleTransform>(_CTPresetColorGray_QNAME, CTGrayscaleTransform.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alpha", scope = CTHslColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTHslColorAlpha(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorAlpha_QNAME, CTPositiveFixedPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaOff", scope = CTHslColor.class)
    public JAXBElement<CTFixedPercentage> createCTHslColorAlphaOff(CTFixedPercentage value) {
        return new JAXBElement<CTFixedPercentage>(_CTPresetColorAlphaOff_QNAME, CTFixedPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaMod", scope = CTHslColor.class)
    public JAXBElement<CTPositivePercentage> createCTHslColorAlphaMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorAlphaMod_QNAME, CTPositivePercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hue", scope = CTHslColor.class)
    public JAXBElement<CTPositiveFixedAngle> createCTHslColorHue(CTPositiveFixedAngle value) {
        return new JAXBElement<CTPositiveFixedAngle>(_CTPresetColorHue_QNAME, CTPositiveFixedAngle.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueOff", scope = CTHslColor.class)
    public JAXBElement<CTAngle> createCTHslColorHueOff(CTAngle value) {
        return new JAXBElement<CTAngle>(_CTPresetColorHueOff_QNAME, CTAngle.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueMod", scope = CTHslColor.class)
    public JAXBElement<CTPositivePercentage> createCTHslColorHueMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorHueMod_QNAME, CTPositivePercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "sat", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorSat(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSat_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satOff", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorSatOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatOff_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satMod", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorSatMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatMod_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lum", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorLum(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLum_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumOff", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorLumOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumOff_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumMod", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorLumMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumMod_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "red", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorRed(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRed_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redOff", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorRedOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedOff_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redMod", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorRedMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedMod_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "green", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorGreen(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreen_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenOff", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorGreenOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenOff_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenMod", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorGreenMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenMod_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blue", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorBlue(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlue_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueOff", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorBlueOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueOff_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueMod", scope = CTHslColor.class)
    public JAXBElement<CTPercentage> createCTHslColorBlueMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueMod_QNAME, CTPercentage.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gamma", scope = CTHslColor.class)
    public JAXBElement<CTGammaTransform> createCTHslColorGamma(CTGammaTransform value) {
        return new JAXBElement<CTGammaTransform>(_CTPresetColorGamma_QNAME, CTGammaTransform.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "invGamma", scope = CTHslColor.class)
    public JAXBElement<CTInverseGammaTransform> createCTHslColorInvGamma(CTInverseGammaTransform value) {
        return new JAXBElement<CTInverseGammaTransform>(_CTPresetColorInvGamma_QNAME, CTInverseGammaTransform.class, CTHslColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "tint", scope = CTSRgbColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSRgbColorTint(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorTint_QNAME, CTPositiveFixedPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "shade", scope = CTSRgbColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSRgbColorShade(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorShade_QNAME, CTPositiveFixedPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTComplementTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "comp", scope = CTSRgbColor.class)
    public JAXBElement<CTComplementTransform> createCTSRgbColorComp(CTComplementTransform value) {
        return new JAXBElement<CTComplementTransform>(_CTPresetColorComp_QNAME, CTComplementTransform.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "inv", scope = CTSRgbColor.class)
    public JAXBElement<CTInverseTransform> createCTSRgbColorInv(CTInverseTransform value) {
        return new JAXBElement<CTInverseTransform>(_CTPresetColorInv_QNAME, CTInverseTransform.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGrayscaleTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gray", scope = CTSRgbColor.class)
    public JAXBElement<CTGrayscaleTransform> createCTSRgbColorGray(CTGrayscaleTransform value) {
        return new JAXBElement<CTGrayscaleTransform>(_CTPresetColorGray_QNAME, CTGrayscaleTransform.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alpha", scope = CTSRgbColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTSRgbColorAlpha(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorAlpha_QNAME, CTPositiveFixedPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaOff", scope = CTSRgbColor.class)
    public JAXBElement<CTFixedPercentage> createCTSRgbColorAlphaOff(CTFixedPercentage value) {
        return new JAXBElement<CTFixedPercentage>(_CTPresetColorAlphaOff_QNAME, CTFixedPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaMod", scope = CTSRgbColor.class)
    public JAXBElement<CTPositivePercentage> createCTSRgbColorAlphaMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorAlphaMod_QNAME, CTPositivePercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hue", scope = CTSRgbColor.class)
    public JAXBElement<CTPositiveFixedAngle> createCTSRgbColorHue(CTPositiveFixedAngle value) {
        return new JAXBElement<CTPositiveFixedAngle>(_CTPresetColorHue_QNAME, CTPositiveFixedAngle.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueOff", scope = CTSRgbColor.class)
    public JAXBElement<CTAngle> createCTSRgbColorHueOff(CTAngle value) {
        return new JAXBElement<CTAngle>(_CTPresetColorHueOff_QNAME, CTAngle.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueMod", scope = CTSRgbColor.class)
    public JAXBElement<CTPositivePercentage> createCTSRgbColorHueMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorHueMod_QNAME, CTPositivePercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "sat", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorSat(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSat_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satOff", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorSatOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatOff_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satMod", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorSatMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatMod_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lum", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorLum(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLum_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumOff", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorLumOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumOff_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumMod", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorLumMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumMod_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "red", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorRed(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRed_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redOff", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorRedOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedOff_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redMod", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorRedMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedMod_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "green", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorGreen(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreen_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenOff", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorGreenOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenOff_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenMod", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorGreenMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenMod_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blue", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorBlue(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlue_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueOff", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorBlueOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueOff_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueMod", scope = CTSRgbColor.class)
    public JAXBElement<CTPercentage> createCTSRgbColorBlueMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueMod_QNAME, CTPercentage.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gamma", scope = CTSRgbColor.class)
    public JAXBElement<CTGammaTransform> createCTSRgbColorGamma(CTGammaTransform value) {
        return new JAXBElement<CTGammaTransform>(_CTPresetColorGamma_QNAME, CTGammaTransform.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "invGamma", scope = CTSRgbColor.class)
    public JAXBElement<CTInverseGammaTransform> createCTSRgbColorInvGamma(CTInverseGammaTransform value) {
        return new JAXBElement<CTInverseGammaTransform>(_CTPresetColorInvGamma_QNAME, CTInverseGammaTransform.class, CTSRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "tint", scope = CTScRgbColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTScRgbColorTint(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorTint_QNAME, CTPositiveFixedPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "shade", scope = CTScRgbColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTScRgbColorShade(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorShade_QNAME, CTPositiveFixedPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTComplementTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "comp", scope = CTScRgbColor.class)
    public JAXBElement<CTComplementTransform> createCTScRgbColorComp(CTComplementTransform value) {
        return new JAXBElement<CTComplementTransform>(_CTPresetColorComp_QNAME, CTComplementTransform.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "inv", scope = CTScRgbColor.class)
    public JAXBElement<CTInverseTransform> createCTScRgbColorInv(CTInverseTransform value) {
        return new JAXBElement<CTInverseTransform>(_CTPresetColorInv_QNAME, CTInverseTransform.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGrayscaleTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gray", scope = CTScRgbColor.class)
    public JAXBElement<CTGrayscaleTransform> createCTScRgbColorGray(CTGrayscaleTransform value) {
        return new JAXBElement<CTGrayscaleTransform>(_CTPresetColorGray_QNAME, CTGrayscaleTransform.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alpha", scope = CTScRgbColor.class)
    public JAXBElement<CTPositiveFixedPercentage> createCTScRgbColorAlpha(CTPositiveFixedPercentage value) {
        return new JAXBElement<CTPositiveFixedPercentage>(_CTPresetColorAlpha_QNAME, CTPositiveFixedPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFixedPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaOff", scope = CTScRgbColor.class)
    public JAXBElement<CTFixedPercentage> createCTScRgbColorAlphaOff(CTFixedPercentage value) {
        return new JAXBElement<CTFixedPercentage>(_CTPresetColorAlphaOff_QNAME, CTFixedPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "alphaMod", scope = CTScRgbColor.class)
    public JAXBElement<CTPositivePercentage> createCTScRgbColorAlphaMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorAlphaMod_QNAME, CTPositivePercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositiveFixedAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hue", scope = CTScRgbColor.class)
    public JAXBElement<CTPositiveFixedAngle> createCTScRgbColorHue(CTPositiveFixedAngle value) {
        return new JAXBElement<CTPositiveFixedAngle>(_CTPresetColorHue_QNAME, CTPositiveFixedAngle.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTAngle }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueOff", scope = CTScRgbColor.class)
    public JAXBElement<CTAngle> createCTScRgbColorHueOff(CTAngle value) {
        return new JAXBElement<CTAngle>(_CTPresetColorHueOff_QNAME, CTAngle.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPositivePercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "hueMod", scope = CTScRgbColor.class)
    public JAXBElement<CTPositivePercentage> createCTScRgbColorHueMod(CTPositivePercentage value) {
        return new JAXBElement<CTPositivePercentage>(_CTPresetColorHueMod_QNAME, CTPositivePercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "sat", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorSat(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSat_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satOff", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorSatOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatOff_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "satMod", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorSatMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorSatMod_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lum", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorLum(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLum_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumOff", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorLumOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumOff_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "lumMod", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorLumMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorLumMod_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "red", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorRed(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRed_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redOff", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorRedOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedOff_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "redMod", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorRedMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorRedMod_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "green", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorGreen(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreen_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenOff", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorGreenOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenOff_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "greenMod", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorGreenMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorGreenMod_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blue", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorBlue(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlue_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueOff", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorBlueOff(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueOff_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPercentage }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "blueMod", scope = CTScRgbColor.class)
    public JAXBElement<CTPercentage> createCTScRgbColorBlueMod(CTPercentage value) {
        return new JAXBElement<CTPercentage>(_CTPresetColorBlueMod_QNAME, CTPercentage.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "gamma", scope = CTScRgbColor.class)
    public JAXBElement<CTGammaTransform> createCTScRgbColorGamma(CTGammaTransform value) {
        return new JAXBElement<CTGammaTransform>(_CTPresetColorGamma_QNAME, CTGammaTransform.class, CTScRgbColor.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTInverseGammaTransform }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", name = "invGamma", scope = CTScRgbColor.class)
    public JAXBElement<CTInverseGammaTransform> createCTScRgbColorInvGamma(CTInverseGammaTransform value) {
        return new JAXBElement<CTInverseGammaTransform>(_CTPresetColorInvGamma_QNAME, CTInverseGammaTransform.class, CTScRgbColor.class, value);
    }

}
