/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j.convert.in.xhtml;

import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.render.BlockBox;
import java.util.LinkedList;
import java.util.Map;
import org.docx4j.convert.in.xhtml.DomCssValueAdaptor;
import org.docx4j.dml.CTTextAutonumberBullet;
import org.docx4j.dml.CTTextCharBullet;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.CTTextSpacing;
import org.docx4j.dml.CTTextSpacingPercent;
import org.docx4j.dml.ObjectFactory;
import org.docx4j.dml.STTextAutonumberScheme;
import org.docx4j.dml.TextFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ListHelper {
    public static Logger log = LoggerFactory.getLogger(ListHelper.class);
    private static ObjectFactory dmlObjectFactory = new ObjectFactory();
    protected static final int INDENT_AFTER = 360;
    private LinkedList<BlockBox> listStack = new LinkedList();

    protected void pushListStack(BlockBox ca) {
        this.listStack.push(ca);
    }

    protected BlockBox popListStack() {
        BlockBox box = this.listStack.pop();
        if (this.listStack.size() == 0) {
            log.debug("outside list");
        }
        return box;
    }

    protected BlockBox peekListStack() {
        return this.listStack.peek();
    }

    protected int getDepth() {
        return this.listStack.size();
    }

    private STTextAutonumberScheme getNumberFormatFromCSSListStyleType(String listStyleType) {
        if (listStyleType.equals("decimal")) {
            return STTextAutonumberScheme.ARABIC_PLAIN;
        }
        if (listStyleType.equals("decimal-leading-zero")) {
            return STTextAutonumberScheme.ARABIC_PLAIN;
        }
        if (listStyleType.equals("lower-roman")) {
            return STTextAutonumberScheme.ROMAN_LC_PAREN_BOTH;
        }
        if (listStyleType.equals("upper-roman")) {
            return STTextAutonumberScheme.ROMAN_UC_PAREN_BOTH;
        }
        if (listStyleType.equals("lower-greek")) {
            return STTextAutonumberScheme.ARABIC_PLAIN;
        }
        if (listStyleType.equals("lower-latin")) {
            return STTextAutonumberScheme.ALPHA_LC_PAREN_BOTH;
        }
        if (listStyleType.equals("upper-latin")) {
            return STTextAutonumberScheme.ALPHA_UC_PAREN_BOTH;
        }
        if (listStyleType.equals("armenian")) {
            return STTextAutonumberScheme.ARABIC_PLAIN;
        }
        if (listStyleType.equals("georgian")) {
            return STTextAutonumberScheme.ARABIC_PLAIN;
        }
        if (listStyleType.equals("lower-alpha")) {
            return STTextAutonumberScheme.ALPHA_LC_PAREN_BOTH;
        }
        if (listStyleType.equals("upper-alpha")) {
            return STTextAutonumberScheme.ALPHA_UC_PAREN_BOTH;
        }
        if (listStyleType.equals("none")) {
            return null;
        }
        if (listStyleType.equals("inherit")) {
            return STTextAutonumberScheme.ARABIC_PLAIN;
        }
        return STTextAutonumberScheme.ARABIC_PLAIN;
    }

    private void addBulletForCSSListStyleType(String listStyleType, CTTextParagraphProperties textparagraphproperties) {
        TextFont textfont = dmlObjectFactory.createTextFont();
        textparagraphproperties.setBuFont(textfont);
        textfont.setTypeface("Arial");
        textfont.setPanose("020B0604020202020204");
        CTTextCharBullet textcharbullet = dmlObjectFactory.createCTTextCharBullet();
        textparagraphproperties.setBuChar(textcharbullet);
        textcharbullet.setChar("\u2022");
        if (listStyleType.equals("disc")) {
            // empty if block
        }
        if (listStyleType.equals("circle")) {
            // empty if block
        }
        if (listStyleType.equals("square")) {
            // empty if block
        }
    }

    void addNumbering(CTTextParagraph textparagraph, Element e, Map<String, PropertyValue> map) {
        log.debug("add");
        CTTextParagraphProperties textparagraphproperties = dmlObjectFactory.createCTTextParagraphProperties();
        textparagraph.setPPr(textparagraphproperties);
        textparagraphproperties.setIndent(new Integer(-171450));
        textparagraphproperties.setLvl(Integer.valueOf(this.getDepth()));
        CTTextSpacing textspacing = dmlObjectFactory.createCTTextSpacing();
        textparagraphproperties.setLnSpc(textspacing);
        CTTextSpacingPercent textspacingpercent = dmlObjectFactory.createCTTextSpacingPercent();
        textspacing.setSpcPct(textspacingpercent);
        textspacingpercent.setVal(110000);
        String listStyleType = null;
        DomCssValueAdaptor cssVal = new DomCssValueAdaptor(map.get("list-style-type"));
        if (cssVal == null) {
            log.debug("No list-style-type found in css for element " + e.getTagName());
        } else {
            listStyleType = cssVal.getCssText();
        }
        if (listStyleType.equals("disc") || listStyleType.equals("circle") || listStyleType.equals("square")) {
            this.addBulletForCSSListStyleType(listStyleType, textparagraphproperties);
            textparagraphproperties.setMarL(new Integer(171450));
        } else {
            CTTextAutonumberBullet textautonumberbullet = dmlObjectFactory.createCTTextAutonumberBullet();
            textparagraphproperties.setBuAutoNum(textautonumberbullet);
            textautonumberbullet.setType(STTextAutonumberScheme.ARABIC_PERIOD);
            textparagraphproperties.setMarL(new Integer(228600));
        }
    }
}

