/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileInputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.CustomXmlDataStoragePartSelector;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.datastorage.OpenDoPEIntegrity;
import org.docx4j.model.datastorage.OpenDoPEReverter;
import org.docx4j.model.datastorage.RemovalHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;

public class ContentControlBindingExtensions {
    public static JAXBContext context = Context.jc;
    static String filepathprefix;

    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/databinding/invoice.docx";
        String data = System.getProperty("user.dir") + "/sample-docs/word/databinding/invoice-data.xml";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(inputfilepath));
        filepathprefix = inputfilepath.substring(0, inputfilepath.lastIndexOf("."));
        System.out.println(filepathprefix);
        StringBuilder timingSummary = new StringBuilder();
        long startTime = System.currentTimeMillis();
        CustomXmlPart customXmlDataStoragePart = CustomXmlDataStoragePartSelector.getCustomXmlDataStoragePart((WordprocessingMLPackage)wordMLPackage);
        if (customXmlDataStoragePart == null) {
            throw new RuntimeException("no xml");
        }
        customXmlDataStoragePart.setXML(XmlUtils.getNewDocumentBuilder().parse(new FileInputStream(new File(data))));
        long endTime = System.currentTimeMillis();
        timingSummary.append("\nmerge data: " + (endTime - startTime));
        System.out.println("data merged");
        SaveToZipFile saver = new SaveToZipFile((OpcPackage)wordMLPackage);
        saver.save(new File(System.getProperty("user.dir") + "/OUT_injected.docx"));
        startTime = System.currentTimeMillis();
        OpenDoPEHandler odh = new OpenDoPEHandler(wordMLPackage);
        odh.preprocess();
        endTime = System.currentTimeMillis();
        timingSummary.append("OpenDoPEHandler: " + (endTime - startTime));
        saver.save(filepathprefix + "_1_preprocessed.docx");
        System.out.println("Saved: " + filepathprefix + "_1_preprocessed.docx");
        startTime = System.currentTimeMillis();
        OpenDoPEIntegrity odi = new OpenDoPEIntegrity();
        odi.process(wordMLPackage);
        endTime = System.currentTimeMillis();
        timingSummary.append("\nOpenDoPEIntegrity: " + (endTime - startTime));
        saver = new SaveToZipFile((OpcPackage)wordMLPackage);
        saver.save(filepathprefix + "_2_integrity.docx");
        System.out.println("Saved: " + filepathprefix + "_2_integrity.docx");
        saver = new SaveToZipFile((OpcPackage)wordMLPackage);
        BindingHandler.setHyperlinkStyle((String)"Hyperlink");
        startTime = System.currentTimeMillis();
        AtomicInteger bookmarkId = new AtomicInteger();
        BindingHandler bh = new BindingHandler(wordMLPackage);
        bh.setStartingIdForNewBookmarks(bookmarkId);
        bh.applyBindings((JaxbXmlPart)wordMLPackage.getMainDocumentPart());
        endTime = System.currentTimeMillis();
        timingSummary.append("\nBindingHandler.applyBindings: " + (endTime - startTime));
        saver.save(filepathprefix + "_3_bound.docx");
        System.out.println("Saved: " + filepathprefix + "_3_bound.docx");
        startTime = System.currentTimeMillis();
        RemovalHandler rh = new RemovalHandler();
        rh.removeSDTs(wordMLPackage, RemovalHandler.Quantifier.ALL, new String[0]);
        endTime = System.currentTimeMillis();
        timingSummary.append("\nRemovalHandler: " + (endTime - startTime));
        saver.save(filepathprefix + "_4_stripped.docx");
        System.out.println("Saved: " + filepathprefix + "_4_stripped.docx");
        System.out.println(timingSummary);
    }

    public static void reverter(String inputfilepath, String instancePath) throws Docx4JException {
        WordprocessingMLPackage instancePkg = WordprocessingMLPackage.load((File)new File(instancePath));
        OpenDoPEReverter reverter = new OpenDoPEReverter(WordprocessingMLPackage.load((File)new File(inputfilepath)), instancePkg);
        System.out.println("reverted? " + reverter.revert());
        SaveToZipFile saver = new SaveToZipFile((OpcPackage)instancePkg);
        saver.save(filepathprefix + "_5_reverted.docx");
        System.out.println("Saved: " + filepathprefix + "_5_reverted.docx");
    }
}

